/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.awt.LabelRenderer;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.pf.ui.tree.SyncMappedTree;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.MappedTree;
import de.grogra.util.Tree;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class SwingTree
extends JTree
implements ComponentWrapper,
Command,
CellEditorListener {
    DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private static final EmptyBorder BORDER = new EmptyBorder(1, 0, 1, 0);
    private Listener listener;
    boolean initialized = false;
    private static final TreeCellRenderer RENDERER = new TreeCellRenderer(){

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            SwingTree swingTree = (SwingTree)jTree;
            Component component = swingTree.dr.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(BORDER);
                if (swingTree.initialized) {
                    ((JLabel)component).setIcon(((SyncTree)((Object)swingTree.getModel())).getData(object, bl2).getIcon());
                }
            }
            return component;
        }
    };

    SwingTree(UITree uITree) {
        super((TreeModel)null);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(true);
        this.setRootVisible(false);
        this.setCellRenderer(RENDERER);
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.addKeyListener(this.listener);
        SyncTree syncTree = new SyncTree(uITree);
        syncTree.component = this;
        this.setModel((TreeModel)((Object)syncTree));
        this.initialized = true;
        this.getCellEditor().addCellEditorListener(this);
    }

    public void editingStopped(ChangeEvent changeEvent) {
        this.actionPerformed(null, "rename", this.getCellEditor().getCellEditorValue(), this.getEditingPath().getLastPathComponent());
    }

    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        return this.initialized ? ((SyncTree)((Object)this.getModel())).getData(object, bl2).getText() : "";
    }

    public Object getComponent() {
        return this;
    }

    public void dispose() {
        this.setModel(null);
        this.removeKeyListener(this.listener);
        this.removeMouseListener(this.listener);
        this.listener = null;
    }

    UITree getUITree() {
        return (UITree)((SyncMappedTree)this.getModel()).getSourceTree();
    }

    static Object getNode(Object object) {
        return ((MappedTree.Node)object).getSourceNode();
    }

    void actionPerformed(InputEvent inputEvent, String string, Object object, Object object2) {
        Context context = this.getUITree().getContext();
        UI.getJobManager((Context)context).runLater((Command)this, (Object)new ActionEditEvent(string, object, inputEvent != null ? inputEvent.getModifiers() : 0).set(context, SwingTree.getNode(object2)), context, 10000);
    }

    public String getCommandName() {
        return null;
    }

    public void run(Object object, Context context) {
        this.getUITree().eventOccured(((EditEvent)object).getSource(), (EventObject)((EditEvent)object));
    }

    public void setRowHeight(int n) {
        super.setRowHeight(0);
    }

    private static class SyncTree
    extends SyncMappedTree {
        SwingTree component;
        LabelRenderer render;
        IconAdapter icon = new IconAdapter(null, null, 0, 0, true, 0);

        SyncTree(UITree uITree) {
            super((TreeModel)uITree, uITree.getRoot(), (Synchronizer)new AWTSynchronizer(null));
        }

        public Object createNode(Object object, Object object2) {
            if (this.render == null) {
                this.render = new LabelRenderer(((UITree)this.getSourceTree()).getContext(), 32, true){

                    protected void updateNodes(LabelRenderer.LabelData[] labelDataArray, boolean bl) {
                        Object[] objectArray = new Object[1];
                        int[] nArray = new int[1];
                        TreePath treePath = null;
                        Node node = null;
                        for (int i = labelDataArray.length - 1; i >= 0; --i) {
                            TreeModelEvent treeModelEvent;
                            Node node2 = (Node)((Object)labelDataArray[i].getUserData());
                            if (!SyncTree.this.hasValidPath((Tree.Node)node2)) continue;
                            if (node2.parent == null) {
                                if (node != node2) {
                                    node = node2;
                                    treePath = node2.getTreePath();
                                }
                                treeModelEvent = new TreeModelEvent((Object)SyncTree.this, treePath, null, null);
                            } else {
                                if (node != node2.parent) {
                                    node = (Node)node2.parent;
                                    treePath = node.getTreePath();
                                }
                                nArray[0] = SyncTree.this.getIndexOfChild((Tree.Node)node2);
                                objectArray[0] = node2;
                                treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
                            }
                            SyncTree.this.fireTreeModelEvent(0, treeModelEvent);
                        }
                        if (bl) {
                            Enumeration<TreePath> enumeration = SyncTree.this.component.getExpandedDescendants(((Node)((Object)SyncTree.this.getRoot())).getTreePath());
                            objectArray[0] = SyncTree.this.getRoot();
                            SyncTree.this.fireTreeModelEvent(3, new TreeModelEvent((Object)this, objectArray));
                            if (enumeration != null) {
                                while (enumeration.hasMoreElements()) {
                                    SyncTree.this.component.setExpandedState(enumeration.nextElement(), true);
                                }
                            }
                        }
                    }

                    protected String getText(LabelRenderer.LabelData labelData) {
                        return String.valueOf(((UITree)SyncTree.this.getSourceTree()).getDescription(((Node)((Object)labelData.getUserData())).getSourceNode(), "Name"));
                    }

                    protected IconSource getIconSource(LabelRenderer.LabelData labelData) {
                        Object object = ((Node)((Object)labelData.getUserData())).getSourceNode();
                        IconSource iconSource = (IconSource)((UITree)SyncTree.this.getSourceTree()).getDescription(object, "Icon");
                        if (iconSource == null && !SyncTree.this.getSourceTree().isLeaf(object)) {
                            iconSource = (IconSource)UI.I18N.getObject(((Node)((Object)labelData.getUserData())).expandedData == labelData ? "registry.open-directory.Icon" : "registry.directory.Icon");
                        }
                        return iconSource;
                    }
                };
            }
            return new Node(this.render, object);
        }

        protected void insertSync(Object object, int n, Object object2, Object object3) {
            super.insertSync(object, n, object2, object3);
            if (this.component != null) {
                this.component.makeVisible(((Node)((Object)object2)).getTreePath());
            }
        }

        protected void valueForPathChangedSync(TreePath treePath, Object object) {
            super.valueForPathChangedSync(treePath, object);
            ((Node)((Object)treePath.getLastPathComponent())).renderData.invalidate();
            ((Node)((Object)treePath.getLastPathComponent())).expandedData.invalidate();
        }

        LabelRenderer.LabelData getData(Object object, boolean bl) {
            Node node = (Node)((Object)object);
            LabelRenderer.LabelData labelData = bl ? node.expandedData : node.renderData;
            labelData.revalidate();
            return labelData;
        }

        private static class Node
        extends MappedTree.Node {
            final LabelRenderer.LabelData renderData;
            final LabelRenderer.LabelData expandedData;

            Node(LabelRenderer labelRenderer, Object object) {
                super(object);
                LabelRenderer labelRenderer2 = labelRenderer;
                labelRenderer2.getClass();
                this.renderData = labelRenderer2.new LabelRenderer.LabelData((Object)this);
                LabelRenderer labelRenderer3 = labelRenderer;
                labelRenderer3.getClass();
                this.expandedData = labelRenderer3.new LabelRenderer.LabelData((Object)this);
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements KeyListener {
        private Listener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = SwingTree.this.getSelectionPath();
            if (treePath != null && SwingTree.this.getModel().isLeaf(treePath.getLastPathComponent()) && SwingTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == SwingTree.this.getRowForPath(treePath)) {
                mouseEvent.consume();
                SwingTree.this.actionPerformed(mouseEvent, mouseEvent.getClickCount() == 1 ? "select" : "open", null, treePath.getLastPathComponent());
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    TreePath treePath = SwingTree.this.getSelectionPath();
                    if (treePath == null || !SwingTree.this.getModel().isLeaf(treePath.getLastPathComponent())) break;
                    keyEvent.consume();
                    SwingTree.this.actionPerformed(keyEvent, "open", null, treePath.getLastPathComponent());
                    break;
                }
                case 127: {
                    TreePath treePath = SwingTree.this.getSelectionPath();
                    if (treePath == null) break;
                    keyEvent.consume();
                    SwingTree.this.actionPerformed(keyEvent, "delete", null, treePath.getLastPathComponent());
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

