/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Synchronizer;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.AWTSynchronizer;
import de.grogra.pf.ui.awt.MappedComponentModel;
import de.grogra.pf.ui.swing.ISwingPanel;
import de.grogra.pf.ui.swing.MenuModel;
import de.grogra.pf.ui.swing.RootPane;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.pf.ui.swing.ToolBar;
import de.grogra.pf.ui.swing.ToolBarModel;
import de.grogra.pf.ui.swing.WindowSupport;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.util.UIPropertyUpdater;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PanelSupport
implements Panel,
Synchronizer.Callback,
RegistryContext {
    protected WindowSupport ws;
    protected ModifiableMap.Producer mapProducer;
    protected final AWTSynchronizer sync = new AWTSynchronizer(this);
    JComponent textViewer;
    private String panelId;
    private final ISwingPanel panel;
    private final SwingDockable dpanel;
    protected MappedComponentModel menu = null;
    private ComponentWrapper content = null;
    private boolean disposed = false;
    private boolean docked;
    private Panel decorator;
    private final HashMap propertyMap = new HashMap();
    private static final int CLOSE_DOCKABLE = 0;
    private static final int SET_MENU = 1;
    private static final int SET_CONTENT = 2;
    private static final int SET_VISIBLE = 3;
    protected static final int MIN_UNUSED_ACTION = 4;
    static final int MIN_PANEL_ACTION = 100;
    private final Object cursorLock = new Object();
    private int waitingCursorCount = 0;
    private int nonwaitingCursor = -4;
    private final Command CHECK_CLOSE = new CloseHelper(null);

    protected PanelSupport(SwingDockable swingDockable) {
        this(swingDockable, swingDockable);
    }

    protected PanelSupport(RootPane rootPane) {
        this(rootPane, null);
    }

    private PanelSupport(ISwingPanel iSwingPanel, SwingDockable swingDockable) {
        this.panel = iSwingPanel;
        this.dpanel = swingDockable;
        this.docked = swingDockable != null;
    }

    static PanelSupport get(Component component) {
        while (component != null) {
            if (component instanceof ISwingPanel) {
                return ((ISwingPanel)((Object)component)).getSupport();
            }
            component = component.getParent();
        }
        return null;
    }

    public final PanelSupport initialize(WindowSupport windowSupport, Map map) {
        this.ws = windowSupport;
        this.panelId = (String)map.get((Object)"panelId", (Object)this.panelId);
        this.panel.initialize(this, map);
        this.configure(map);
        return this;
    }

    public void initDecorator(Panel panel) {
        this.decorator = panel;
    }

    public Panel getDecorator() {
        return this.decorator;
    }

    Panel unresolve() {
        PanelSupport panelSupport = this;
        while (panelSupport.getDecorator() != null) {
            panelSupport = panelSupport.getDecorator();
        }
        return panelSupport;
    }

    public java.util.Map getUIPropertyMap() {
        return this.propertyMap;
    }

    void addParameters(ModifiableMap modifiableMap) {
        if (this.mapProducer != null) {
            this.mapProducer.addMappings(modifiableMap);
        }
        PanelSupport panelSupport = this;
        while ((panelSupport = panelSupport.getDecorator()) != null) {
            if (!(panelSupport instanceof ModifiableMap.Producer)) continue;
            ((ModifiableMap.Producer)panelSupport).addMappings(modifiableMap);
        }
    }

    protected void configure(Map map) {
    }

    public String getPanelId() {
        return this.panelId;
    }

    public Workbench getWorkbench() {
        return this.ws.getWorkbench();
    }

    public Window getWindow() {
        return this.ws;
    }

    public Panel getPanel() {
        return this;
    }

    public Object getComponent() {
        return this.panel;
    }

    public Registry getRegistry() {
        return this.getWorkbench().getRegistry();
    }

    public Panel resolve() {
        return this;
    }

    public Object run(int n, int n2, Object object, Object object2) {
        switch (n) {
            case 0: {
                this.ws.dockManager.closeDockable(this.dpanel);
                break;
            }
            case 1: {
                this.panel.setMenu(this.menu != null ? (Component)this.menu.getRoot() : null);
                if (this.dpanel != null) {
                    this.dpanel.revalidate();
                    break;
                }
                this.ws.manager.revalidate(this.panel);
                break;
            }
            case 2: {
                Container container = this.dpanel.getContentPane();
                container.removeAll();
                if (object != null) {
                    container.add((Component)object);
                }
                container.repaint();
                this.dpanel.revalidate();
                break;
            }
            case 3: {
                this.setVisibleSync(n2 != 0, (Panel)object, Boolean.TRUE.equals(object2));
                break;
            }
            default: {
                if (n < 100 || !(this.panel instanceof Synchronizer.Callback)) {
                    throw new AssertionError((Object)("Illegal action code: " + n));
                }
                return ((Synchronizer.Callback)this.panel).run(n, n2, object, object2);
            }
        }
        return null;
    }

    public void setMenu(UITree uITree) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (uITree != null) {
            this.menu = this.panel instanceof ToolBar ? new ToolBarModel(uITree, (ToolBar)this.panel) : new MenuModel(uITree, null, false);
            this.menu.map(true);
        }
        this.sync.invokeAndWait(1);
    }

    public UITree getMenu() {
        return this.menu.getSourceTree();
    }

    public void setContent(ComponentWrapper componentWrapper) {
        if (this.content != null) {
            this.content.dispose();
        }
        this.content = componentWrapper;
        this.sync.invokeAndWait(2, componentWrapper != null ? componentWrapper.getComponent() : null);
    }

    public ComponentWrapper getContent() {
        return this.content;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.docked) {
            this.docked = false;
            this.sync.invokeAndWait(0);
        }
        this.setMenu(null);
        this.setContent(null);
        this.disposeImpl();
    }

    public final void show(boolean bl, Panel panel) {
        this.sync.invokeAndWait(3, 1, panel, bl);
    }

    public final void hide() {
        this.sync.invokeAndWait(3, 0, null, null);
    }

    void setVisibleSync(boolean bl, Panel panel, boolean bl2) {
        if (bl) {
            if (SwingUtilities.getWindowAncestor((Component)((Object)this.dpanel)) == null) {
                this.ws.dockManager.createFloatingWindow(this.dpanel).setVisible(true);
            } else {
                this.ws.dockManager.select(this.dpanel, bl2, panel == null ? null : PanelSupport.get((Component)((Component)panel.resolve().getComponent())).dpanel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(int n) {
        Object object = this.cursorLock;
        synchronized (object) {
            if (n == -2) {
                ++this.waitingCursorCount;
            } else if (n == -3) {
                --this.waitingCursorCount;
            } else {
                this.nonwaitingCursor = n;
            }
            final int n2 = this.waitingCursorCount > 0 ? 3 : this.nonwaitingCursor;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ((Component)((Object)PanelSupport.this.panel)).setCursor(n2 == -4 ? null : Cursor.getPredefinedCursor(n2));
                }
            });
        }
    }

    protected void disposeImpl() {
        this.panel.dispose();
    }

    void dockableClosed() {
        this.docked = false;
        if (!this.disposed) {
            this.ws.getWorkbench().getJobManager().execute(Command.DISPOSE, (Object)this, (Context)this.ws, 10000);
        }
    }

    void installUpdater(UIProperty uIProperty, boolean bl, String string, Map map) {
        UIPropertyUpdater.install((UIProperty)uIProperty, (Context)this, (boolean)bl, (String)string, (Executor)((Object)AWTSynchronizer.QUEUE), (Map)map);
    }

    public void checkClose(Runnable runnable) {
        runnable.run();
    }

    protected void executeCheckClose(Runnable runnable) {
        this.getWorkbench().getJobManager().execute(this.CHECK_CLOSE, (Object)new CloseHelper(runnable), (Context)this, 10000);
    }

    public void checkClose(Command command) {
        command.run(null, (Context)this);
    }

    public String toString() {
        return super.toString() + "[panelId=" + this.getPanelId() + ']';
    }

    private final class CloseHelper
    implements Command {
        private final Runnable ok;

        CloseHelper(Runnable runnable) {
            this.ok = runnable;
        }

        public void run(Object object, Context context) {
            if (this.ok == null) {
                PanelSupport.this.checkClose((Command)object);
            } else {
                try {
                    EventQueue.invokeAndWait(this.ok);
                }
                catch (Exception exception) {
                    context.getWorkbench().logInfo("Exception", (Throwable)exception);
                }
            }
        }

        public String getCommandName() {
            return null;
        }
    }
}

