/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.data.DatasetAdapter;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.ChartPanel;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.Utils;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

class ChartSupport
extends PanelSupport
implements ChartPanel,
ModifiableMap.Producer {
    private final CPanel panel;
    private Dataset dataset;
    private int plot;

    public ChartSupport() {
        super(new SwingPanel(null));
        Container container = ((SwingPanel)this.getComponent()).getContentPane();
        container.setLayout(new GridLayout(1, 1));
        this.panel = new CPanel();
        container.add(this.panel);
        this.mapProducer = this;
    }

    protected void configure(Map map) {
        Object object;
        Item item;
        super.configure(map);
        String string = (String)map.get((Object)"dataset", null);
        if (string != null && (item = Item.resolveItem((RegistryContext)this.getWorkbench(), (String)string)) instanceof ObjectItem && (object = ((ObjectItem)item).getObject()) instanceof Dataset) {
            this.setChart((Dataset)object, Utils.getInt((Map)map, (Object)"plot", (int)4), map);
        }
    }

    protected void disposeImpl() {
        super.disposeImpl();
        this.disposeChart();
    }

    private void disposeChart() {
        JFreeChart jFreeChart = this.panel.getChart();
        if (jFreeChart != null) {
            this.panel.setChart(null);
            jFreeChart.getPlot().dispose();
        }
    }

    public void addMappings(ModifiableMap modifiableMap) {
        if (this.dataset.getProvider() instanceof ObjectItem) {
            modifiableMap.put((Object)"dataset", (Object)((ObjectItem)this.dataset.getProvider()).getAbsoluteName());
        }
        modifiableMap.put((Object)"plot", (Object)this.plot);
    }

    public void setChart(Dataset dataset, int n, Map map) {
        int n2;
        Cloneable cloneable;
        Cloneable cloneable2;
        JFreeChart jFreeChart;
        DatasetAdapter datasetAdapter;
        this.dataset = dataset;
        if (n != -1) {
            this.plot = n;
        }
        this.disposeChart();
        String string = dataset.getTitle();
        String string2 = dataset.getCategoryLabel();
        String string3 = dataset.getValueLabel();
        DatasetAdapter datasetAdapter2 = datasetAdapter = dataset.asDatasetAdapter();
        switch (n & 0x1F) {
            case 0: {
                jFreeChart = ChartFactory.createAreaChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 1: {
                jFreeChart = ChartFactory.createStackedAreaChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 2: {
                jFreeChart = ChartFactory.createBarChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 102: {
                jFreeChart = ChartFactory.createBarChart3D(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 11: {
                jFreeChart = ChartFactory.createBarChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.HORIZONTAL, true, false, false);
                break;
            }
            case 111: {
                jFreeChart = ChartFactory.createBarChart3D(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.HORIZONTAL, true, false, false);
                break;
            }
            case 3: {
                jFreeChart = ChartFactory.createStackedBarChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 103: {
                jFreeChart = ChartFactory.createStackedBarChart3D(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 4: {
                jFreeChart = ChartFactory.createLineChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 104: {
                jFreeChart = ChartFactory.createLineChart3D(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 5: {
                jFreeChart = ChartFactory.createPieChart(string, (PieDataset)datasetAdapter, true, false, false);
                break;
            }
            case 105: {
                jFreeChart = ChartFactory.createPieChart3D(string, (PieDataset)datasetAdapter, true, false, false);
                break;
            }
            case 13: {
                jFreeChart = ChartFactory.createTimeSeriesChart(string, string2, string3, (XYDataset)datasetAdapter, true, false, false);
                break;
            }
            case 6: {
                jFreeChart = ChartFactory.createScatterPlot(string, string2, string3, (XYDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 7: {
                jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, (XYDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 8: {
                jFreeChart = ChartFactory.createHistogram(string, string2, string3, (IntervalXYDataset)dataset.toHistogram(), PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 12: {
                jFreeChart = ChartFactory.createWaterfallChart(string, string2, string3, (CategoryDataset)datasetAdapter, PlotOrientation.VERTICAL, true, false, false);
                break;
            }
            case 10: {
                datasetAdapter2 = dataset.toStatistics();
            }
            case 9: {
                jFreeChart = ChartFactory.createBarChart(string, string2, string3, (CategoryDataset)datasetAdapter2, PlotOrientation.VERTICAL, true, false, false);
                cloneable2 = (BarRenderer)((CategoryPlot)jFreeChart.getPlot()).getRenderer();
                cloneable = new StatisticalBarRenderer();
                ((AbstractRenderer)cloneable).setNegativeItemLabelPosition(((AbstractRenderer)cloneable2).getNegativeItemLabelPosition());
                ((AbstractRenderer)cloneable).setPositiveItemLabelPosition(((AbstractRenderer)cloneable2).getPositiveItemLabelPosition());
                ((CategoryPlot)jFreeChart.getPlot()).setRenderer((CategoryItemRenderer)((Object)cloneable));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        cloneable2 = jFreeChart.getPlot();
        if ((n & 0x20) != 0 && cloneable2 instanceof XYPlot) {
            cloneable = (XYPlot)cloneable2;
            for (n2 = 0; n2 < ((XYPlot)cloneable).getDomainAxisCount(); ++n2) {
                ((XYPlot)cloneable).setDomainAxis(n2, ChartSupport.toLogAxis(((XYPlot)cloneable).getDomainAxis(n2)));
            }
        }
        if ((n & 0x40) != 0) {
            if (cloneable2 instanceof XYPlot) {
                cloneable = (XYPlot)cloneable2;
                for (n2 = 0; n2 < ((XYPlot)cloneable).getRangeAxisCount(); ++n2) {
                    ((XYPlot)cloneable).setRangeAxis(n2, ChartSupport.toLogAxis(((XYPlot)cloneable).getRangeAxis(n2)));
                }
            } else if (cloneable2 instanceof CategoryPlot) {
                cloneable = (CategoryPlot)cloneable2;
                for (n2 = 0; n2 < ((CategoryPlot)cloneable).getRangeAxisCount(); ++n2) {
                    ((CategoryPlot)cloneable).setRangeAxis(n2, ChartSupport.toLogAxis(((CategoryPlot)cloneable).getRangeAxis(n2)));
                }
            }
        }
        this.panel.setChart(jFreeChart);
    }

    private static LogarithmicAxis toLogAxis(ValueAxis valueAxis) {
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis(valueAxis.getLabel());
        logarithmicAxis.setAllowNegativesFlag(true);
        logarithmicAxis.setStrictValuesFlag(false);
        return logarithmicAxis;
    }

    static class CPanel
    extends org.jfree.chart.ChartPanel
    implements Command {
        private boolean pending;
        private boolean pendingScale;
        private Rectangle2D pendingBounds;
        private Object lock = new Object();

        CPanel() {
            super(null, 680, 420, 300, 200, 800, 600, true, true, false, true, true, true);
        }

        public String getCommandName() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Object object, Context context) {
            Rectangle2D rectangle2D;
            boolean bl;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.pendingBounds != object) {
                    return;
                }
                bl = this.pendingScale;
                rectangle2D = this.pendingBounds;
                this.pending = false;
            }
            super.drawChart(bl, rectangle2D);
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void drawChart(boolean bl, Rectangle2D rectangle2D) {
            PanelSupport panelSupport = PanelSupport.get(this);
            if (panelSupport == null) {
                super.drawChart(bl, rectangle2D);
            } else {
                Object object = this.lock;
                synchronized (object) {
                    if (this.pending && this.pendingScale == bl && this.pendingBounds.equals(rectangle2D)) {
                        return;
                    }
                    this.pending = true;
                    this.pendingScale = bl;
                    this.pendingBounds = (Rectangle2D)rectangle2D.clone();
                }
                UI.getJobManager((Context)panelSupport).runLater(100L, (Command)this, (Object)this.pendingBounds, (Context)panelSupport);
            }
        }
    }
}

