/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.icon.IconSource;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.RenderedIcon;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.awt.AWTToolkitBase;
import de.grogra.util.Map;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public abstract class LabelRenderer
implements Command {
    final Context context;
    final int defaultHeight;
    final boolean smallIcons;
    final ObjectList nodes = new ObjectList();

    public LabelRenderer(Context context, int n, boolean bl) {
        this.context = context;
        this.defaultHeight = n;
        this.smallIcons = bl;
    }

    public synchronized void run(Object object, Context context) {
        boolean bl = false;
        int n = this.nodes.size;
        Object[] objectArray = this.nodes.elements;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            LabelData labelData = (LabelData)objectArray[i];
            if (!labelData.invalid) continue;
            String string = this.getText(labelData);
            boolean bl2 = false;
            if (!string.equals(labelData.text)) {
                labelData.text = string;
                bl2 = true;
            }
            IconSource iconSource = this.getIconSource(labelData);
            labelData.iconType = 0;
            if (iconSource != null) {
                Object object2;
                Object object3;
                Dimension dimension = iconSource.getPreferredIconSize(this.smallIcons);
                if (dimension == null) {
                    dimension = AWTToolkitBase.MENU_ICON_SIZE;
                }
                int n3 = dimension.width;
                int n4 = dimension.height;
                de.grogra.icon.Icon icon = iconSource.getIcon(dimension, 0);
                bl2 |= icon.isMutable();
                if (icon instanceof RenderedIcon) {
                    object3 = (RenderedIcon)icon;
                    n4 = this.defaultHeight > 0 ? this.defaultHeight : Utils.getInt((Map)UI.getOptions((Context)context), (Object)"iconsize", (int)AWTToolkitBase.MENU_ICON_SIZE.height);
                    n3 = Math.round((float)n4 * object3.getSizeRatio());
                    object2 = labelData.iconBuffer;
                    if (object2 == null || ((BufferedImage)object2).getWidth() != n3 || ((BufferedImage)object2).getHeight() != n4) {
                        object2 = new BufferedImage(n3, n4, 2);
                        labelData.iconBuffer = object2;
                    }
                    labelData.renderY = 0;
                    labelData.image = object2;
                    labelData.renderedIcon = (RenderedIcon)icon;
                    labelData.iconType = 3;
                    labelData.bounds = icon.getIconBounds();
                } else {
                    labelData.image = icon.getImage(n3, n4);
                    if (labelData.image != null) {
                        labelData.iconType = 2;
                        labelData.bounds = null;
                    } else {
                        labelData.image = icon.getImage();
                        if (labelData.image != null) {
                            labelData.iconType = 2;
                            labelData.bounds = icon.getIconBounds();
                        } else {
                            labelData.iconType = 1;
                            object3 = labelData.iconBuffer;
                            if (object3 == null || ((BufferedImage)object3).getWidth() != n3 || ((BufferedImage)object3).getHeight() != n4) {
                                object3 = new BufferedImage(n3, n4, 2);
                                labelData.iconBuffer = object3;
                            }
                            object2 = ((BufferedImage)object3).createGraphics();
                            icon.paintIcon(null, (Graphics2D)object2, 0, 0, n3, n4, 0);
                            ((Graphics)object2).dispose();
                        }
                    }
                }
                if (labelData.width != n3 || labelData.height != n4) {
                    bl2 = true;
                    bl = true;
                    labelData.width = n3;
                    labelData.height = n4;
                    labelData.invalidate();
                }
            }
            labelData.invalid = false;
            if (!bl2) continue;
            objectArray[n2++] = labelData;
        }
        if (n2 > 0) {
            LabelData[] labelDataArray = new LabelData[n2];
            System.arraycopy(objectArray, 0, labelDataArray, 0, n2);
            this.invokeUpdate(labelDataArray, bl);
        }
        this.nodes.setSize(0);
    }

    private void invokeUpdate(final LabelData[] labelDataArray, final boolean bl) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LabelRenderer.this.updateNodes(labelDataArray, bl);
            }
        });
    }

    public String getCommandName() {
        return null;
    }

    protected abstract String getText(LabelData var1);

    protected abstract IconSource getIconSource(LabelData var1);

    protected abstract void updateNodes(LabelData[] var1, boolean var2);

    public class LabelData
    implements Icon,
    Command {
        final Object userData;
        boolean invalid = true;
        String text = "";
        RenderedIcon renderedIcon;
        BufferedImage iconBuffer;
        int renderY;
        int stamp;
        Image image;
        Rectangle bounds;
        int width;
        int height;
        static final int NO_ICON = 0;
        static final int ICON_BUFFER = 1;
        static final int IMAGE = 2;
        static final int RENDER = 3;
        int iconType = 0;

        public LabelData(Object object) {
            this.userData = object;
        }

        public Object getUserData() {
            return this.userData;
        }

        public String getText() {
            return this.text;
        }

        public Icon getIcon() {
            return this.iconType != 0 ? this : null;
        }

        public void invalidate() {
            this.invalid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void revalidate() {
            if (this.invalid) {
                boolean bl;
                LabelRenderer labelRenderer = LabelRenderer.this;
                synchronized (labelRenderer) {
                    bl = LabelRenderer.this.nodes.isEmpty();
                    LabelRenderer.this.nodes.add((Object)this);
                }
                if (bl) {
                    UI.getJobManager((Context)LabelRenderer.this.context).execute((Command)LabelRenderer.this, null, LabelRenderer.this.context, 70536);
                }
            }
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            JobManager jobManager = UI.getJobManager((Context)LabelRenderer.this.context);
            this.stamp = this.renderedIcon.getStamp();
            this.renderY = this.renderedIcon.renderImage(jobManager, this.iconBuffer, this.renderY);
            if (this.renderY < this.height) {
                jobManager.cancelQueuedJob((Command)this);
                jobManager.runLater((Command)this, null, LabelRenderer.this.context, 66536);
            }
            LabelRenderer.this.invokeUpdate(new LabelData[]{this}, false);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            switch (this.iconType) {
                case 1: {
                    graphics.drawImage(this.iconBuffer, n, n2, null);
                    break;
                }
                case 3: {
                    if (this.renderY < this.height || this.stamp != this.renderedIcon.getStamp()) {
                        JobManager jobManager = UI.getJobManager((Context)LabelRenderer.this.context);
                        jobManager.cancelQueuedJob((Command)this);
                        jobManager.runLater((Command)this, null, LabelRenderer.this.context, 66536);
                    }
                }
                case 2: {
                    if (this.bounds != null) {
                        graphics.drawImage(this.image, n, n2, n + this.width, n2 + this.height, this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, null);
                        break;
                    }
                    graphics.drawImage(this.image, n, n2, this.width, this.height, null);
                }
            }
        }

        public String toString() {
            return "LabelData@" + Integer.toHexString(this.hashCode()) + ':' + this.text;
        }
    }
}

