/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.event.ActionEditEvent;
import de.grogra.pf.ui.event.DragEvent;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.pf.ui.registry.CheckBoxItem;
import de.grogra.pf.ui.registry.ChoiceGroup;
import de.grogra.pf.ui.tree.UINodeHandler;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.util.Disposable;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public abstract class ButtonSupport
extends MouseAdapter
implements de.grogra.util.EventListener,
ActionListener,
ItemListener,
MouseMotionListener,
Runnable,
Disposable {
    protected final UITree tree;
    protected Object node;
    protected final String shortDescription;
    protected final int type;
    protected final Object button;
    private static final int NO_DRAGGING = 0;
    private static final int DRAGGING_POSSIBLE = 1;
    private static final int DRAGGING = 2;
    private boolean selected = false;
    private boolean enabled;
    private int state = 0;
    private int lastDragX;
    private int lastDragY;
    private Point dragOrigin = null;
    private Point robotDelta = new Point();
    private Component cursorComponent = null;
    private boolean disposed = false;
    private boolean actionListenerSet = false;
    private ActionListener actionListener;
    private Runnable immediateListener;
    private final WeakHashMap<GraphicsDevice, Robot> robots = new WeakHashMap();

    public ButtonSupport(UITree uITree, Object object, int n, Button button) {
        this(uITree, object, n, (Object)button);
    }

    public ButtonSupport(UITree uITree, Object object, int n, Checkbox checkbox) {
        this(uITree, object, n, (Object)checkbox);
    }

    public ButtonSupport(UITree uITree, Object object, int n, AbstractButton abstractButton) {
        this(uITree, object, n, (Object)abstractButton);
    }

    public ButtonSupport(UITree uITree, Object object, int n, MenuItem menuItem) {
        this(uITree, object, n, (Object)menuItem);
    }

    private ButtonSupport(UITree uITree, Object object, int n, Object object2) {
        this.tree = uITree;
        this.node = object;
        this.type = n;
        this.button = object2;
        this.shortDescription = (String)uITree.getDescription(object, "ShortDescription");
        switch (n) {
            case 2: {
                if (object2 instanceof AbstractButton) {
                    ((AbstractButton)object2).addActionListener(this);
                } else if (object2 instanceof MenuItem) {
                    ((MenuItem)object2).addActionListener(this);
                } else {
                    ((Button)object2).addActionListener(this);
                }
                this.immediateListener = (Runnable)uITree.invoke(object, "getImmediateListener", null);
                break;
            }
            case 5: 
            case 6: {
                UIProperty uIProperty;
                if (object2 instanceof AbstractButton) {
                    ((AbstractButton)object2).addItemListener(this);
                } else if (object2 instanceof CheckboxMenuItem) {
                    ((CheckboxMenuItem)object2).addItemListener(this);
                } else {
                    ((Checkbox)object2).addItemListener(this);
                }
                UIProperty uIProperty2 = uIProperty = n == 5 ? ChoiceGroup.get((UINodeHandler)uITree, (Object)object).getProperty() : CheckBoxItem.get((UINodeHandler)uITree, (Object)object).getProperty();
                if (uIProperty == null) break;
                uIProperty.addPropertyListener(uITree.getContext(), (de.grogra.util.EventListener)this);
                break;
            }
            case 3: {
                ((Component)object2).addMouseListener(this);
                ((Component)object2).addMouseMotionListener(this);
            }
        }
        this.updateInternal();
        this.updateButton();
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.immediateListener = null;
        switch (this.type) {
            case 2: {
                if (this.button instanceof AbstractButton) {
                    ((AbstractButton)this.button).removeActionListener(this);
                    break;
                }
                if (this.button instanceof MenuItem) {
                    ((MenuItem)this.button).removeActionListener(this);
                    break;
                }
                ((Button)this.button).removeActionListener(this);
                break;
            }
            case 5: 
            case 6: {
                UIProperty uIProperty;
                if (this.button instanceof AbstractButton) {
                    ((AbstractButton)this.button).removeItemListener(this);
                } else if (this.button instanceof CheckboxMenuItem) {
                    ((CheckboxMenuItem)this.button).removeItemListener(this);
                } else {
                    ((Checkbox)this.button).removeItemListener(this);
                }
                UIProperty uIProperty2 = uIProperty = this.type == 5 ? ChoiceGroup.get((UINodeHandler)this.tree, (Object)this.node).getProperty() : CheckBoxItem.get((UINodeHandler)this.tree, (Object)this.node).getProperty();
                if (uIProperty == null) break;
                uIProperty.removePropertyListener(this.tree.getContext(), (de.grogra.util.EventListener)this);
                break;
            }
            case 3: {
                ((Component)this.button).removeMouseMotionListener(this);
                ((Component)this.button).removeMouseListener(this);
            }
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListenerSet = true;
        this.actionListener = actionListener;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionListenerSet) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        } else if (this.immediateListener != null) {
            this.immediateListener.run();
        } else {
            this.postAction(actionEvent);
        }
    }

    public void postAction(ActionEvent actionEvent) {
        UI.getJobManager((Context)this.tree.getContext()).runLater((Command)new Dispatcher(new ActionEditEvent(this.shortDescription, actionEvent).set(this.tree.getContext())), null, this.tree.getContext(), 10000);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 || this.type == 6 && itemEvent.getStateChange() == 2) {
            if (this.type == 6 || !this.selected) {
                UI.getJobManager((Context)this.tree.getContext()).runLater((Command)new Dispatcher(new ActionEditEvent(null, (Object)(itemEvent.getStateChange() == 1 ? 1 : 0), 0).set(this.tree.getContext())), null, this.tree.getContext(), 10000);
            }
        } else if (this.selected) {
            this.updateButton();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.state) {
            case 1: {
                this.state = 2;
                this.robotDelta.setLocation(0, 0);
                this.postDrag(0, 0, 0, mouseEvent);
                this.lastDragX = 0;
                this.lastDragY = 0;
            }
            case 2: {
                Point point = new Point(-this.dragOrigin.x, -this.dragOrigin.y);
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                mouseEvent.translatePoint(point.x, point.y);
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.type == 3) {
                    GraphicsConfiguration graphicsConfiguration = mouseEvent.getComponent().getGraphicsConfiguration();
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    Robot robot = this.getRobot(graphicsConfiguration.getDevice());
                    if (robot != null) {
                        mouseEvent.translatePoint(this.robotDelta.x, this.robotDelta.y);
                        if (n != 0 || n2 != 0) {
                            this.robotDelta.translate(n, n2);
                            robot.mouseMove(this.dragOrigin.x - rectangle.x, this.dragOrigin.y - rectangle.y);
                        }
                        n = mouseEvent.getX();
                        n2 = mouseEvent.getY();
                    }
                }
                if (n == this.lastDragX && n2 == this.lastDragY) break;
                this.postDrag(1, n - this.lastDragX, n2 - this.lastDragY, mouseEvent);
                this.lastDragX = n;
                this.lastDragY = n2;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Cursor cursor;
        if (this.type == 3 && (cursor = this.getTransparentCursor()) != null && this.cursorComponent == null) {
            this.cursorComponent = this.getCursorComponent(mouseEvent);
            this.cursorComponent.setCursor(cursor);
        }
        if (this.state != 2) {
            this.state = 1;
            this.dragOrigin = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.dragOrigin, mouseEvent.getComponent());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.cursorComponent != null) {
            this.cursorComponent.setCursor(null);
            this.cursorComponent = null;
        }
        if (this.state == 2) {
            this.state = 0;
            this.postDrag(2, 0, 0, mouseEvent);
        }
    }

    private void postDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        UI.getJobManager((Context)this.tree.getContext()).runLater((Command)new Dispatcher(new DragEvent().setDragData(n, n2, n3).set(mouseEvent).set(this.tree.getContext())), null, this.tree.getContext(), 70536);
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof UIPropertyEditEvent) {
            this.updateState(this.node);
        }
    }

    protected Component getCursorComponent(MouseEvent mouseEvent) {
        return mouseEvent.getComponent();
    }

    public void updateState(Object object) {
        this.node = object;
        if (this.updateInternal()) {
            EventQueue.invokeLater(this);
        }
    }

    private boolean updateInternal() {
        boolean bl = false;
        if (this.enabled != this.tree.isEnabled(this.node)) {
            bl = true;
            boolean bl2 = this.enabled = !this.enabled;
        }
        if (this.type == 5 && this.selected != ChoiceGroup.get((UINodeHandler)this.tree, (Object)this.node).isSelected(this.tree.getContext(), (UINodeHandler)this.tree, this.node) || this.type == 6 && this.selected != CheckBoxItem.get((UINodeHandler)this.tree, (Object)this.node).getValue(this.tree.getContext())) {
            bl = true;
            this.selected = !this.selected;
        }
        return bl;
    }

    public void run() {
        this.updateButton();
    }

    private void updateButton() {
        if (this.button instanceof Component) {
            ((Component)this.button).setEnabled(this.enabled);
        } else {
            ((MenuItem)this.button).setEnabled(this.enabled);
        }
        if (this.type == 5 || this.type == 6) {
            if (this.button instanceof AbstractButton) {
                ((AbstractButton)this.button).setSelected(this.selected);
            } else if (this.button instanceof CheckboxMenuItem) {
                ((CheckboxMenuItem)this.button).setState(this.selected);
            } else {
                ((Checkbox)this.button).setState(this.selected);
            }
        }
    }

    private static ButtonSupport get(EventListener[] eventListenerArray) {
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            if (!(eventListenerArray[i] instanceof ButtonSupport)) continue;
            return (ButtonSupport)eventListenerArray[i];
        }
        return null;
    }

    public static ButtonSupport get(Object object) {
        if (object instanceof CheckboxMenuItem) {
            return ButtonSupport.get(((CheckboxMenuItem)object).getItemListeners());
        }
        if (object instanceof MenuItem) {
            return ButtonSupport.get(((MenuItem)object).getActionListeners());
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            ButtonSupport buttonSupport = ButtonSupport.get(component.getListeners(ActionListener.class));
            if (buttonSupport != null) {
                return buttonSupport;
            }
            buttonSupport = ButtonSupport.get(component.getListeners(ItemListener.class));
            if (buttonSupport != null) {
                return buttonSupport;
            }
            buttonSupport = ButtonSupport.get(component.getListeners(MouseListener.class));
            if (buttonSupport != null) {
                return buttonSupport;
            }
        }
        return null;
    }

    protected abstract Cursor getTransparentCursor();

    protected abstract Robot getRobot();

    protected Robot getRobot(GraphicsDevice graphicsDevice) {
        Robot robot = this.robots.get(graphicsDevice);
        if (robot == null) {
            try {
                robot = new Robot(graphicsDevice);
            }
            catch (AWTException aWTException) {
                robot = this.getRobot();
            }
            this.robots.put(graphicsDevice, robot);
        }
        return robot;
    }

    private final class Dispatcher
    implements Command {
        private final EditEvent event;

        Dispatcher(EditEvent editEvent) {
            this.event = editEvent;
        }

        public String getCommandName() {
            return this.event instanceof ActionEditEvent ? ((ActionEditEvent)this.event).getName() : null;
        }

        public void run(Object object, Context context) {
            if (this.event instanceof ActionEditEvent && (ButtonSupport.this.type == 6 || !ButtonSupport.this.selected) || this.event instanceof DragEvent) {
                ButtonSupport.this.tree.eventOccured(ButtonSupport.this.node, (EventObject)this.event);
            }
        }
    }
}

