/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableComponent;
import de.grogra.docking.DockableWrapper;
import de.grogra.docking.DragDockableContext;
import de.grogra.docking.DragSourceComponent;
import de.grogra.docking.FixedSize;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JToolBar;

public class DockableToolBar
extends JToolBar
implements Dockable,
DragSourceComponent,
FixedSize {
    private String panelTitle;
    private String tabTitle;
    private Icon icon;
    private DockManager manager = null;
    private boolean closable;
    private Object[] listeners;

    public DockableToolBar() {
        this.setFloatable(true);
        this.setToolTipText("ToolTIP");
    }

    public void setManager(DockManager dockManager) {
        if (dockManager != this.manager) {
            this.manager = dockManager;
            DockManager.uninstallListeners(this.listeners);
            if (dockManager != null) {
                this.listeners = dockManager.installListeners((Component)this, (DragGestureListener)dockManager, this);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.firePropertyChange("icon", this.icon, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setTabTitle(String string) {
        this.tabTitle = string;
        this.firePropertyChange("tabTitle", this.tabTitle, this.tabTitle);
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    public void setPanelTitle(String string) {
        this.panelTitle = string;
        this.firePropertyChange("panelTitle", this.panelTitle, this.panelTitle);
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public void setTitles(String string) {
        this.setPanelTitle(string);
        this.setTabTitle(string);
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public Dockable getDockable() {
        return this;
    }

    public DockableComponent getComponent() {
        return this;
    }

    public void setWrapper(DockableWrapper dockableWrapper) {
        throw new UnsupportedOperationException();
    }

    public void setClosable(boolean bl) {
        this.closable = bl;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void dockableClosed() {
        this.setManager(null);
    }

    public DragDockableContext createContext(DragGestureEvent dragGestureEvent) {
        return new DragDockableContext(this.manager, this);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            DockableToolBar.dispatch(mouseEvent, this.listeners[0]);
            DockableToolBar.dispatch(mouseEvent, this.listeners[1]);
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            DockableToolBar.dispatch(mouseEvent, this.listeners[0]);
            DockableToolBar.dispatch(mouseEvent, this.listeners[1]);
        }
    }

    private static void dispatch(MouseEvent mouseEvent, Object object) {
        EventListener eventListener;
        if (object instanceof MouseListener) {
            eventListener = (MouseListener)object;
            switch (mouseEvent.getID()) {
                case 501: {
                    eventListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    eventListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    eventListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    eventListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    eventListener.mouseEntered(mouseEvent);
                }
            }
        }
        if (object instanceof MouseMotionListener) {
            eventListener = (MouseMotionListener)object;
            switch (mouseEvent.getID()) {
                case 503: {
                    eventListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    eventListener.mouseDragged(mouseEvent);
                }
            }
        }
    }

    public int getFixedSize() {
        return this.getOrientation() == 0 ? 2 : 1;
    }

    public boolean needsWrapper() {
        return false;
    }

    public void setOrientation(int n) {
        super.setOrientation(n);
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JToolBar.Separator)) continue;
            ((JToolBar.Separator)component).setOrientation(n == 1 ? 0 : 1);
        }
    }

    public boolean isSelectable() {
        return false;
    }

    public void setSelected(boolean bl) {
    }

    public void checkClose(Runnable runnable) {
        runnable.run();
    }
}

