/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockComponent;
import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.DockMenuListener;
import de.grogra.docking.DockPosition;
import de.grogra.docking.DockPositionList;
import de.grogra.docking.DockShape;
import de.grogra.docking.Dockable;
import de.grogra.docking.DragDockableContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class DockTabbedPane
extends JTabbedPane
implements DockContainer,
DragGestureListener,
PropertyChangeListener {
    private final DockManager manager;
    private final Stack listeners = new Stack();

    public DockTabbedPane(final DockManager dockManager) {
        super(1, 1);
        this.manager = dockManager;
        this.updateRecognizers(this);
        this.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = DockTabbedPane.this.getSelectedComponent();
                if (component instanceof Dockable) {
                    dockManager.select((Dockable)((Object)component), false, null);
                }
            }
        });
    }

    private Object[] installListeners(Component component) {
        return this.manager.installListeners(component, (DragGestureListener)this, new DockMenuListener(this.manager, null){

            protected Dockable getDockable(MouseEvent mouseEvent) {
                return DockTabbedPane.this.getDockable(mouseEvent.getComponent(), mouseEvent.getPoint());
            }
        });
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
        if (this.manager != null && "UI".equals(string)) {
            this.updateRecognizers(this);
        }
    }

    private void updateRecognizers(Component component) {
        if (component == this || component instanceof UIResource) {
            if (component == this) {
                while (!this.listeners.empty()) {
                    DockManager.uninstallListeners((Object[])this.listeners.pop());
                }
            }
            if (component instanceof Container && component.getMouseListeners().length == 0) {
                for (int i = ((Container)component).getComponentCount() - 1; i >= 0; --i) {
                    this.updateRecognizers(((Container)component).getComponent(i));
                }
            }
            this.listeners.push(this.installListeners(component));
        }
    }

    private int myIndexAtLocation(Point point) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getBoundsAt(i).contains(point)) continue;
            return i;
        }
        return -1;
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public DockComponent remove(DockComponent dockComponent) {
        this.remove((Component)((Object)dockComponent));
        ((Dockable)dockComponent).removePropertyChangeListener(this);
        if (this.getTabCount() == 1) {
            dockComponent = (Dockable)((Object)this.getComponentAt(0));
            DockContainer dockContainer = this.getDockParent();
            return dockContainer != null ? dockContainer.replace(this, dockComponent) : dockComponent;
        }
        return this;
    }

    public int getDockComponentCount() {
        return this.getTabCount();
    }

    public DockComponent getDockComponent(int n) {
        return (DockComponent)((Object)this.getComponentAt(n));
    }

    public void findDockPositions(DockPositionList dockPositionList, Point point) {
        int n = this.myIndexAtLocation(point);
        if (n >= 0) {
            dockPositionList.addDockPosition(this.getDockComponent(n), 32, point, new TabShape(n));
        }
    }

    public void add(int n, DockComponent dockComponent) {
        if (!((dockComponent = this.manager.wrap(dockComponent, false)) instanceof Dockable)) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            n = this.getTabCount();
        }
        Dockable dockable = (Dockable)dockComponent;
        this.insertTab(dockable.getTabTitle(), dockable.getIcon(), (Component)((Object)dockComponent), dockable.getToolTipText(), n);
        dockable.addPropertyChangeListener(this);
        this.setSelectedIndex(n);
    }

    public DockComponent replace(DockContainer dockContainer, DockComponent dockComponent) {
        throw new UnsupportedOperationException();
    }

    protected Dockable getDockable(Component component, Point point) {
        while (component != this) {
            point.translate(component.getX(), component.getY());
            component = component.getParent();
        }
        int n = this.myIndexAtLocation(point);
        return n >= 0 ? (Dockable)((Object)this.getComponentAt(n)) : null;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Dockable dockable = this.getDockable(dragGestureEvent.getComponent(), dragGestureEvent.getDragOrigin());
        if (dockable != null) {
            this.manager.dragGestureRecognized(dragGestureEvent, new DragDockableContext(this.manager, this, dockable));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n = this.indexOfComponent((Component)propertyChangeEvent.getSource());
        if (n >= 0) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if ("tabTitle".equals(string)) {
                this.setTitleAt(n, String.valueOf(object));
            } else if ("toolTip".equals(string)) {
                this.setToolTipTextAt(n, String.valueOf(object));
            } else if ("icon".equals(string)) {
                this.setIconAt(n, (Icon)object);
            }
        }
    }

    public void toFront(DockComponent dockComponent) {
        this.setSelectedComponent((Component)((Object)dockComponent));
    }

    private final class TabShape
    implements DockShape {
        private final int index;
        private int lx;
        private int ly;
        private Graphics g;

        TabShape(int n) {
            this.index = n;
        }

        public boolean equals(DockShape dockShape) {
            return dockShape instanceof TabShape && this.index == ((TabShape)dockShape).index && this.getPane() == ((TabShape)dockShape).getPane();
        }

        public void paintDockShape(DockPosition dockPosition, Graphics graphics) {
            graphics.translate(dockPosition.getAbsX(), dockPosition.getAbsY());
            Rectangle rectangle = DockTabbedPane.this.getBoundsAt(this.index);
            this.g = graphics;
            this.lx = rectangle.x;
            this.ly = rectangle.y;
            switch (DockTabbedPane.this.getTabPlacement()) {
                case 1: {
                    this.drawH(rectangle.x + rectangle.width - 1);
                    this.drawV(rectangle.y + rectangle.height - 1);
                    this.drawH(DockTabbedPane.this.getWidth() - 1);
                    this.drawV(DockTabbedPane.this.getHeight() - 1);
                    this.drawH(0);
                    this.drawV(rectangle.y + rectangle.height - 1);
                    break;
                }
                case 3: {
                    this.drawH(0);
                    this.drawV(0);
                    this.drawH(DockTabbedPane.this.getWidth() - 1);
                    this.drawV(rectangle.y);
                    this.drawH(rectangle.x + rectangle.width - 1);
                    this.drawV(DockTabbedPane.this.getHeight() - 1);
                    break;
                }
                case 2: {
                    this.drawH(rectangle.x + rectangle.width - 1);
                    this.drawV(0);
                    this.drawH(DockTabbedPane.this.getWidth() - 1);
                    this.drawV(DockTabbedPane.this.getHeight() - 1);
                    this.drawH(rectangle.x + rectangle.width - 1);
                    this.drawV(rectangle.y + rectangle.height - 1);
                    break;
                }
                case 4: {
                    this.drawH(DockTabbedPane.this.getWidth() - 1);
                    this.drawV(rectangle.y + rectangle.height - 1);
                    this.drawH(rectangle.x);
                    this.drawV(DockTabbedPane.this.getHeight() - 1);
                    this.drawH(0);
                    this.drawV(0);
                }
            }
            this.drawH(rectangle.x);
            this.drawV(rectangle.y);
            this.g = null;
            graphics.translate(-dockPosition.getAbsX(), -dockPosition.getAbsY());
        }

        private void drawH(int n) {
            if (n >= this.lx) {
                this.g.fillRect(this.lx - 2, this.ly - 2, n - this.lx + 4, 5);
            } else {
                this.g.fillRect(n - 2, this.ly - 2, this.lx - n + 4, 5);
            }
            this.lx = n;
        }

        private void drawV(int n) {
            if (n >= this.ly) {
                this.g.fillRect(this.lx - 2, this.ly - 2, 5, n - this.ly + 4);
            } else {
                this.g.fillRect(this.lx - 2, n - 2, 5, this.ly - n + 4);
            }
            this.ly = n;
        }

        private DockTabbedPane getPane() {
            return DockTabbedPane.this;
        }
    }
}

