/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.collision.broadphase.AxisSweep3;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CylinderShapeZ;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.dynamics.constraintsolver.RotationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TranslationalLimitMotor;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.Attribute;
import de.grogra.graph.GraphState;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.imp3d.objects.Frustum;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Sphere;
import de.grogra.math.TMatrix4d;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import de.grogra.turtle.F;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import uk.ac.soton.grophysics.Attributes;
import uk.ac.soton.grophysics.FlexNode;
import uk.ac.soton.grophysics.MassObject;
import uk.ac.soton.grophysics.PhysicsUtils;
import uk.ac.soton.grophysics.PhysicsVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicsModel
extends Node {
    private static final long serialVersionUID = -7481390093150351783L;
    protected DynamicsWorld dynamicWorld;
    private CollisionConfiguration collisionConfiguration;
    private CollisionDispatcher dispatcher;
    RigidBody groundBody;
    float groundDepth = 10.0f;
    Transform groundJointFrame;
    public boolean debugText;
    private ArrayList<MassObject> massObjects;
    final PhysicsVisitor visitor = new PhysicsVisitor();
    public final PhysicsUtils utils = new PhysicsUtils();
    private int autoIndex = 0;
    public static final Node.NType $TYPE = new Node.NType((Node)new PhysicsModel());
    public static final Node.NType.Field debugText$FIELD = new _Field("debugText", 0x200001, Type.BOOLEAN, null, 0);
    public static final Node.NType.Field massObjects$FIELD;

    public PhysicsModel() {
        this.init();
        this.massObjects = new ArrayList();
        this.debugText = false;
        this.initVisitor();
    }

    protected void init() {
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.dispatcher = new CollisionDispatcher(this.collisionConfiguration);
        Vector3f vector3f = new Vector3f(-1000.0f, -1000.0f, -1000.0f);
        Vector3f vector3f2 = new Vector3f(1000.0f, 1000.0f, 1000.0f);
        AxisSweep3 axisSweep3 = new AxisSweep3(vector3f, vector3f2);
        SequentialImpulseConstraintSolver sequentialImpulseConstraintSolver = new SequentialImpulseConstraintSolver();
        this.dynamicWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, (BroadphaseInterface)axisSweep3, (ConstraintSolver)sequentialImpulseConstraintSolver, this.collisionConfiguration);
        this.dynamicWorld.setGravity(new Vector3f(0.0f, 0.0f, -9.81f));
        this.dynamicWorld.getDispatchInfo().allowedCcdPenetration = 0.0f;
        this.addGround(100.0f, this.groundDepth / 2.0f);
    }

    public void initVisitor() {
        GraphState graphState = Library.graph().getMainState();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        this.visitor.init(graphState, matrix4d, this);
    }

    protected void addGround(float f, float f2) {
        BoxShape boxShape = new BoxShape(new Vector3f(f, f, f2));
        boxShape.setUserPointer((Object)"Ground");
        Transform transform = new Transform();
        transform.setIdentity();
        transform.origin.set((Tuple3f)new Vector3f(0.0f, 0.0f, -f2));
        float f3 = 0.0f;
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        DefaultMotionState defaultMotionState = new DefaultMotionState(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f3, (MotionState)defaultMotionState, (CollisionShape)boxShape, vector3f);
        this.groundBody = new RigidBody(rigidBodyConstructionInfo);
        this.groundBody.setRestitution(0.7f);
        this.groundBody.setDamping(0.5f, 0.5f);
        this.dynamicWorld.addRigidBody(this.groundBody);
        this.groundJointFrame = new Transform();
        this.groundJointFrame.setIdentity();
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, this.groundDepth / 2.0f);
        this.groundJointFrame.origin.set((Tuple3f)vector3f2);
    }

    public void add(Object object) {
        String string = "AutoItem" + this.autoIndex++;
        float f = this.getMass(object);
        this.add(string, object, f);
    }

    public void add(String string, Object object) {
        float f = this.getMass(object);
        this.add(string, object, f);
    }

    public void add(Object object, float f) {
        String string = "AutoItem" + this.autoIndex++;
        this.add(string, object, f);
    }

    public void add(String string, Object object, float f) {
        if (object == null) {
            Library.println((Object)"WARNING: Can't add a null object to the PhysicsModel");
        } else {
            MassObject massObject = new MassObject(string, object, f);
            if (this.debugText) {
                Library.println((Object)("PhysicsModel: Adding " + string + " mass " + f));
            }
            this.massObjects.add(massObject);
        }
    }

    public void remove(Object object) {
        MassObject massObject = this.getMassObject(object);
        if (massObject != null) {
            this.massObjects.remove((Object)massObject);
        }
    }

    public void setMass(Object object, float f) {
        MassObject massObject = this.getMassObject(object);
        if (massObject != null) {
            massObject.mass = f;
        }
    }

    public void updateReference(String string, Object object) {
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject massObject = this.massObjects.get(i);
            if (!string.equals(massObject.getName())) continue;
            massObject.setObject(object);
            Library.println((Object)("Updating " + string));
            break;
        }
    }

    private void updateMass(MassObject massObject) {
        if (this.debugText) {
            Library.println((Object)"\nStart updateMass");
        }
        Object object = massObject.getObject();
        float f = 0.0f;
        if (object instanceof FlexNode) {
            FlexNode flexNode = (FlexNode)((Object)object);
            f = flexNode.getMass();
        } else {
            f = this.getMass(object);
        }
        massObject.setMass(f);
    }

    public float getMass(Object object) {
        float f = 0.0f;
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("getMass", new Class[]{null});
            Object object2 = method.invoke(null, new Object[0]);
            if (method.getReturnType().equals(Float.TYPE)) {
                f = ((Float)object2).floatValue();
            }
        }
        catch (Exception exception) {
            Library.println((Object)("WARNING: can't find mass for " + object.getClass().getName()));
            Library.println((Object)exception.getMessage());
        }
        return f;
    }

    protected void addDeferred(MassObject massObject) {
        Object object = massObject.getObject();
        RigidBody rigidBody = null;
        SphereShape sphereShape = null;
        if (object == null) {
            Library.println((Object)"WARNING: Adding a null object to the PhysicsModel");
        } else if (object instanceof Sphere) {
            if (this.debugText) {
                Library.println((Object)"Adding a Sphere to the PhysicsModel");
            }
            Sphere sphere = (Sphere)object;
            sphereShape = new SphereShape(sphere.getRadius());
            sphereShape.setUserPointer(object);
            rigidBody = this.createAndAddBody(massObject, (CollisionShape)sphereShape);
        } else if (object instanceof FlexNode) {
            if (this.debugText) {
                Library.println((Object)("Adding a FlexNode to the PhysicsModel, mass " + massObject.getMass()));
            }
            FlexNode flexNode = (FlexNode)((Object)object);
            float f = flexNode.getRadius();
            float f2 = flexNode.getLength();
            rigidBody = this.createCylinder(massObject, object, f2, f);
            this.join(flexNode, massObject, rigidBody);
        } else if (object instanceof Frustum) {
            if (this.debugText) {
                Library.println((Object)("Adding a Frustum to the PhysicsModel (as Cylinder), mass " + massObject.getMass()));
            }
            Frustum frustum = (Frustum)object;
            float f = frustum.getTopRadius();
            float f3 = frustum.getBaseRadius();
            if (f3 > f) {
                f = f3;
            }
            float f4 = frustum.getLength();
            rigidBody = this.createCylinder(massObject, object, f4, f);
        } else if (object instanceof Cylinder) {
            if (this.debugText) {
                Library.println((Object)("Adding a Cylinder to the PhysicsModel, mass " + massObject.getMass()));
            }
            Cylinder cylinder = (Cylinder)object;
            float f = cylinder.getRadius();
            float f5 = cylinder.getLength();
            rigidBody = this.createCylinder(massObject, object, f5, f);
        } else if (object instanceof F) {
            if (this.debugText) {
                Library.println((Object)("Adding a Cylinder to the PhysicsModel, mass " + massObject.getMass()));
            }
            F f = (F)object;
            float f6 = f.diameter / 2.0f;
            float f7 = f.length;
            rigidBody = this.createCylinder(massObject, object, f7, f6);
        } else {
            Library.println((Object)("Can't add a " + object.getClass() + " to the PhysicsModel (yet)"));
            Library.println((Object)"\tPossible Classes:");
            Library.println((Object)("      " + object.getClass().getSuperclass() + " (super)"));
            Class<?>[] classArray = object.getClass().getClasses();
            for (int i = 0; i < classArray.length; ++i) {
                Library.println((Object)("      " + classArray[i].getName()));
            }
        }
    }

    protected void updatePosition(MassObject massObject) {
        if (this.debugText) {
            Library.println((Object)"\nStart updatePosition");
        }
        CollisionObject collisionObject = massObject.getBody();
        Object object = massObject.getObject();
        if (object == null) {
            Library.println((Object)"WARNING: MassObject reference object is NULL");
        } else if (object instanceof Node) {
            Matrix4d matrix4d;
            MassObject massObject2;
            Matrix4d matrix4d2;
            Node node = (Node)object;
            FlexNode flexNode = null;
            FlexNode flexNode2 = null;
            if (node instanceof FlexNode) {
                flexNode = (FlexNode)node;
                flexNode2 = flexNode.getParentFlexNode();
            }
            Transform transform = new Transform();
            transform.setIdentity();
            collisionObject.getWorldTransform(transform);
            Matrix4d matrix4d3 = this.utils.getMatrix4d(transform);
            if (this.debugText) {
                Library.println((Object)("Physics world transform =" + matrix4d3));
            }
            Point3d point3d = massObject.getOffsetCoG();
            Vector3d vector3d = new Vector3d();
            vector3d.negate((Tuple3d)point3d);
            Matrix4d matrix4d4 = this.utils.offsetMatrix(matrix4d3, vector3d);
            if (this.debugText) {
                Library.println((Object)("compensated for centre of mass =" + matrix4d4));
            }
            massObject.setCurrentGlobalTransform(matrix4d4);
            if (this.debugText) {
                Library.println((Object)("set current global " + massObject.getName() + " to " + matrix4d4));
            }
            if (flexNode == null || flexNode2 == null) {
                matrix4d2 = new Matrix4d(massObject.getInitialTransform());
                if (matrix4d2 == null) {
                    Library.println((Object)("ERROR: Parent transform for " + massObject.getName() + " is NULL"));
                }
                if (this.debugText) {
                    Library.println((Object)("Initial transform with no parent =" + matrix4d2));
                }
            } else {
                if (this.debugText) {
                    Library.println((Object)("Parent FlexNode " + flexNode2.getName()));
                }
                if ((massObject2 = this.getMassObject((Node)flexNode2)) == null) {
                    Library.println((Object)"WARNING: Can't find a MassObject for the parent");
                    matrix4d2 = new Matrix4d(massObject.getInitialTransform());
                } else {
                    matrix4d2 = massObject2.getCurrentGlobalTransform();
                    if (this.debugText) {
                        Library.println((Object)("Parent (" + massObject2.getName() + ") current transform =" + matrix4d2));
                    }
                    matrix4d = massObject.getParentFrameTransform();
                    if (this.debugText) {
                        Library.println((Object)("Joint offset -\n" + matrix4d.toString()));
                    }
                    matrix4d2.mul(matrix4d);
                    if (this.debugText) {
                        Library.println((Object)("Parent with joint offset -\n" + matrix4d2.toString()));
                    }
                }
            }
            massObject2 = this.utils.getDifference(matrix4d4, matrix4d2);
            if (this.debugText) {
                Library.println((Object)("Change matrix =" + (Object)((Object)massObject2)));
            }
            matrix4d = new TMatrix4d((Matrix4d)massObject2);
            ((Null)object).setTransform((TMatrix4d)matrix4d);
        }
        if (this.debugText) {
            Library.println((Object)"End updatePosition");
        }
    }

    protected RigidBody createCylinder(MassObject massObject, Object object, float f, float f2) {
        RigidBody rigidBody = null;
        CylinderShapeZ cylinderShapeZ = null;
        Vector3f vector3f = new Vector3f(f2, f2, f / 2.0f);
        cylinderShapeZ = new CylinderShapeZ(vector3f);
        cylinderShapeZ.setUserPointer(object);
        Point3d point3d = new Point3d(0.0, 0.0, (double)(f / 2.0f));
        massObject.setOffsetCoG(point3d);
        rigidBody = this.createAndAddBody(massObject, (CollisionShape)cylinderShapeZ);
        return rigidBody;
    }

    protected void join(FlexNode flexNode, MassObject massObject, RigidBody rigidBody) {
        MassObject massObject2 = this.getParentMassObject((Node)flexNode);
        if (massObject2 == null) {
            Matrix4d matrix4d;
            if (this.debugText) {
                Library.println((Object)"Join to ground");
            }
            if ((matrix4d = massObject.getParentFrameTransform()) == null) {
                matrix4d = Library.transformation((Node)flexNode).toMatrix4d();
                massObject.setParentFrameTransform(matrix4d);
                if (this.debugText) {
                    Library.println((Object)("Set parent transform to " + matrix4d));
                }
            } else if (this.debugText) {
                Library.println((Object)("  parent transform is " + matrix4d));
            }
            Matrix4f matrix4f = new Matrix4f();
            this.groundJointFrame.getMatrix(matrix4f);
            Matrix4d matrix4d2 = new Matrix4d(matrix4f);
            if (this.debugText) {
                Library.println((Object)("Ground Joint Frame -\n" + matrix4d2.toString()));
            }
            matrix4d2.mul(matrix4d);
            if (this.debugText) {
                Library.println((Object)("Anchor Frame -\n" + matrix4d2.toString()));
            }
            Transform transform = new Transform();
            transform.set(new Matrix4f(matrix4d2));
            this.joinToBodyFrame(flexNode, transform, rigidBody, this.groundBody);
        } else {
            Object object = massObject2.getObject();
            if (!(object instanceof FlexNode)) {
                if (!(object instanceof Node)) {
                    Library.println((Object)"WARNING: Can't find a Node for the parent");
                    Matrix4d matrix4d = Library.transformation((Node)flexNode).toMatrix4d();
                    massObject.setParentFrameTransform(matrix4d);
                } else {
                    Matrix4d matrix4d;
                    Node node = (Node)object;
                    RigidBody rigidBody2 = (RigidBody)massObject2.getBody();
                    if (this.debugText) {
                        Library.println((Object)("Store transform from " + massObject2.getName() + " to " + massObject.getName()));
                    }
                    if ((matrix4d = massObject.getParentFrameTransform()) == null) {
                        matrix4d = this.calcParentTransform((Node)flexNode, node);
                        massObject.setParentFrameTransform(matrix4d);
                        if (this.debugText) {
                            Library.println((Object)("Set parent transform to " + matrix4d));
                        }
                    } else if (this.debugText) {
                        Library.println((Object)("  parent transform is " + matrix4d));
                    }
                    Matrix4d matrix4d3 = Library.transformation((Node)node).toMatrix4d();
                    Point3d point3d = massObject2.getOffsetCoG();
                    Matrix4d matrix4d4 = this.utils.offsetMatrix(matrix4d3, point3d);
                    if (this.debugText) {
                        Library.println((Object)("parent Centre of Mass " + matrix4d4.toString()));
                    }
                    Matrix4d matrix4d5 = Library.transformation((Node)flexNode).toMatrix4d();
                    if (this.debugText) {
                        Library.println((Object)("Object Transformation " + matrix4d5.toString()));
                    }
                    Matrix4d matrix4d6 = this.utils.getDifference(matrix4d5, matrix4d4);
                    if (this.debugText) {
                        Library.println((Object)(" jointFrame " + matrix4d6.toString()));
                    }
                    if (this.debugText) {
                        Library.println((Object)("Anchor Frame -\n" + matrix4d6.toString()));
                    }
                    Transform transform = new Transform();
                    transform.set(new Matrix4f(matrix4d6));
                    if (this.debugText) {
                        Library.println((Object)("Join to parent " + massObject2.getName()));
                    }
                    this.joinToBodyFrame(flexNode, transform, rigidBody, rigidBody2);
                }
            } else {
                Matrix4d matrix4d;
                FlexNode flexNode2 = (FlexNode)((Object)object);
                if (this.debugText) {
                    Library.println((Object)("Store transform from " + massObject2.getName() + " to " + massObject.getName()));
                }
                if ((matrix4d = massObject.getParentFrameTransform()) == null) {
                    matrix4d = this.calcParentTransform((Node)flexNode, (Node)flexNode2);
                    massObject.setParentFrameTransform(matrix4d);
                    if (this.debugText) {
                        Library.println((Object)("Set parent transform to " + matrix4d));
                    }
                } else if (this.debugText) {
                    Library.println((Object)("  parent transform is " + matrix4d));
                }
                if (this.debugText) {
                    Library.println((Object)("Join to parent " + massObject2.getName()));
                }
                RigidBody rigidBody3 = (RigidBody)massObject2.getBody();
                this.joinToParent(flexNode, flexNode2, rigidBody, rigidBody3);
            }
        }
    }

    Matrix4d calcParentOffsetFrame(FlexNode flexNode, FlexNode flexNode2) {
        Matrix4d matrix4d = Library.transformation((Node)flexNode2).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + matrix4d.toString()));
        }
        Vector3d vector3d = flexNode2.getLengthVector();
        Matrix4d matrix4d2 = this.utils.offsetMatrix(matrix4d, vector3d);
        if (this.debugText) {
            Library.println((Object)("Parent End -\n" + matrix4d2.toString()));
        }
        Matrix4d matrix4d3 = Library.transformation((Node)flexNode).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + matrix4d3.toString()));
        }
        Matrix4d matrix4d4 = this.utils.getDifference(matrix4d3, matrix4d2);
        if (this.debugText) {
            Library.println((Object)(" calcParentOffsetFrame -\n" + matrix4d4.toString()));
        }
        return matrix4d4;
    }

    protected void joinToBodyFrame(FlexNode flexNode, Transform transform, RigidBody rigidBody, RigidBody rigidBody2) {
        Transform transform2 = flexNode.getBottomJointFrame();
        Matrix4f matrix4f = new Matrix4f();
        transform2.getMatrix(matrix4f);
        if (this.debugText) {
            Library.println((Object)("Bottom Joint Frame -\n" + matrix4f.toString()));
        }
        Generic6DofConstraint generic6DofConstraint = new Generic6DofConstraint(rigidBody2, rigidBody, transform, transform2, false);
        flexNode.setJoint(generic6DofConstraint);
        this.dynamicWorld.addConstraint((TypedConstraint)generic6DofConstraint, true);
        this.initMotors(generic6DofConstraint, flexNode);
    }

    protected void joinToParent(FlexNode flexNode, FlexNode flexNode2, RigidBody rigidBody, RigidBody rigidBody2) {
        Matrix4f matrix4f;
        if (this.debugText) {
            Library.println((Object)("Join to parent " + flexNode2.getName()));
        }
        Transform transform = flexNode2.getTopJointFrame();
        Matrix4d matrix4d = this.calcParentOffsetFrame(flexNode, flexNode2);
        Transform transform2 = new Transform(new Matrix4f(matrix4d));
        transform.mul(transform2);
        Transform transform3 = flexNode.getBottomJointFrame();
        if (this.debugText) {
            matrix4f = new Matrix4f();
            transform.getMatrix(matrix4f);
            Library.println((Object)("PhysicsModel.joinToParent(): Top Joint Frame  -\n" + matrix4f));
            transform3.getMatrix(matrix4f);
            Library.println((Object)("PhysicsModel.joinToParent(): Bottom Joint Frame  -\n" + matrix4f));
        }
        matrix4f = new Generic6DofConstraint(rigidBody2, rigidBody, transform, transform3, false);
        flexNode.setJoint((Generic6DofConstraint)matrix4f);
        this.dynamicWorld.addConstraint((TypedConstraint)matrix4f, true);
        this.initMotors((Generic6DofConstraint)matrix4f, flexNode);
    }

    private void initMotors(Generic6DofConstraint generic6DofConstraint, FlexNode flexNode) {
        if (this.debugText) {
            Library.println((Object)"initMotors() ");
        }
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rotationalLimitMotor = generic6DofConstraint.getRotationalLimitMotor(i);
            rotationalLimitMotor.loLimit = -1.0E-5f;
            rotationalLimitMotor.hiLimit = 1.0E-5f;
            rotationalLimitMotor.ERP = 0.7f;
            rotationalLimitMotor.damping = flexNode.getRotDamping();
            rotationalLimitMotor.bounce = flexNode.getRotBounce();
            rotationalLimitMotor.limitSoftness = flexNode.getStiffness(i);
            if (this.debugText) {
                Library.println((Object)(" stiffness(" + i + ")=" + flexNode.getStiffness(i)));
            }
            rotationalLimitMotor.enableMotor = true;
        }
        if (this.debugText) {
            Library.println((Object)(" Rotational Damping=" + flexNode.getRotDamping()));
        }
        if (this.debugText) {
            Library.println((Object)(" Rotational bounce =" + flexNode.getRotBounce()));
        }
        if (this.debugText) {
            Library.println((Object)(" Linear Damping    =" + flexNode.getLinDamping()));
        }
        if (this.debugText) {
            Library.println((Object)(" Linear Bounce     =" + flexNode.getLinBounce()));
        }
        TranslationalLimitMotor translationalLimitMotor = generic6DofConstraint.getTranslationalLimitMotor();
        translationalLimitMotor.limitSoftness = flexNode.getStiffness(3);
        translationalLimitMotor.damping = flexNode.getLinDamping();
        translationalLimitMotor.restitution = flexNode.getLinBounce();
        if (this.debugText) {
            Library.println((Object)(" stiffness(3)=" + flexNode.getStiffness(3)));
        }
    }

    private RigidBody createAndAddBody(MassObject massObject, CollisionShape collisionShape) {
        RigidBody rigidBody = this.createRigidBody(collisionShape, massObject.getMass());
        massObject.setShape(collisionShape);
        massObject.setBody(rigidBody);
        this.initPosition(massObject);
        rigidBody.setRestitution(0.7f);
        rigidBody.setDamping(0.3f, 0.9f);
        this.dynamicWorld.addRigidBody(rigidBody);
        massObject.setInitialised(true);
        return rigidBody;
    }

    private RigidBody createRigidBody(CollisionShape collisionShape, float f) {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        if (f != 0.0f) {
            collisionShape.calculateLocalInertia(f, vector3f);
        }
        Transform transform = new Transform();
        transform.setIdentity();
        DefaultMotionState defaultMotionState = new DefaultMotionState(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f, (MotionState)defaultMotionState, collisionShape, vector3f);
        RigidBody rigidBody = new RigidBody(rigidBodyConstructionInfo);
        return rigidBody;
    }

    private void initPosition(MassObject massObject) {
        CollisionObject collisionObject = massObject.getBody();
        Object object = massObject.getObject();
        if (object == null) {
            Library.println((Object)"WARNING: MassObject reference object is NULL");
        } else if (object instanceof Node) {
            Node node = (Node)object;
            String string = this.getNodeName(node);
            Matrix4d matrix4d = Library.transformation((Node)node).toMatrix4d();
            if (this.debugText) {
                Library.println((Object)("Placing " + string + " at transform " + matrix4d));
            }
            massObject.setCurrentGlobalTransform(matrix4d);
            Matrix4d matrix4d2 = massObject.getInitialTransform();
            if (matrix4d2 == null) {
                matrix4d2 = new Matrix4d(matrix4d);
                massObject.setInitialTransform(matrix4d2);
            }
            Point3d point3d = massObject.getOffsetCoG();
            if (this.debugText) {
                Library.println((Object)("Centre of mass offset " + point3d));
            }
            Matrix4d matrix4d3 = this.utils.offsetMatrix(matrix4d, point3d);
            if (this.debugText) {
                Library.println((Object)("Physics world transform =" + matrix4d3));
            }
            Transform transform = new Transform();
            transform.set(new Matrix4f(matrix4d3));
            collisionObject.setWorldTransform(transform);
        }
    }

    Matrix4d calcParentTransform(Node node, Node node2) {
        Matrix4d matrix4d = Library.transformation((Node)node2).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + matrix4d.toString()));
        }
        Matrix4d matrix4d2 = Library.transformation((Node)node).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + matrix4d2.toString()));
        }
        Matrix4d matrix4d3 = this.utils.getDifference(matrix4d2, matrix4d);
        if (this.debugText) {
            Library.println((Object)(" calcParentTransform -\n" + matrix4d3.toString()));
        }
        return matrix4d3;
    }

    Matrix4d calcUpdatedParentTransform(Node node, MassObject massObject) {
        Matrix4d matrix4d = massObject.getCurrentGlobalTransform();
        if (this.debugText) {
            Library.println((Object)("Parent Transformation -\n" + matrix4d.toString()));
        }
        Matrix4d matrix4d2 = Library.transformation((Node)node).toMatrix4d();
        if (this.debugText) {
            Library.println((Object)("Object Transformation -\n" + matrix4d2.toString()));
        }
        Matrix4d matrix4d3 = this.utils.getDifference(matrix4d2, matrix4d);
        if (this.debugText) {
            Library.println((Object)(" calcParentTransform -\n" + matrix4d3.toString()));
        }
        return matrix4d3;
    }

    public String getNodeName(Node node) {
        String string = "Null";
        if (node != null) {
            string = node.getClass().getSimpleName();
            if (node instanceof Sphere) {
                string = "Sphere";
            } else if (node instanceof FlexNode) {
                string = "FlexNode";
            } else if (node instanceof Cylinder) {
                string = "Cylinder";
            }
            if (node.getName() != null) {
                string = string + " " + node.getName();
            }
        }
        return string;
    }

    public void step() {
        this.step(0.1f);
    }

    public void step(float f) {
        this.visitor.setDebug(this.debugText);
        GraphManager graphManager = Library.graph();
        graphManager.accept(null, (Visitor)this.visitor, null);
        this.dynamicWorld.stepSimulation(f);
    }

    public boolean isActive() {
        boolean bl = false;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject massObject = this.massObjects.get(i);
            CollisionObject collisionObject = massObject.getBody();
            if (collisionObject != null && !massObject.getBody().isActive()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int activeCount() {
        int n = 0;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject massObject = this.massObjects.get(i);
            CollisionObject collisionObject = massObject.getBody();
            if (collisionObject != null && !massObject.getBody().isActive()) continue;
            ++n;
        }
        return n;
    }

    public void clear() {
        if (this.debugText) {
            Library.println((Object)"\nPhysicsModel: clearing all objects");
        }
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject massObject = this.massObjects.get(i);
            massObject.setInitialised(false);
        }
        this.dynamicWorld.destroy();
        this.init();
    }

    public FlexNode getPreviousFlexNode(Node node) {
        FlexNode flexNode = null;
        for (Node node2 = node.getPredecessor(); node2 != null; node2 = node2.getPredecessor()) {
            if (!(node2 instanceof FlexNode)) continue;
            flexNode = (FlexNode)node2;
            break;
        }
        return flexNode;
    }

    public FlexNode getParentFlexNode(Node node) {
        FlexNode flexNode = this.getPreviousFlexNode(node);
        if (flexNode == null) {
            block0: for (Node node2 = node.getAxisParent(); node2 != null; node2 = node2.getAxisParent()) {
                if (node2 instanceof FlexNode) {
                    flexNode = (FlexNode)node2;
                    break;
                }
                for (Node node3 = node2.getPredecessor(); node3 != null; node3 = node3.getPredecessor()) {
                    if (!(node3 instanceof FlexNode)) continue;
                    flexNode = (FlexNode)node3;
                    break block0;
                }
            }
        }
        return flexNode;
    }

    MassObject getMassObject(Node node) {
        MassObject massObject = null;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            Node node2;
            MassObject massObject2 = this.massObjects.get(i);
            Object object = massObject2.getObject();
            if (!(object instanceof Node) || !(node2 = (Node)object).equals(node)) continue;
            massObject = massObject2;
            break;
        }
        return massObject;
    }

    MassObject getMassObject(Object object) {
        MassObject massObject = null;
        for (int i = 0; i < this.massObjects.size(); ++i) {
            MassObject massObject2 = this.massObjects.get(i);
            Object object2 = massObject2.getObject();
            if (!object2.equals(object)) continue;
            massObject = massObject2;
            break;
        }
        return massObject;
    }

    public MassObject getPreviousMassObject(Node node) {
        MassObject massObject = null;
        for (Node node2 = node.getPredecessor(); node2 != null && (massObject = this.getMassObject(node2)) == null; node2 = node2.getPredecessor()) {
        }
        return massObject;
    }

    public MassObject getParentMassObject(Node node) {
        MassObject massObject = this.getPreviousMassObject(node);
        if (massObject == null) {
            block0: for (Node node2 = node.getAxisParent(); node2 != null && (massObject = this.getMassObject(node2)) == null; node2 = node2.getAxisParent()) {
                for (Node node3 = node2.getPredecessor(); node3 != null; node3 = node3.getPredecessor()) {
                    massObject = this.getMassObject(node3);
                    if (massObject != null) break block0;
                }
            }
        }
        return massObject;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new PhysicsModel();
    }

    public boolean isDebugText() {
        return this.debugText;
    }

    public void setDebugText(boolean bl) {
        this.debugText = bl;
    }

    public ArrayList<MassObject> getMassObjects() {
        return this.massObjects;
    }

    public void setMassObjects(ArrayList<MassObject> arrayList) {
        massObjects$FIELD.setObject((Object)this, arrayList);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)debugText$FIELD);
        massObjects$FIELD = new _Field("massObjects", 0x200002, (Type)ClassAdapter.wrap(ArrayList.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)massObjects$FIELD);
        $TYPE.declareFieldAttribute(massObjects$FIELD, (Attribute)Attributes.MASSOBJECTS);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 0: {
                    ((PhysicsModel)((Object)object)).debugText = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 0: {
                    return ((PhysicsModel)((Object)object)).isDebugText();
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 1: {
                    ((PhysicsModel)((Object)object)).massObjects = (ArrayList)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 1: {
                    return ((PhysicsModel)((Object)object)).getMassObjects();
                }
            }
            return super.getObject(object);
        }
    }
}

