/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import raskob.geometry.MathP;
import raskob.geometry.Point;

public class MassCenter
extends Point {
    private double area = 0.0;

    public MassCenter(double x, double y, double area) {
        super(x, y);
        this.area = area;
    }

    public void mergeWith(MassCenter mc) {
        if (mc == null) {
            return;
        }
        double newArea = mc.getArea() + this.area;
        MathP.equals(newArea, 0.0);
        this.setX((mc.getX() * mc.getArea() + this.getX() * this.area) / newArea);
        this.setY((mc.getY() * mc.getArea() + this.getY() * this.area) / newArea);
        this.area = newArea;
    }

    public double getArea() {
        return this.area;
    }

    public void invert() {
        this.area = -this.area;
    }
}

