/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.blocks.xFrogFileParser;

import de.grogra.blocks.CustomFunction;
import de.grogra.blocks.xFrogFileParser.Expr;
import de.grogra.math.Abs;
import de.grogra.math.Acos;
import de.grogra.math.Asin;
import de.grogra.math.Atan;
import de.grogra.math.Ceil;
import de.grogra.math.Cos;
import de.grogra.math.Cosh;
import de.grogra.math.Exp;
import de.grogra.math.Exp2;
import de.grogra.math.Floor;
import de.grogra.math.Id;
import de.grogra.math.Log;
import de.grogra.math.Phi;
import de.grogra.math.Pi;
import de.grogra.math.Rad;
import de.grogra.math.Rnd;
import de.grogra.math.Rndabs;
import de.grogra.math.Sin;
import de.grogra.math.Sinh;
import de.grogra.math.Sqr;
import de.grogra.math.Sqrt;
import de.grogra.math.Tan;
import de.grogra.math.Tanh;
import de.grogra.xl.lang.FloatToFloat;

public class Functions
extends Expr {
    private final String[] functionListString = new String[]{"\"id\"", "\"sin\"", "\"cos\"", "\"Tan\"", "\"asin\"", "\"acos\"", "\"atan\"", "\"sinh\"", "\"cosh\"", "\"tanh\"", "\"exp\"", "\"exp2\"", "\"log\"", "\"sqr\"", "\"sqrt\"", "\"ceil\"", "\"floor\"", "\"rndabs\"", "\"rnd\"", "\"abs\"", "\"phi\"", "\"pi\"", "\"rad\"", "\"chdm\"", "\"iter\"", "\"rec\"", "\"ftime\"", "\"frame\"", "\"smooth\"", "\"clamp\""};
    private final String[] functionListXL = new String[]{"new Id()", "new Sin()", "new Cos()", "new Tan()", "new Asin()", "new Acos()", "new Atan()", "new Sinh()", "new Cosh()", "new Tanh()", "new Exp()", "new Exp2()", "new Log()", "new Sqr()", "new Sqrt()", "new Ceil()", "new Floor()", "new Rndabs()", "new Rnd()", "new Abs()", "new Phi()", "new Pi()", "new Rad()", "new Id()", "new Id()", "new Id()", "new Id()", "new Id()", "new Id()", "new Id()"};
    private final String[] notSupportFuctions = new String[]{"iter", "rec", "time", "frame", "chdrn", "ftime", "smooth", "clamp"};
    private int ii = 0;
    private String ss = "";
    private FloatToFloat function = null;

    public Functions(int n) {
        this.ii = n;
        this.makeFunction();
    }

    public Functions(String string) {
        this.ii = -1;
        this.ss = string;
        this.makeFunction();
    }

    private void makeFunction() {
        switch (this.ii) {
            case -1: {
                this.function = new CustomFunction(this.cleanFunctions(this.ss));
                break;
            }
            case 0: {
                this.function = new Id();
                break;
            }
            case 1: {
                this.function = new Sin();
                break;
            }
            case 2: {
                this.function = new Cos();
                break;
            }
            case 3: {
                this.function = new Tan();
                break;
            }
            case 4: {
                this.function = new Asin();
                break;
            }
            case 5: {
                this.function = new Acos();
                break;
            }
            case 6: {
                this.function = new Atan();
                break;
            }
            case 7: {
                this.function = new Sinh();
                break;
            }
            case 8: {
                this.function = new Cosh();
                break;
            }
            case 9: {
                this.function = new Tanh();
                break;
            }
            case 10: {
                this.function = new Exp();
                break;
            }
            case 11: {
                this.function = new Exp2();
                break;
            }
            case 12: {
                this.function = new Log();
                break;
            }
            case 13: {
                this.function = new Sqr();
                break;
            }
            case 14: {
                this.function = new Sqrt();
                break;
            }
            case 15: {
                this.function = new Ceil();
                break;
            }
            case 16: {
                this.function = new Floor();
                break;
            }
            case 17: {
                this.function = new Rndabs();
                break;
            }
            case 18: {
                this.function = new Rnd();
                break;
            }
            case 19: {
                this.function = new Abs();
                break;
            }
            case 20: {
                this.function = new Phi();
                break;
            }
            case 21: {
                this.function = new Pi();
                break;
            }
            case 22: {
                this.function = new Rad();
                break;
            }
            case 23: {
                this.function = new Id();
                break;
            }
            case 24: {
                this.function = new Id();
                break;
            }
            case 25: {
                this.function = new Id();
                break;
            }
            case 26: {
                this.function = new Id();
                break;
            }
            case 27: {
                this.function = new Id();
                break;
            }
            case 28: {
                this.function = new Id();
                break;
            }
            case 29: {
                this.function = new Id();
            }
        }
    }

    private String cleanFunctions(String string) {
        string = string.substring(1, string.length() - 1);
        string = string.toLowerCase();
        for (int i = 0; i < this.notSupportFuctions.length; ++i) {
            string = string.replaceAll(this.notSupportFuctions[i], "id");
        }
        return string;
    }

    public FloatToFloat getFunction() {
        return this.function;
    }

    public String toXL() {
        if (this.ii == -1) {
            return "new CustomFunction(" + this.ss + ")";
        }
        return this.functionListXL[this.ii];
    }

    public String toString() {
        if (this.ii == -1) {
            return this.ss;
        }
        return this.functionListString[this.ii];
    }
}

