/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.objects;

import de.grogra.icon.Icon;
import de.grogra.icon.IconSource;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.ShareableBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;

public abstract class ImageAdapter
extends ShareableBase
implements IconSource,
Icon {
    private HashMap scaledImages = new HashMap();
    private transient int scaledStamp = -1;
    public static final Type $TYPE = new Type(ImageAdapter.class);

    protected ImageAdapter() {
    }

    public abstract BufferedImage getBufferedImage();

    public abstract BufferedImage getNativeImage();

    public Image getImage() {
        return this.getNativeImage();
    }

    public Icon getIcon(Dimension dimension, int n) {
        return this;
    }

    public Dimension getPreferredIconSize(boolean bl) {
        int n;
        BufferedImage bufferedImage = this.getNativeImage();
        if (bufferedImage == null) {
            return new Dimension(16, 16);
        }
        int n2 = bufferedImage.getWidth();
        float f = (float)(n2 * (n = bufferedImage.getHeight())) / (bl ? 2000.0f : 8000.0f);
        if (f > 1.0f) {
            f = 1.0f / (float)Math.sqrt(f);
            n2 = (int)((float)n2 * f);
            n = (int)((float)n * f);
        }
        return new Dimension(n2, n);
    }

    public void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        Image image = this.getImage(n3, n4);
        if (image == null) {
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.fillRect(n, n2, n3, n4);
        } else {
            graphics2D.drawImage(image, n, n2, n3, n4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int n, int n2) {
        Image image;
        BufferedImage bufferedImage = this.getNativeImage();
        if (bufferedImage == null || bufferedImage.getWidth() == n && bufferedImage.getHeight() == n2) {
            return bufferedImage;
        }
        Dimension dimension = new Dimension(n, n2);
        int n3 = this.getStamp();
        HashMap hashMap = this.scaledImages;
        synchronized (hashMap) {
            if (this.scaledStamp != n3) {
                this.scaledImages.clear();
                this.scaledStamp = n3;
            }
            if ((image = (Image)this.scaledImages.get(dimension)) == null) {
                image = bufferedImage.getScaledInstance(n, n2, 2);
                this.scaledImages.put(dimension, image);
            }
        }
        return image;
    }

    public void prepareIcon() {
    }

    public IconSource getIconSource() {
        return this;
    }

    public URL getImageSource() {
        return null;
    }

    public Rectangle getIconBounds() {
        return null;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends SCOType {
        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(ImageAdapter imageAdapter, SCOType sCOType) {
            super((Object)imageAdapter, sCOType);
        }

        Type(Class clazz) {
            super(clazz, SCOType.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }
    }
}

