/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.edit;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.imp.View;
import de.grogra.imp.edit.ViewSelectionChanged;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.edit.GraphSelection;
import de.grogra.pf.ui.edit.GraphSelectionImpl;
import de.grogra.pf.ui.edit.Selection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class ViewSelection {
    public static final int MOUSE_OVER = 1;
    public static final int MOUSE_OVER_SELECTED = 2;
    public static final int SELECTED = 4;
    ArrayList selections = new ArrayList();
    private final WeakReference viewRef;
    public static final UIProperty PROPERTY = UIProperty.getOrCreate((String)"view.selection", (int)2);

    private ViewSelection(View view) {
        this.viewRef = new WeakReference<View>(view);
    }

    View getView() {
        return (View)this.viewRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(Path path) {
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if (!GraphUtils.equal((Path)path, (Path)entry.path)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getFirstEntry(Object object, boolean bl) {
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.path.getNodeAndEdgeCount() & 1) != 0 != bl || object != entry.path.getObject(-1)) continue;
                return entry;
            }
        }
        return null;
    }

    public int get(Path path) {
        Entry entry = this.getEntry(path);
        return entry == null ? 0 : entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(Object object, boolean bl) {
        int n = 0;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.path.getNodeAndEdgeCount() & 1) != 0 != bl || object != entry.path.getObject(-1)) continue;
                n |= entry.value;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(Object object, boolean bl) {
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.value & 4) == 0 || (entry.path.getNodeAndEdgeCount() & 1) != 0 != bl || object != entry.path.getObject(-1)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getFirstPath(int n) {
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.value & n) == 0) continue;
                return entry.path;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getAll(int n) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        ArrayList arrayList2 = this.selections;
        synchronized (arrayList2) {
            for (int i = 0; i < this.selections.size(); ++i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.value & n) == 0) continue;
                arrayList.add(new Entry(entry));
            }
        }
        return arrayList.toArray(new Entry[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(int n) {
        int n2 = 0;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if ((entry.value & n) == 0) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(int n, Path path) {
        Entry entry;
        boolean bl = (n & 4) != 0;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            entry = this.getEntry(path);
            if (entry == null) {
                entry = new Entry(path, n, this);
                this.selections.add(entry);
            } else if ((entry.value & n) != n) {
                entry.value |= n;
                n = entry.value;
            } else {
                entry = null;
            }
        }
        this.notify(entry, bl);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, Path path) {
        Entry entry;
        boolean bl = false;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            entry = this.getEntry(path);
            if (entry != null && (entry.value & n) != 0) {
                bl = (entry.value & n & 4) != 0;
                if ((n = (entry.value &= ~n)) == 0) {
                    this.selections.remove(entry);
                }
            } else {
                entry = null;
            }
        }
        this.notify(entry, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAndAdd(int n, int n2, Path path) {
        Entry entry;
        boolean bl = false;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            entry = this.getEntry(path);
            if (entry == null) {
                if (n2 != 0) {
                    bl = (n2 & 4) != 0;
                    entry = new Entry(path, n2, this);
                    this.selections.add(entry);
                }
            } else if ((n2 = entry.value & ~n | n2) != entry.value) {
                bl = ((entry.value ^ n2) & 4) != 0;
                entry.value = n2;
                if (n2 == 0) {
                    this.selections.remove(entry);
                }
            } else {
                entry = null;
            }
        }
        this.notify(entry, bl);
        return n2;
    }

    public void set(Selection selection, boolean bl) {
        if (!(selection instanceof GraphSelection)) {
            this.set(4, Path.PATH_0, false);
            return;
        }
        GraphSelection graphSelection = (GraphSelection)selection;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (int i = graphSelection.size() - 1; i >= 0; --i) {
            Path path = this.getView().getPathFor(graphSelection.getGraphState(i), graphSelection.getObject(i), graphSelection.isNode(i));
            if (path == null) continue;
            arrayList.add(path);
        }
        this.set(4, arrayList.toArray(new Path[arrayList.size()]), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path[] set(int n, Path[] pathArray, boolean bl) {
        Path[] pathArray2 = this.selections;
        synchronized (this.selections) {
            Entry entry;
            int n2;
            ArrayList<Entry> arrayList = new ArrayList<Entry>(this.selections.size());
            ArrayList<Object> arrayList2 = new ArrayList<Object>(this.selections.size() + 1);
            boolean[] blArray = new boolean[pathArray.length];
            block3: for (n2 = this.selections.size() - 1; n2 >= 0; --n2) {
                entry = (Entry)this.selections.get(n2);
                for (int i = 0; i < pathArray.length; ++i) {
                    if (blArray[i] || !GraphUtils.equal((Path)pathArray[i], (Path)entry.path)) continue;
                    if ((entry.value & n) != n) {
                        arrayList2.add(((entry.value ^ n) & 4) != 0 ? this : null);
                        arrayList2.add(entry);
                        entry.value |= n;
                    }
                    blArray[i] = true;
                    continue block3;
                }
                if ((entry.value & n) == 0) continue;
                arrayList2.add((entry.value & n & 4) != 0 ? this : null);
                arrayList2.add(entry);
                if ((entry.value &= ~n) != 0) continue;
                arrayList.add(entry);
            }
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                this.selections.remove(arrayList.get(n2));
            }
            for (n2 = 0; n2 < pathArray.length; ++n2) {
                if (blArray[n2]) continue;
                entry = new Entry(pathArray[n2], n, this);
                this.selections.add(entry);
                arrayList2.add((n & 4) != 0 ? this : null);
                arrayList2.add(entry);
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            pathArray2 = new Path[arrayList2.size() >> 1];
            for (int i = arrayList2.size() - 2; i >= 0; i -= 2) {
                Entry entry2 = (Entry)arrayList2.get(i + 1);
                this.notify(entry2, bl && arrayList2.get(i) != null);
                pathArray2[i >> 1] = entry2.path;
            }
            return pathArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toggle(int n, Path path) {
        Entry entry;
        boolean bl = (n & 4) != 0;
        ArrayList arrayList = this.selections;
        synchronized (arrayList) {
            entry = this.getEntry(path);
            if (entry == null) {
                entry = new Entry(path, n, this);
                this.selections.add(entry);
            } else if ((n = (entry.value ^= n)) == 0) {
                this.selections.remove(entry);
            }
        }
        this.notify(entry, bl);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void graphModified(GraphState graphState) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.selections;
        synchronized (arrayList2) {
            for (int i = this.selections.size() - 1; i >= 0; --i) {
                Entry entry = (Entry)this.selections.get(i);
                if (graphState.getGraph().getLifeCycleState(entry.path.getObject(-1), (entry.path.getNodeAndEdgeCount() & 1) != 0) == 0) continue;
                arrayList = new ArrayList(this.selections);
                this.selections.clear();
                break;
            }
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.notify((Entry)arrayList.get(i), false);
            }
        }
    }

    private void notify(Entry entry, boolean bl) {
        if (entry != null) {
            View view = this.getView();
            PROPERTY.firePropertyChange((Context)view, null, null, (Object)new ViewSelectionChanged(view, entry.path));
            if (bl) {
                Entry[] entryArray = this.getAll(4);
                if (entryArray.length == 0) {
                    UIProperty.WORKBENCH_SELECTION.setValue((Context)view, null);
                } else {
                    Object[] objectArray = new Object[entryArray.length];
                    boolean[] blArray = new boolean[entryArray.length];
                    GraphState[] graphStateArray = new GraphState[entryArray.length];
                    GraphState graphState = view.getWorkbenchGraphState();
                    for (int i = entryArray.length - 1; i >= 0; --i) {
                        int n = GraphUtils.lastIndexOfGraph((Path)entryArray[i].getPath(), (Graph)graphState.getGraph());
                        assert (n >= 0);
                        graphStateArray[i] = graphState;
                        objectArray[i] = entryArray[i].getPath().getObject(n);
                        blArray[i] = (n & 1) == 0;
                        view.substituteSelection(graphStateArray, objectArray, blArray, i);
                    }
                    UIProperty.WORKBENCH_SELECTION.setValue((Context)view, (Object)new GraphSelectionImpl((Context)view, graphStateArray, objectArray, blArray));
                }
            }
        }
    }

    public static void create(View view) {
        PROPERTY.setValue((Context)view, (Object)new ViewSelection(view));
    }

    public static ViewSelection get(Context context) {
        return (ViewSelection)PROPERTY.getValue(context);
    }

    public static int getColor(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        if (bl && (n2 & 4) != 0) {
            n5 = 255;
            n4 = 255;
            n3 = 255;
        } else if ((n2 & 2) != 0) {
            n3 = 255;
            n4 = 200;
            n5 = 0;
        } else if ((n2 & 1) != 0) {
            n3 = 255;
            n4 = 0;
            n5 = 0;
        } else {
            return n;
        }
        if (Math.abs(n3 - (n >> 16 & 0xFF)) + Math.abs(n4 - (n >> 8 & 0xFF)) + Math.abs(n5 - (n & 0xFF)) < 60) {
            if (n3 + n5 + n4 > 600) {
                n3 >>= 1;
                n4 >>= 1;
                n5 >>= 1;
            } else {
                n3 = 128 + (n3 >> 1);
                n4 = 128 + (n4 >> 1);
                n5 = 128 + (n5 >> 1);
            }
        }
        return (n3 << 16) + (n4 << 8) + n5 + -16777216;
    }

    public static final class Entry {
        final Path path;
        int value;

        Entry(Path path, int n, ViewSelection viewSelection) {
            this.path = new ArrayPath(path);
            this.value = n;
        }

        Entry(Entry entry) {
            this.path = entry.path;
            this.value = entry.value;
        }

        public Path getPath() {
            return this.path;
        }

        public int getValue() {
            return this.value;
        }
    }
}

