/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.imp.IMPWorkbench;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAListener;
import de.grogra.pf.boot.Main;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.Disposable;
import de.grogra.util.ThreadContext;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IMPJobManager
implements JobManager,
Runnable,
XAListener,
Executor {
    private IMPWorkbench workbench;
    private boolean running = true;
    private volatile boolean executing = false;
    private volatile String nameOfExecuting;
    private int waitingMessageIndex = -1;
    private TimerTask waitingMessageTask;
    private static final int ENTRY_SIZE = 5;
    private Object[] queue = new Object[512];
    private int head = 0;
    private int tail = 0;
    private final ObjectList timedCallbacks = new ObjectList();
    private Command afterDispose;
    private Runnable blocking = null;
    private boolean modified;
    private Thread mainThread;
    private ThreadContext tcontext;
    private ObjectList listeners = new ObjectList();
    private Window initFeedback;
    private static final Command INVOKE_LATER = new Command(){

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            ((Runnable)object).run();
        }
    };
    private static long nextGC = 0L;
    private static int executingCount = 0;
    private static final Object gcLock = new Object();
    private static final boolean SYSTEM_GC = false;

    IMPJobManager() {
    }

    public ThreadContext getThreadContext() {
        return this.tcontext;
    }

    boolean isCurrent() {
        return this.tcontext.isCurrent();
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    void initialize(IMPWorkbench iMPWorkbench) {
        this.workbench = iMPWorkbench;
        iMPWorkbench.getRegistry().getRegistryGraph().addXAListener((XAListener)this);
        iMPWorkbench.getRegistry().getProjectGraph().addXAListener((XAListener)this);
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public Window getWindow() {
        return this.workbench.getWindow();
    }

    public Panel getPanel() {
        return this.workbench.getPanel();
    }

    public Object getComponent() {
        return this.workbench.getComponent();
    }

    private void checkWaitingMessage() {
        if (this.executing && this.waitingMessageIndex < 0 && !this.isCurrent()) {
            this.waitingMessageIndex = this.tail;
            this.waitingMessageTask = new TimerTask(){
                private boolean cancel = false;
                private Disposable message = null;

                public synchronized void run() {
                    if (this.cancel) {
                        return;
                    }
                    Window window = IMPJobManager.this.getWindow();
                    if (window != null) {
                        this.message = window.showWaitMessage(IMPJobManager.this.nameOfExecuting);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean cancel() {
                    this.cancel = true;
                    boolean bl = super.cancel();
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.message != null) {
                            this.message.dispose();
                        }
                    }
                    return bl;
                }
            };
            Workbench.TIMER.schedule(this.waitingMessageTask, 800L);
        }
    }

    public void execute(Runnable runnable) {
        this.runLater(INVOKE_LATER, runnable, (Context)this, 10000);
    }

    public synchronized void runLater(Command command, Object object, Context context, int n) {
        if (this.blocking != null) {
            this.execute(command, object, context, n);
        } else {
            if ((n & 0x10000) == 0) {
                this.checkWaitingMessage();
            }
            this.enqueue(command);
            this.enqueue(object);
            this.enqueue(context);
            this.enqueue((short)n);
            this.enqueue(new Long(System.currentTimeMillis()));
            this.notifyAll();
        }
    }

    private void enqueue(Object object) {
        if (!this.running) {
            return;
        }
        this.queue[this.tail] = object;
        if (++this.tail == this.queue.length) {
            this.tail = 0;
        }
        if (this.tail == this.head) {
            Object[] objectArray = new Object[this.queue.length * 2];
            this.head += objectArray.length - this.queue.length;
            System.arraycopy(this.queue, 0, objectArray, 0, this.tail);
            System.arraycopy(this.queue, this.tail, objectArray, this.head, this.queue.length - this.tail);
            this.queue = objectArray;
        }
    }

    private Object dequeue() {
        Object object = this.queue[this.head];
        this.queue[this.head] = null;
        if (++this.head == this.queue.length) {
            this.head = 0;
        }
        return object;
    }

    private Object peek(int n) {
        return this.queue[(n + this.head) % this.queue.length];
    }

    public final void execute(final Command command, final Object object, final Context context, int n) {
        if (this.isCurrent()) {
            short s = this.tcontext.getPriority();
            this.tcontext.setPriority((short)(n & 0xFFFF));
            command.run(object, context);
            this.tcontext.setPriority(s);
        } else if (this.blocking != null) {
            this.workbench.runAsCurrent(new Runnable(){
                private boolean joined;

                public void run() {
                    if (this.joined) {
                        command.run(object, context);
                    } else {
                        this.joined = true;
                        IMPJobManager.this.getThreadContext().joinWhileExecuting((Runnable)this);
                    }
                }
            });
        } else {
            this.runLater(command, object, context, n);
        }
    }

    public void runLater(long l, Command command, Object object, Context context) {
        this.runAt(System.currentTimeMillis() + l, command, object, context);
    }

    public synchronized void runAt(long l, Command command, Object object, Context context) {
        int n;
        for (n = 0; n < this.timedCallbacks.size && (Long)this.timedCallbacks.get(n) <= l; n += 4) {
        }
        this.timedCallbacks.add(n, (Object)new Long(l));
        this.timedCallbacks.add(n + 1, (Object)command);
        this.timedCallbacks.add(n + 2, object);
        this.timedCallbacks.add(n + 3, (Object)context);
        this.notifyAll();
    }

    public synchronized long getNextInvocationTime() {
        return this.timedCallbacks.size == 0 ? Long.MAX_VALUE : (Long)this.timedCallbacks.get(0);
    }

    public synchronized void cancelQueuedJob(Command command) {
        int n = this.head;
        while (n != this.tail) {
            if (this.queue[n] == command) {
                this.queue[n] = null;
                return;
            }
            n = (n + 5) % this.queue.length;
        }
    }

    public synchronized void cancelTimedJob(Command command) {
        for (int i = this.timedCallbacks.size - 4; i >= 0; i -= 4) {
            if (this.timedCallbacks.get(i + 1) != command) continue;
            this.timedCallbacks.remove(i + 3);
            this.timedCallbacks.remove(i + 2);
            this.timedCallbacks.remove(i + 1);
            this.timedCallbacks.remove(i);
        }
    }

    public synchronized boolean hasJobQueued(int n) {
        int n2 = this.head;
        while (n2 != this.tail) {
            if (this.queue[n2] != null && (((Number)this.queue[(n2 + 3) % this.queue.length]).intValue() & 0xFFFF) >= n) {
                return true;
            }
            n2 = (n2 + 5) % this.queue.length;
        }
        return false;
    }

    public synchronized boolean hasTimedJobQueued() {
        return !this.timedCallbacks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBlocking(Runnable runnable) {
        if (!this.isCurrent()) {
            throw new IllegalStateException();
        }
        Runnable runnable2 = this.blocking;
        this.blocking = runnable;
        try {
            runnable.run();
        }
        finally {
            this.blocking = runnable2;
        }
    }

    public void transactionApplied(Transaction.Data data, boolean bl) {
        this.modified = true;
    }

    void start(Window window) {
        this.initFeedback = window;
        new Thread((Runnable)this, "JobManager@" + this.workbench).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        this.mainThread = Thread.currentThread();
        this.mainThread.setPriority(3);
        this.tcontext = ThreadContext.current();
        this.tcontext.setPriority((short)10000);
        try {
            if (this.initFeedback != null) {
                this.initFeedback.setCursor(-2);
            }
            try {
                this.workbench.initialize();
            }
            finally {
                if (this.initFeedback != null) {
                    this.initFeedback.setCursor(-3);
                    this.initFeedback = null;
                }
            }
            Utils.flushHandlers((Logger)this.workbench.getLogger());
            ObjectList objectList = new ObjectList();
            while (this.running) {
                Object object;
                Object var21_21;
                IMPJobManager iMPJobManager;
                TimerTask timerTask;
                Command command;
                Context context;
                Object object2;
                Object object3;
                Object object22;
                block57: {
                    long l;
                    block55: {
                        short s;
                        object22 = gcLock;
                        // MONITORENTER : object22
                        nextGC = System.currentTimeMillis() + 7000L;
                        // MONITOREXIT : object22
                        Thread.interrupted();
                        object22 = null;
                        object3 = null;
                        object2 = null;
                        context = null;
                        command = null;
                        timerTask = null;
                        iMPJobManager = this;
                        // MONITORENTER : iMPJobManager
                        while (true) {
                            long l2;
                            long timerTask2;
                            if ((l = (timerTask2 = this.getNextInvocationTime()) - (l2 = System.currentTimeMillis())) > 0L && this.head == this.tail) {
                                Object object4 = gcLock;
                                // MONITORENTER : object4
                                short s2 = s = l2 >= nextGC && executingCount == 0 ? (short)1 : 0;
                                if (s != 0) {
                                    nextGC = Long.MAX_VALUE;
                                }
                                // MONITOREXIT : object4
                                if (s != 0) {
                                    // empty if block
                                }
                                try {
                                    this.wait(Math.min(l, 1000L));
                                    Utils.flushHandlers((Logger)this.workbench.getLogger());
                                }
                                catch (InterruptedException object5) {
                                    // empty catch block
                                }
                                if (this.running) continue;
                                // MONITOREXIT : iMPJobManager
                                return;
                            }
                            if (this.head == this.tail || l <= 0L && this.head != this.waitingMessageIndex && this.queue[this.head] != null && (Long)this.peek(4) > timerTask2) break block55;
                            if (this.head == this.waitingMessageIndex) {
                                this.waitingMessageIndex = -1;
                                timerTask = this.waitingMessageTask;
                                this.waitingMessageTask = null;
                            }
                            object22 = (Command)this.dequeue();
                            object2 = this.dequeue();
                            context = (Context)this.dequeue();
                            s = ((Number)this.dequeue()).shortValue();
                            this.dequeue();
                            if (object22 != null) break;
                        }
                        this.tcontext.setPriority(s);
                        this.nameOfExecuting = object22.getCommandName();
                        if (this.nameOfExecuting == null) {
                            this.nameOfExecuting = object22.toString();
                        }
                        break block57;
                    }
                    if (l <= 0L) {
                        context = (Context)this.timedCallbacks.remove(3);
                        object2 = this.timedCallbacks.remove(2);
                        command = (Command)this.timedCallbacks.remove(1);
                        object3 = this.timedCallbacks.remove(0);
                        this.tcontext.setPriority((short)10000);
                    }
                }
                this.executing = true;
                objectList.clear();
                objectList.addAll(this.listeners);
                // MONITOREXIT : iMPJobManager
                for (int iMPJobManager2 = 0; iMPJobManager2 < objectList.size; ++iMPJobManager2) {
                    ((JobManager.ExecutionListener)objectList.get(iMPJobManager2)).executionStarted((JobManager)this);
                }
                if (timerTask != null) {
                    timerTask.cancel();
                }
                this.modified = false;
                iMPJobManager = this.getWindow();
                TimerTask timerTask2 = new TimerTask((Window)iMPJobManager){
                    final /* synthetic */ Window val$wd;
                    {
                        this.val$wd = window;
                    }

                    public void run() {
                        this.val$wd.setCursor(-2);
                    }
                };
                if (iMPJobManager != null) {
                    Workbench.TIMER.schedule(timerTask2, 500L);
                }
                try {
                    int n;
                    try {
                        Object object5 = gcLock;
                        // MONITORENTER : object5
                        ++executingCount;
                        // MONITOREXIT : object5
                        if (object3 == null) {
                            object22.run(object2, context);
                        } else {
                            if (!(object3 instanceof Long)) throw new AssertionError(object3);
                            command.run(object2, context);
                        }
                        var21_21 = null;
                        object = gcLock;
                    }
                    catch (Throwable object6) {
                        this.workbench.getLogger().log(Level.WARNING, "Unexpected Exception", Utils.getMainException((Throwable)object6));
                        var21_21 = null;
                        object = gcLock;
                        // MONITORENTER : object
                        --executingCount;
                        // MONITOREXIT : object
                        if (iMPJobManager != null && !timerTask2.cancel()) {
                            iMPJobManager.setCursor(-3);
                        }
                        if ((object = this.workbench.getRegistry().getRegistryGraph().getTransaction(false)) != null) {
                            object.close();
                        }
                        this.executing = false;
                        if (this.modified) {
                            this.workbench.setModified();
                        }
                        objectList.clear();
                        IMPJobManager iMPJobManager3 = this;
                        // MONITORENTER : iMPJobManager3
                        objectList.addAll(this.listeners);
                        // MONITOREXIT : iMPJobManager3
                        for (n = 0; n < objectList.size; ++n) {
                            ((JobManager.ExecutionListener)objectList.get(n)).executionFinished((JobManager)this);
                        }
                    }
                    // MONITORENTER : object
                    --executingCount;
                    // MONITOREXIT : object
                    if (iMPJobManager != null && !timerTask2.cancel()) {
                        iMPJobManager.setCursor(-3);
                    }
                    if ((object = this.workbench.getRegistry().getRegistryGraph().getTransaction(false)) != null) {
                        object.close();
                    }
                    this.executing = false;
                    if (this.modified) {
                        this.workbench.setModified();
                    }
                    objectList.clear();
                    IMPJobManager n2 = this;
                    // MONITORENTER : n2
                    objectList.addAll(this.listeners);
                    // MONITOREXIT : n2
                    for (n = 0; n < objectList.size; ++n) {
                        ((JobManager.ExecutionListener)objectList.get(n)).executionFinished((JobManager)this);
                    }
                }
                catch (Throwable throwable) {
                    var21_21 = null;
                    object = gcLock;
                    // MONITORENTER : object
                    --executingCount;
                    // MONITOREXIT : object
                    if (iMPJobManager != null && !timerTask2.cancel()) {
                        iMPJobManager.setCursor(-3);
                    }
                    if ((object = this.workbench.getRegistry().getRegistryGraph().getTransaction(false)) != null) {
                        object.close();
                    }
                    this.executing = false;
                    if (this.modified) {
                        this.workbench.setModified();
                    }
                    objectList.clear();
                    IMPJobManager iMPJobManager3 = this;
                    // MONITORENTER : iMPJobManager3
                    objectList.addAll(this.listeners);
                    // MONITOREXIT : iMPJobManager3
                    int n = 0;
                    while (n < objectList.size) {
                        ((JobManager.ExecutionListener)objectList.get(n)).executionFinished((JobManager)this);
                        ++n;
                    }
                    throw throwable;
                }
                Utils.flushHandlers((Logger)this.workbench.getLogger());
            }
        }
        catch (Throwable throwable) {
            Main.logSevere((Throwable)throwable);
        }
        this.workbench.getRegistry().getRegistryGraph().removeXAListener((XAListener)this);
        this.workbench.getRegistry().getProjectGraph().removeXAListener((XAListener)this);
        this.running = false;
        this.queue = null;
        this.workbench.dispose(this.afterDispose);
    }

    void stop(Command command) {
        this.tcontext.check();
        this.running = false;
        this.afterDispose = command;
    }

    public synchronized void addExecutionListener(JobManager.ExecutionListener executionListener) {
        this.listeners.add((Object)executionListener);
    }

    public synchronized void removeExecutionListener(JobManager.ExecutionListener executionListener) {
        this.listeners.remove((Object)executionListener);
    }
}

