/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.imp.IMP;
import de.grogra.imp.Renderer;
import de.grogra.imp.io.ImageReader;
import de.grogra.imp.objects.ImageAdapter;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ObjectSourceImpl;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.PPMImageReader;
import de.grogra.util.PPMReader;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.imageio.event.IIOReadUpdateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalRenderer
extends Renderer
implements IIOReadUpdateListener {
    public static final FilterSource.MetaDataKey<Collection<File>> FILELIST = new FilterSource.MetaDataKey("filelist");
    protected Map params;
    protected Process process;
    protected volatile Thread thread;
    protected volatile BufferedImage image;
    protected Thread imageReaderThread;
    protected File in;
    protected File out;
    protected MimeType outMimeType;
    protected javax.imageio.ImageReader imageReader;
    volatile IOException imageReaderException;
    ObjectList<File> files;

    public ExternalRenderer(Map map) {
        this.params = map;
    }

    @Override
    public String getName() {
        return (String)this.params.get((Object)"Name", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() throws IOException {
        this.in = this.createTempFile();
        final Workbench workbench = this.view.getWorkbench();
        workbench.beginStatus((Object)this);
        workbench.setStatus((Object)this, IMP.I18N.msg("renderer.exporting"), -1.0f);
        try {
            this.files = new ObjectList();
            StringMap stringMap = new StringMap(this.params);
            stringMap.putBoolean("temporary", true);
            stringMap.putObject(FILELIST.toString(), this.files);
            FilterSource filterSource = IO.createPipeline((FilterSource)new ObjectSourceImpl((Object)this.view, "view", this.view.getFlavor(), workbench.getRegistry(), (ModifiableMap)stringMap), (IOFlavor)new IOFlavor(this.getMimeType(), 64, null));
            if (filterSource == null) {
                throw new IOException(this.getMimeType() + " not exportable");
            }
            ((FileWriterSource)filterSource).write(this.in);
            this.out = this.createOutFile();
            this.files.push((Object)this.in).push((Object)this.out);
            this.outMimeType = this.getOutputMimeType();
            workbench.beginStatus((Object)this);
            this.process = this.startProcess();
            if (this.out == null) {
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.process.getInputStream());
                    if (this.outMimeType.equals((Object)PPMReader.MIME_TYPE)) {
                        this.imageReader = new PPMImageReader(30);
                        this.imageReader.setInput(ImageIO.createImageInputStream(bufferedInputStream), true);
                    } else {
                        this.imageReader = ImageReader.createImageIOReader(bufferedInputStream, this.outMimeType);
                    }
                }
                catch (IOException iOException) {
                    ExternalRenderer.deleteFiles(this.files);
                    this.process.destroy();
                    throw iOException;
                }
                this.imageReader.addIIOReadUpdateListener(this);
                this.imageReaderThread = new Thread(){

                    public void run() {
                        block4: {
                            try {
                                ExternalRenderer.this.image = ExternalRenderer.this.imageReader.read(0, ExternalRenderer.this.imageReader.getDefaultReadParam());
                            }
                            catch (IOException iOException) {
                                if (!Thread.interrupted()) {
                                    ExternalRenderer.this.imageReaderException = iOException;
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                if (Thread.interrupted()) break block4;
                                runtimeException.printStackTrace();
                            }
                        }
                    }
                };
                this.imageReaderThread.setPriority(1);
            }
            this.thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ExternalRenderer.this.watchProcess();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        ExternalRenderer.this.imageUpdate(ExternalRenderer.this.image, 192, 0, 0, 0, 0);
                    }
                    finally {
                        ExternalRenderer.deleteFiles(ExternalRenderer.this.files);
                    }
                    workbench.clearStatusAndProgress((Object)ExternalRenderer.this);
                    ExternalRenderer.this.thread = null;
                }
            };
            this.thread.start();
        }
        finally {
            if (this.thread == null) {
                workbench.clearStatusAndProgress((Object)this);
            }
        }
    }

    static void deleteFiles(ObjectList<File> objectList) {
        while (!objectList.isEmpty()) {
            File file = (File)objectList.pop();
            if (file == null) continue;
            file.delete();
        }
    }

    protected File createTempFile() throws IOException {
        File file = File.createTempFile("renderer", null);
        file.deleteOnExit();
        return file;
    }

    protected File createOutFile() throws IOException {
        if (this.useStdOut()) {
            return null;
        }
        File file = File.createTempFile("renderer", ".out");
        file.deleteOnExit();
        return file;
    }

    protected boolean useStdOut() {
        return Boolean.TRUE.equals(this.params.get((Object)"stdout", null));
    }

    private static void copyErr(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.available()) > 0) {
            System.err.write(byArray, 0, inputStream.read(byArray, 0, Math.min(n, byArray.length)));
        }
    }

    protected void watchProcess() throws IOException {
        boolean bl;
        Process process = this.process;
        if (process == null) {
            return;
        }
        Workbench workbench = this.view.getWorkbench();
        InputStream inputStream = process.getErrorStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        boolean bl2 = bl = this.out == null;
        while (this.thread != null) {
            Thread thread;
            if (this.imageReaderException != null) {
                throw this.imageReaderException;
            }
            if (bl && process.getInputStream().available() > 0) {
                bl = false;
                thread = this.imageReaderThread;
                if (thread != null) {
                    thread.start();
                }
                workbench.setStatus((Object)this, IMP.I18N.msg("renderer.running.stdout"), -1.0f);
            }
            ExternalRenderer.copyErr(inputStream, byArray);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if ((++n & 7) == 0 && this.out != null && this.out.exists() && this.out.length() > 0L) {
                workbench.setStatus((Object)this, IMP.I18N.msg("renderer.running.file", (Object)new Long(this.out.length())), -1.0f);
            }
            try {
                ExternalRenderer.copyErr(inputStream, byArray);
                if (process.exitValue() != 0) {
                    throw new IOException("Exit value " + process.exitValue());
                }
                if (this.out != null) {
                    thread = IO.createPipeline((FilterSource)new FileSource(this.out, this.outMimeType, workbench.getRegistry(), null), (IOFlavor)ImageReader.FLAVOR);
                    if (!(thread instanceof ObjectSource)) {
                        throw new IOException("Cannot read output file");
                    }
                    this.image = ((ImageAdapter)((Object)((ObjectSource)thread).getObject())).getBufferedImage();
                }
                if (this.image != null) {
                    this.imageUpdate(this.image, 32, 0, 0, this.image.getWidth(), this.image.getHeight());
                }
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
    }

    protected MimeType getMimeType() {
        return new MimeType((String)this.params.get((Object)"mimein", null), null);
    }

    protected MimeType getOutputMimeType() {
        return new MimeType((String)this.params.get((Object)"mimeout", null), null);
    }

    protected Process startProcess() throws IOException {
        StringMap stringMap = new StringMap(this.params);
        stringMap.putObject("in", (Object)this.in.getAbsolutePath()).putObject("out", (Object)(this.out == null ? "-" : this.out.getAbsolutePath())).putObject("dir", (Object)this.in.getParentFile().getAbsolutePath()).putInt("width", this.width).putInt("height", this.height).putObject("mimeout", (Object)this.outMimeType.getMediaType());
        String string = Utils.eval((String)((String)this.params.get((Object)"command", null)), (Map)stringMap);
        this.view.getWorkbench().setStatus((Object)this, IMP.I18N.msg("renderer.starting", (Object)string), -1.0f);
        return Runtime.getRuntime().exec(string, null, this.in.getParentFile());
    }

    public synchronized void dispose() {
        Thread thread = this.thread;
        if (thread != null) {
            this.thread = null;
            thread.interrupt();
        }
        if ((thread = this.imageReaderThread) != null) {
            this.imageReaderThread = null;
            thread.interrupt();
        }
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    @Override
    public void passComplete(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage) {
    }

    @Override
    public void thumbnailPassComplete(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage) {
    }

    @Override
    public void passStarted(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
    }

    @Override
    public void thumbnailPassStarted(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
    }

    @Override
    public void imageUpdate(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.imageUpdate(bufferedImage, 8, n, n2, n3, n4);
    }

    @Override
    public void thumbnailUpdate(javax.imageio.ImageReader imageReader, BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
    }
}

