/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class Vector2d
extends Tuple2d
implements Serializable {
    public Vector2d(double d, double d2) {
        super(d, d2);
    }

    public Vector2d(double[] dArray) {
        super(dArray);
    }

    public Vector2d(Vector2d vector2d) {
        super(vector2d);
    }

    public Vector2d(Vector2f vector2f) {
        super(vector2f);
    }

    public Vector2d(Tuple2d tuple2d) {
        super(tuple2d);
    }

    public Vector2d(Tuple2f tuple2f) {
        super(tuple2f);
    }

    public Vector2d() {
    }

    public final double dot(Vector2d vector2d) {
        return this.x * vector2d.x + this.y * vector2d.y;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final void normalize() {
        double d = this.length();
        this.x /= d;
        this.y /= d;
    }

    public final void normalize(Vector2d vector2d) {
        this.set(vector2d);
        this.normalize();
    }

    public final double angle(Vector2d vector2d) {
        return Math.abs(Math.atan2(this.x * vector2d.y - this.y * vector2d.x, this.dot(vector2d)));
    }

    public Object clone() {
        return new Vector2d(this);
    }
}

