/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;

public class Quat4d
extends Tuple4d
implements Serializable {
    public Quat4d(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public Quat4d(double[] dArray) {
        super(dArray);
    }

    public Quat4d(Quat4d quat4d) {
        super(quat4d);
    }

    public Quat4d(Quat4f quat4f) {
        super(quat4f);
    }

    public Quat4d(Tuple4d tuple4d) {
        super(tuple4d);
    }

    public Quat4d(Tuple4f tuple4f) {
        super(tuple4f);
    }

    public Quat4d() {
    }

    public final void conjugate(Quat4d quat4d) {
        this.x = -quat4d.x;
        this.y = -quat4d.y;
        this.z = -quat4d.z;
        this.w = quat4d.w;
    }

    public final void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void mul(Quat4d quat4d, Quat4d quat4d2) {
        this.set(quat4d.x * quat4d2.w + quat4d.w * quat4d2.x + quat4d.y * quat4d2.z - quat4d.z * quat4d2.y, quat4d.y * quat4d2.w + quat4d.w * quat4d2.y + quat4d.z * quat4d2.x - quat4d.x * quat4d2.z, quat4d.z * quat4d2.w + quat4d.w * quat4d2.z + quat4d.x * quat4d2.y - quat4d.y * quat4d2.x, quat4d.w * quat4d2.w - quat4d.x * quat4d2.x - quat4d.y * quat4d2.y - quat4d.z * quat4d2.z);
    }

    public final void mul(Quat4d quat4d) {
        this.set(this.x * quat4d.w + this.w * quat4d.x + this.y * quat4d.z - this.z * quat4d.y, this.y * quat4d.w + this.w * quat4d.y + this.z * quat4d.x - this.x * quat4d.z, this.z * quat4d.w + this.w * quat4d.z + this.x * quat4d.y - this.y * quat4d.x, this.w * quat4d.w - this.x * quat4d.x - this.y * quat4d.y - this.z * quat4d.z);
    }

    public final void mulInverse(Quat4d quat4d, Quat4d quat4d2) {
        double d = this.norm();
        d = d == 0.0 ? d : 1.0 / d;
        this.set((quat4d.x * quat4d2.w - quat4d.w * quat4d2.x - quat4d.y * quat4d2.z + quat4d.z * quat4d2.y) * d, (quat4d.y * quat4d2.w - quat4d.w * quat4d2.y - quat4d.z * quat4d2.x + quat4d.x * quat4d2.z) * d, (quat4d.z * quat4d2.w - quat4d.w * quat4d2.z - quat4d.x * quat4d2.y + quat4d.y * quat4d2.x) * d, (quat4d.w * quat4d2.w + quat4d.x * quat4d2.x + quat4d.y * quat4d2.y + quat4d.z * quat4d2.z) * d);
    }

    public final void mulInverse(Quat4d quat4d) {
        double d = this.norm();
        d = d == 0.0 ? d : 1.0 / d;
        this.set((this.x * quat4d.w - this.w * quat4d.x - this.y * quat4d.z + this.z * quat4d.y) * d, (this.y * quat4d.w - this.w * quat4d.y - this.z * quat4d.x + this.x * quat4d.z) * d, (this.z * quat4d.w - this.w * quat4d.z - this.x * quat4d.y + this.y * quat4d.x) * d, (this.w * quat4d.w + this.x * quat4d.x + this.y * quat4d.y + this.z * quat4d.z) * d);
    }

    private final double norm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final void inverse(Quat4d quat4d) {
        double d = quat4d.norm();
        this.x = -quat4d.x / d;
        this.y = -quat4d.y / d;
        this.z = -quat4d.z / d;
        this.w = quat4d.w / d;
    }

    public final void inverse() {
        double d = this.norm();
        this.x = -this.x / d;
        this.y = -this.y / d;
        this.z = -this.z / d;
        this.w /= d;
    }

    public final void normalize(Quat4d quat4d) {
        double d = Math.sqrt(quat4d.norm());
        this.x = quat4d.x / d;
        this.y = quat4d.y / d;
        this.z = quat4d.z / d;
        this.w = quat4d.w / d;
    }

    public final void normalize() {
        double d = Math.sqrt(this.norm());
        this.x /= d;
        this.y /= d;
        this.z /= d;
        this.w /= d;
    }

    public final void set(Matrix4f matrix4f) {
        this.setFromMat(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m20, matrix4f.m21, matrix4f.m22);
    }

    public final void set(Matrix4d matrix4d) {
        this.setFromMat(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m20, matrix4d.m21, matrix4d.m22);
    }

    public final void set(Matrix3f matrix3f) {
        this.setFromMat(matrix3f.m00, matrix3f.m01, matrix3f.m02, matrix3f.m10, matrix3f.m11, matrix3f.m12, matrix3f.m20, matrix3f.m21, matrix3f.m22);
    }

    public final void set(Matrix3d matrix3d) {
        this.setFromMat(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d2 = Math.sin(0.5 * (double)axisAngle4f.angle) / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w = Math.cos(0.5 * (double)axisAngle4f.angle);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d2 = Math.sin(0.5 * axisAngle4d.angle) / d;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.w = Math.cos(0.5 * axisAngle4d.angle);
    }

    public final void interpolate(Quat4d quat4d, double d) {
        this.normalize();
        double d2 = Math.sqrt(quat4d.norm());
        double d3 = quat4d.x / d2;
        double d4 = quat4d.y / d2;
        double d5 = quat4d.z / d2;
        double d6 = quat4d.w / d2;
        double d7 = this.x * d3 + this.y * d4 + this.z * d5 + this.w * d6;
        if (1.0 <= Math.abs(d7)) {
            return;
        }
        double d8 = Math.sin(d7 = Math.acos(d7));
        if (d8 == 0.0) {
            return;
        }
        double d9 = Math.sin((1.0 - d) * d7) / d8;
        d7 = Math.sin(d * d7) / d8;
        this.x = d9 * this.x + d7 * d3;
        this.y = d9 * this.y + d7 * d4;
        this.z = d9 * this.z + d7 * d5;
        this.w = d9 * this.w + d7 * d6;
    }

    public final void interpolate(Quat4d quat4d, Quat4d quat4d2, double d) {
        this.set(quat4d);
        this.interpolate(quat4d2, d);
    }

    private void setFromMat(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d + d5 + d9;
        if (d10 >= 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            this.w = d11 * 0.5;
            d11 = 0.5 / d11;
            this.x = (d8 - d6) * d11;
            this.y = (d3 - d7) * d11;
            this.z = (d4 - d2) * d11;
        } else {
            double d12 = Math.max(Math.max(d, d5), d9);
            if (d12 == d) {
                double d13 = Math.sqrt(d - (d5 + d9) + 1.0);
                this.x = d13 * 0.5;
                d13 = 0.5 / d13;
                this.y = (d2 + d4) * d13;
                this.z = (d7 + d3) * d13;
                this.w = (d8 - d6) * d13;
            } else if (d12 == d5) {
                double d14 = Math.sqrt(d5 - (d9 + d) + 1.0);
                this.y = d14 * 0.5;
                d14 = 0.5 / d14;
                this.z = (d6 + d8) * d14;
                this.x = (d2 + d4) * d14;
                this.w = (d3 - d7) * d14;
            } else {
                double d15 = Math.sqrt(d9 - (d + d5) + 1.0);
                this.z = d15 * 0.5;
                d15 = 0.5 / d15;
                this.x = (d7 + d3) * d15;
                this.y = (d6 + d8) * d15;
                this.w = (d4 - d2) * d15;
            }
        }
    }

    public Object clone() {
        return new Quat4d(this);
    }
}

