/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.DefaultCellIterator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Mesh;
import de.grogra.vecmath.geom.Octree;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import de.grogra.vecmath.geom.VolumeBase;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class MeshVolume
extends VolumeBase
implements Cloneable {
    public static int MIN_CELL_OBJECTS = 15;
    OctreeImpl octree;
    Point3d min;
    Point3d max;
    Matrix4d worldToMesh = new Matrix4d();
    Matrix3d normalToWorld = new Matrix3d();
    double magnitude;
    static final int FLOATS_PER_VERTEX = 5;
    float[] vertexCoordinates;
    int[] edges;
    float[] crossProducts;
    int[] polys;
    float[] polyTransformations;
    int polyCount;
    boolean closed;
    float[] boxPolyData;
    int[] boxPolyIndex;

    public int getPolygonCount() {
        return this.polyCount;
    }

    public Octree getOctree() {
        return this.octree;
    }

    static int countVolumes(Octree.Cell cell) {
        int n = cell.getVolumeCount();
        if (cell.children != null) {
            for (int i = 0; i < 8; ++i) {
                n += MeshVolume.countVolumes(cell.children[i]);
            }
        }
        return n;
    }

    static void push(FloatList floatList, Tuple3d tuple3d) {
        floatList.push((float)tuple3d.x).push((float)tuple3d.y).push((float)tuple3d.z);
    }

    public MeshVolume dup() {
        try {
            MeshVolume meshVolume = (MeshVolume)this.clone();
            meshVolume.octree = this.octree.dup(meshVolume);
            return meshVolume;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    private static int d2i(double d) {
        return (d > 0.0 ? (int)(511.5 * d) : (int)(511.5 * d - 1.0)) & 0x3FF;
    }

    public void setMesh(Mesh mesh) {
        int n;
        int n2;
        int n3 = mesh.getPolygonCount();
        int[] nArray = new int[mesh.getMaxEdgeCount()];
        int[] nArray2 = new int[mesh.getMaxEdgeCount()];
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        point3d.z = Double.POSITIVE_INFINITY;
        point3d.y = Double.POSITIVE_INFINITY;
        point3d.x = Double.POSITIVE_INFINITY;
        point3d2.z = Double.NEGATIVE_INFINITY;
        point3d2.y = Double.NEGATIVE_INFINITY;
        point3d2.x = Double.NEGATIVE_INFINITY;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        Vector3d vector3d6 = new Vector3d();
        Vector2d vector2d = new Vector2d();
        this.vertexCoordinates = new float[mesh.getVertexCount() * 5];
        for (int i = mesh.getVertexCount() - 1; i >= 0; --i) {
            mesh.getVertex(i, vector3d3);
            Math2.min(point3d, vector3d3);
            Math2.max(point3d2, vector3d3);
            int n4 = i * 5;
            this.vertexCoordinates[n4] = (float)vector3d3.x;
            this.vertexCoordinates[n4 + 1] = (float)vector3d3.y;
            this.vertexCoordinates[n4 + 2] = (float)vector3d3.z;
            mesh.getUV(i, vector2d);
            this.vertexCoordinates[n4 + 3] = (float)vector2d.x;
            this.vertexCoordinates[n4 + 4] = (float)vector2d.y;
        }
        this.magnitude = point3d2.distance(point3d);
        IntList intList = new IntList(6 * n3).push(0);
        IntList intList2 = new IntList(4 * n3);
        IntList intList3 = new IntList(4 * n3);
        IntList intList4 = new IntList(4 * n3);
        FloatList floatList = new FloatList(11 * n3);
        int[] nArray3 = new int[mesh.getVertexCount()];
        FloatList floatList2 = new FloatList(n3 * 8);
        double d = point3d2.distanceSquared(point3d) * 1.0E-8;
        IntList intList5 = new IntList(n3);
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        Vector3d vector3d7 = new Vector3d();
        Matrix3d matrix3d = new Matrix3d();
        for (int i = 0; i < n3; ++i) {
            int n5;
            n2 = mesh.isPolygonPlanar(i);
            n = mesh.getPolygon(i, nArray, nArray2);
            for (int j = n5 = n2 != 0 ? n - 1 : 2; j < n; ++j) {
                if (n2 == 0) {
                    nArray[1] = nArray[j - 1];
                    nArray[2] = nArray[j];
                    nArray2[1] = nArray2[j - 1];
                    nArray2[2] = nArray2[j];
                }
                int n6 = intList3.size;
                intList3.push(floatList2.size);
                int n7 = 0;
                int n8 = nArray[0];
                mesh.getVertex(n8, vector3d);
                point3d3.set(vector3d);
                point3d4.set(vector3d);
                vector3d7.z = 0.0;
                vector3d7.y = 0.0;
                vector3d7.x = 0.0;
                double d2 = 0.0;
                for (int k = 0; k <= n5; ++k) {
                    int n9;
                    boolean bl;
                    int n10;
                    block20: {
                        int n11;
                        int n12;
                        n10 = nArray[k == n5 ? 0 : k + 1];
                        mesh.getVertex(n10, vector3d2);
                        Math2.min(point3d3, vector3d2);
                        Math2.max(point3d4, vector3d2);
                        vector3d6.sub(vector3d2, vector3d);
                        double d3 = vector3d6.lengthSquared();
                        if (d3 < d) continue;
                        d2 += Math.sqrt(d3);
                        vector3d6.cross(vector3d2, vector3d);
                        vector3d7.add(vector3d6);
                        switch (++n7) {
                            case 1: {
                                vector3d3.set(vector3d);
                                break;
                            }
                            case 2: {
                                vector3d4.sub(vector3d, vector3d3);
                                vector3d5.sub(vector3d2, vector3d);
                                break;
                            }
                            case 3: {
                                matrix3d.setColumn(0, vector3d4);
                                matrix3d.setColumn(1, vector3d5);
                                vector3d4.cross(vector3d4, vector3d5);
                                matrix3d.setColumn(2, vector3d4);
                                matrix3d.invert();
                                floatList2.push((float)matrix3d.m00).push((float)matrix3d.m01).push((float)matrix3d.m02).push((float)matrix3d.m10).push((float)matrix3d.m11).push((float)matrix3d.m12);
                                break;
                            }
                            case 4: {
                                vector3d4.sub(vector3d, vector3d3);
                                matrix3d.transform(vector3d4);
                                floatList2.push((float)(vector3d4.x / vector3d4.y)).push(Math.abs(vector3d4.y - 1.0) < 1.0E-6 ? 1000000.0f : (float)((vector3d4.y - vector3d4.x) / (vector3d4.y - 1.0)));
                                int n13 = n6;
                                intList3.elements[n13] = intList3.elements[n13] | 1;
                            }
                        }
                        if (n8 > n10) {
                            bl = true;
                            n12 = n10;
                            n11 = n8;
                        } else {
                            bl = false;
                            n12 = n8;
                            n11 = n10;
                        }
                        int n14 = nArray3[n12];
                        if (n14 == 0) {
                            nArray3[n12] = intList.size;
                        } else {
                            while (true) {
                                if (intList.elements[n14] == n11) {
                                    n9 = intList.elements[n14 + 1];
                                    break block20;
                                }
                                int n15 = intList.elements[n14 + 2];
                                if (n15 == 0) {
                                    intList.elements[n14 + 2] = intList.size;
                                    break;
                                }
                                n14 = n15;
                            }
                        }
                        n9 = intList2.size;
                        intList2.push(n12 * 5).push(n11 * 5);
                        intList.push(n11).push(n9).push(0);
                    }
                    intList3.push(bl ? n9 | 1 : n9);
                    mesh.getNormal(nArray2[k], vector3d6);
                    vector3d6.normalize();
                    intList3.push(MeshVolume.d2i(vector3d6.x) + (MeshVolume.d2i(vector3d6.y) << 10) + (MeshVolume.d2i(vector3d6.z) << 20));
                    n8 = n10;
                    Vector3d vector3d8 = vector3d;
                    vector3d = vector3d2;
                    vector3d2 = vector3d8;
                }
                if (n7 < 3) {
                    intList3.setSize(n6);
                    continue;
                }
                intList5.push(n6);
                int n16 = intList3.size - 2;
                intList3.elements[n16] = intList3.elements[n16] | Integer.MIN_VALUE;
                intList4.setSize(n6 + 1);
                intList4.elements[n6] = floatList.size;
                vector3d7.normalize();
                MeshVolume.push(floatList, point3d3);
                MeshVolume.push(floatList, point3d4);
                MeshVolume.push(floatList, vector3d7);
                floatList.push((float)vector3d7.dot(vector3d)).push(1.0E-4f * (float)d2);
            }
        }
        this.polyCount = intList5.size;
        CellImpl cellImpl = new CellImpl(9, 0);
        cellImpl.volumeCount = this.polyCount;
        cellImpl.polys = intList5.toArray();
        this.boxPolyIndex = intList4.elements;
        intList4 = null;
        this.boxPolyData = floatList.elements;
        floatList = null;
        this.polyTransformations = floatList2.toArray();
        floatList2 = null;
        this.edges = intList2.toArray();
        intList2 = null;
        this.polys = intList3.toArray();
        intList3 = null;
        this.crossProducts = new float[this.edges.length * 3 >> 1];
        n2 = 0;
        n = 0;
        while (n2 < this.edges.length) {
            mesh.getVertex(this.edges[n2] / 5, vector3d3);
            mesh.getVertex(this.edges[n2 + 1] / 5, vector3d4);
            vector3d4.cross(vector3d3, vector3d4);
            this.crossProducts[n] = (float)vector3d4.x;
            this.crossProducts[n + 1] = (float)vector3d4.y;
            this.crossProducts[n + 2] = (float)vector3d4.z;
            n2 += 2;
            n += 3;
        }
        this.closed = mesh.isClosed();
        DefaultCellIterator defaultCellIterator = new DefaultCellIterator();
        this.octree = new OctreeImpl(this, defaultCellIterator);
        this.octree.initialize(Octree.suggestDepth(this.polyCount), MIN_CELL_OBJECTS, point3d, point3d2, cellImpl);
        defaultCellIterator.initialize(this.octree);
        this.boxPolyData = null;
        this.boxPolyIndex = null;
    }

    public void setTransformation(Matrix4d matrix4d) {
        this.worldToMesh = new Matrix4d();
        this.worldToMesh.m33 = 1.0;
        Math2.invertAffine(matrix4d, this.worldToMesh);
        this.normalToWorld = new Matrix3d();
        this.worldToMesh.getRotationScale(this.normalToWorld);
        this.normalToWorld.transpose();
        this.min = new Point3d();
        this.max = new Point3d();
        this.min.z = Double.POSITIVE_INFINITY;
        this.min.y = Double.POSITIVE_INFINITY;
        this.min.x = Double.POSITIVE_INFINITY;
        this.max.z = Double.NEGATIVE_INFINITY;
        this.max.y = Double.NEGATIVE_INFINITY;
        this.max.x = Double.NEGATIVE_INFINITY;
        Point3d point3d = new Point3d();
        for (int i = 0; i < this.vertexCoordinates.length; i += 5) {
            point3d.x = this.vertexCoordinates[i];
            point3d.y = this.vertexCoordinates[i + 1];
            point3d.z = this.vertexCoordinates[i + 2];
            matrix4d.transform(point3d);
            Math2.min(this.min, point3d);
            Math2.max(this.max, point3d);
        }
    }

    private void getNormal(int n, Vector3d vector3d) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = this.crossProducts;
        int n2 = n + 1;
        while (true) {
            int n3 = this.polys[n2];
            int n4 = (n3 & 0x7FFFFFFE) * 3 >> 1;
            if ((n3 & 1) == 0) {
                f += fArray[n4];
                f2 += fArray[n4 + 1];
                f3 += fArray[n4 + 2];
            } else {
                f -= fArray[n4];
                f2 -= fArray[n4 + 1];
                f3 -= fArray[n4 + 2];
            }
            if (n3 < 0) {
                vector3d.x = f;
                vector3d.y = f2;
                vector3d.z = f3;
                return;
            }
            n2 += 2;
        }
    }

    public void computeFaceNormal(Intersection intersection, Vector3d vector3d) {
        this.getNormal(intersection.face, vector3d);
        this.normalToWorld.transform(vector3d);
        vector3d.normalize();
    }

    private float getMagnitude(int n) {
        float[] fArray = this.vertexCoordinates;
        float f = 0.0f;
        int n2 = this.edges[this.polys[n + 1]];
        int n3 = n + 3;
        while (true) {
            int n4 = this.edges[this.polys[n3] & Integer.MAX_VALUE];
            f += Math.abs(fArray[n4] - fArray[n2]) + Math.abs(fArray[n4 + 1] - fArray[n2 + 1]) + Math.abs(fArray[n4 + 2] - fArray[n2 + 2]);
            if (this.polys[n3] < 0) {
                return f;
            }
            n2 = n4;
            n3 += 2;
        }
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        int n2;
        int n3;
        int n4 = n;
        double d = line.start;
        double d2 = line.end;
        boolean bl = false;
        Tuple3d tuple3d = line.origin;
        line.origin = intersectionList.tmpPoint0;
        Math2.transformPoint(this.worldToMesh, tuple3d, line.origin);
        Vector3d vector3d = line.direction;
        line.direction = intersectionList.tmpVector0;
        this.worldToMesh.transform(vector3d, line.direction);
        double d3 = 1.0E-4 / line.direction.length();
        if (intersection != null && intersection.volume == this) {
            n3 = intersection.face;
            line.start -= d3 * this.magnitude;
            n4 = 0;
            bl = true;
        } else {
            intersection = null;
            n3 = -1;
        }
        if (intersection2 != null && intersection2.volume == this) {
            n2 = intersection2.face;
            if (n3 == n2) {
                line.origin = tuple3d;
                line.direction = vector3d;
                return false;
            }
            line.end += d3 * this.magnitude;
            n4 = 0;
            bl = true;
        } else {
            intersection2 = null;
            n2 = -1;
        }
        StateImpl stateImpl = (StateImpl)intersectionList.cache.get(this);
        if (stateImpl == null) {
            stateImpl = (StateImpl)this.octree.createState();
            intersectionList.cache.put(this, stateImpl);
        }
        stateImpl.setLine(line, n3, n2);
        int n5 = intersectionList.size;
        boolean bl2 = this.octree.computeIntersections(line, n4, intersectionList, intersection, intersection2, stateImpl);
        if (bl) {
            line.start = d;
            line.end = d2;
            if (intersectionList.size > n5) {
                block14: {
                    int n6;
                    block13: {
                        if (stateImpl.excludeStartFace >= 0 && (n6 = intersectionList.findClosestIntersection(d, d3 * (double)this.getMagnitude(stateImpl.excludeStartFace), n5, intersectionList.size)) >= 0) {
                            intersectionList.remove(n6, n6 + 1);
                        }
                        if (stateImpl.excludeEndFace >= 0 && (n6 = intersectionList.findClosestIntersection(d2, d3 * (double)this.getMagnitude(stateImpl.excludeEndFace), n5, intersectionList.size)) >= 0) {
                            intersectionList.remove(n6, n6 + 1);
                        }
                        for (n6 = n5; n6 < intersectionList.size; ++n6) {
                            if (!(intersectionList.elements[n6].parameter >= d)) continue;
                            intersectionList.remove(n5, n6);
                            break block13;
                        }
                        intersectionList.size = n5;
                    }
                    for (n6 = intersectionList.size - 1; n6 >= n5; --n6) {
                        if (!(intersectionList.elements[n6].parameter <= d2)) continue;
                        intersectionList.remove(n6 + 1, intersectionList.size);
                        break block14;
                    }
                    intersectionList.size = n5;
                }
                if (n != 0 && intersectionList.size > n5) {
                    intersectionList.size = n5 + 1;
                }
            }
        }
        line.origin = tuple3d;
        line.direction = vector3d;
        return bl2;
    }

    boolean boxContainsPolygon(Point3d point3d, Point3d point3d2, Variables variables, int n) {
        int n2;
        double d;
        double d2;
        int n3;
        Object object;
        Vector3d vector3d = variables.tmpVector0;
        Vector3d vector3d2 = variables.tmpVector1;
        if (this.boxPolyData != null) {
            object = this.boxPolyData;
            n3 = this.boxPolyIndex[n];
            if ((double)object[n3] > point3d2.x || (double)object[n3 + 1] > point3d2.y || (double)object[n3 + 2] > point3d2.z) {
                return false;
            }
            if ((double)object[n3 + 3] < point3d.x || (double)object[n3 + 4] < point3d.y || (double)object[n3 + 5] < point3d.z) {
                return false;
            }
            vector3d.x = (double)object[n3 + 6];
            vector3d.y = (double)object[n3 + 7];
            vector3d.z = (double)object[n3 + 8];
            d2 = (double)object[n3 + 9];
            d = (double)object[n3 + 10];
        } else {
            Point3d point3d3 = variables.tmpPoint0;
            object = variables.tmpPoint1;
            n2 = n + 1;
            while (true) {
                int n4 = this.polys[n2];
                int n5 = this.edges[n4 & Integer.MAX_VALUE];
                vector3d2.x = this.vertexCoordinates[n5];
                vector3d2.y = this.vertexCoordinates[n5 + 1];
                vector3d2.z = this.vertexCoordinates[n5 + 2];
                if (n2 == n + 1) {
                    point3d3.set(vector3d2);
                    ((Tuple3d)object).set(vector3d2);
                } else {
                    Math2.min(point3d3, vector3d2);
                    Math2.max((Tuple3d)object, vector3d2);
                }
                if (n4 < 0) {
                    if (Math2.lessThanOrEqual(point3d, (Tuple3d)object) && Math2.lessThanOrEqual(point3d3, point3d2)) break;
                    return false;
                }
                n2 += 2;
            }
            this.getNormal(n, vector3d);
            vector3d.normalize();
            d2 = vector3d.dot(vector3d2);
            d = 1.0E-4 * (double)this.getMagnitude(n);
        }
        n3 = 0;
        boolean bl = false;
        for (n2 = 0; n2 <= 1; ++n2) {
            double d3 = vector3d.x * (n2 == 0 ? point3d : point3d2).x - d2;
            for (int i = 0; i <= 1; ++i) {
                double d4 = d3 + vector3d.y * (i == 0 ? point3d : point3d2).y;
                for (int j = 0; j <= 1; ++j) {
                    double d5 = d4 + vector3d.z * (j == 0 ? point3d : point3d2).z;
                    if (d5 > d) {
                        if (bl) {
                            return true;
                        }
                        n3 = 1;
                        continue;
                    }
                    if (d5 < -d) {
                        if (n3 != 0) {
                            return true;
                        }
                        bl = true;
                        continue;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        return false;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(this.min);
        tuple3d2.set(this.max);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        return Math2.lessThanOrEqual(boundingBox.min, this.max) && Math2.lessThanOrEqual(this.min, boundingBox.max);
    }

    private boolean getUVOfPoly(Intersection intersection, Tuple3d tuple3d) {
        if (intersection.volumeVector.z < 0.0) {
            intersection.volumeVector.z = 1.0;
            Math2.transformPoint(this.worldToMesh, intersection.getPoint(), tuple3d);
            int n = this.polys[intersection.face] & 0xFFFFFFFE;
            int n2 = this.edges[this.polys[intersection.face + 1]];
            double d = tuple3d.x - (double)this.vertexCoordinates[n2];
            double d2 = tuple3d.y - (double)this.vertexCoordinates[n2 + 1];
            double d3 = tuple3d.z - (double)this.vertexCoordinates[n2 + 2];
            double d4 = (double)this.polyTransformations[n] * d + (double)this.polyTransformations[n + 1] * d2 + (double)this.polyTransformations[n + 2] * d3;
            double d5 = (double)this.polyTransformations[n + 3] * d + (double)this.polyTransformations[n + 4] * d2 + (double)this.polyTransformations[n + 5] * d3;
            if ((this.polys[intersection.face] & 1) != 0) {
                double d6 = this.polyTransformations[n + 6];
                intersection.volumeVector.x = 1.0 + (1.0 - d4) / (d5 * d6 - 1.0);
                d6 = this.polyTransformations[n + 7];
                intersection.volumeVector.y = d5 * (1.0 - d6) / (d4 - d6);
                return true;
            }
            intersection.volumeVector.x = d4;
            intersection.volumeVector.y = d4 < 1.0E-6 ? 0.0 : d5 / d4;
            return false;
        }
        return (this.polys[intersection.face] & 1) != 0;
    }

    private void interpolate(int n, boolean bl, Intersection intersection, Tuple3d tuple3d) {
        int n2;
        boolean bl2 = this.getUVOfPoly(intersection, tuple3d);
        int n3 = intersection.face + 1;
        double d = intersection.volumeVector.x;
        double d2 = intersection.volumeVector.y;
        double d3 = d * (1.0 - d2);
        if (n < 0) {
            n2 = this.polys[n3 + 3];
            tuple3d.x = d3 * (double)(n2 << 22 | 0x200000);
            tuple3d.y = d3 * (double)(n2 << 12 | 0x200000);
            tuple3d.z = d3 * (double)(n2 << 2 | 0x200000);
        } else {
            n2 = this.edges[this.polys[n3 + 2]] + n;
            tuple3d.x = d3 * (double)this.vertexCoordinates[n2];
            tuple3d.y = d3 * (double)this.vertexCoordinates[n2 + 1];
            if (bl) {
                tuple3d.z = d3 * (double)this.vertexCoordinates[n2 + 2];
            }
        }
        d3 = d * d2;
        if (n < 0) {
            n2 = this.polys[n3 + 5];
            tuple3d.x += d3 * (double)(n2 << 22 | 0x200000);
            tuple3d.y += d3 * (double)(n2 << 12 | 0x200000);
            tuple3d.z += d3 * (double)(n2 << 2 | 0x200000);
        } else {
            n2 = this.edges[this.polys[n3 + 4] & Integer.MAX_VALUE] + n;
            tuple3d.x += d3 * (double)this.vertexCoordinates[n2];
            tuple3d.y += d3 * (double)this.vertexCoordinates[n2 + 1];
            if (bl) {
                tuple3d.z += d3 * (double)this.vertexCoordinates[n2 + 2];
            }
        }
        if (bl2) {
            d3 = (1.0 - d) * (1.0 - d2);
            if (n < 0) {
                n2 = this.polys[n3 + 1];
                tuple3d.x += d3 * (double)(n2 << 22 | 0x200000);
                tuple3d.y += d3 * (double)(n2 << 12 | 0x200000);
                tuple3d.z += d3 * (double)(n2 << 2 | 0x200000);
            } else {
                n2 = this.edges[this.polys[n3]] + n;
                tuple3d.x += d3 * (double)this.vertexCoordinates[n2];
                tuple3d.y += d3 * (double)this.vertexCoordinates[n2 + 1];
                if (bl) {
                    tuple3d.z += d3 * (double)this.vertexCoordinates[n2 + 2];
                }
            }
            d3 = (1.0 - d) * d2;
            if (n < 0) {
                n2 = this.polys[n3 + 7];
                tuple3d.x += d3 * (double)(n2 << 22 | 0x200000);
                tuple3d.y += d3 * (double)(n2 << 12 | 0x200000);
                tuple3d.z += d3 * (double)(n2 << 2 | 0x200000);
            } else {
                n2 = this.edges[this.polys[n3 + 6] & Integer.MAX_VALUE] + n;
                tuple3d.x += d3 * (double)this.vertexCoordinates[n2];
                tuple3d.y += d3 * (double)this.vertexCoordinates[n2 + 1];
                if (bl) {
                    tuple3d.z += d3 * (double)this.vertexCoordinates[n2 + 2];
                }
            }
        } else {
            d3 = 1.0 - d;
            if (n < 0) {
                n2 = this.polys[n3 + 1];
                tuple3d.x += d3 * (double)(n2 << 22 | 0x200000);
                tuple3d.y += d3 * (double)(n2 << 12 | 0x200000);
                tuple3d.z += d3 * (double)(n2 << 2 | 0x200000);
            } else {
                n2 = this.edges[this.polys[n3]] + n;
                tuple3d.x += d3 * (double)this.vertexCoordinates[n2];
                tuple3d.y += d3 * (double)this.vertexCoordinates[n2 + 1];
                if (bl) {
                    tuple3d.z += d3 * (double)this.vertexCoordinates[n2 + 2];
                }
            }
        }
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        this.interpolate(-1, true, intersection, vector3d);
        this.normalToWorld.transform(vector3d);
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        this.interpolate(3, false, intersection, intersection.tmpVector0);
        vector2d.x = intersection.tmpVector0.x;
        vector2d.y = intersection.tmpVector0.y;
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
    }

    private static final class OctreeImpl
    extends Octree
    implements Cloneable {
        private final CellIterator iterator;
        MeshVolume mesh;
        int[] cellPolys;
        int cellPolysIndex;

        OctreeImpl(MeshVolume meshVolume, CellIterator cellIterator) {
            this.mesh = meshVolume;
            this.iterator = cellIterator;
        }

        public Octree.State createState() {
            StateImpl stateImpl = this.mesh.new StateImpl();
            stateImpl.cellIterator = this.iterator.dup();
            return stateImpl;
        }

        OctreeImpl dup(MeshVolume meshVolume) {
            try {
                OctreeImpl octreeImpl = (OctreeImpl)this.clone();
                octreeImpl.mesh = meshVolume;
                return octreeImpl;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }

        protected ArrayList getInfiniteVolumes() {
            return null;
        }

        protected void finishCells() {
            this.cellPolys = new int[MeshVolume.countVolumes(this.getRoot())];
            this.cellPolysIndex = 0;
            super.finishCells();
        }

        int addCellPolys(int[] nArray, int n) {
            int n2 = this.cellPolysIndex;
            System.arraycopy(nArray, 0, this.cellPolys, n2, n);
            this.cellPolysIndex = n2 + n;
            return n2;
        }
    }

    private static final class CellImpl
    extends Octree.Cell {
        int[] polys;
        int polysStart = 0;
        int volumeCount = 0;

        CellImpl(int n, int n2) {
            super(n);
            this.polys = new int[n2];
        }

        public int getVolumeCount() {
            return this.volumeCount;
        }

        public void clearVolumes() {
            this.polys = null;
            this.volumeCount = 0;
        }

        public Volume getVolume(int n, Octree.State state) {
            ((StateImpl)state).currentPolygon = this.polys[this.polysStart + n];
            return (StateImpl)state;
        }

        public void addVolume(Volume volume) {
            this.polys[this.polysStart + this.volumeCount++] = ((StateImpl)volume).currentPolygon;
        }

        protected Octree.Cell createChild(int n) {
            return new CellImpl(n, this.getVolumeCount());
        }

        void finish(Octree octree) {
            super.finish(octree);
            if (this.polys != null) {
                this.polysStart = ((OctreeImpl)octree).addCellPolys(this.polys, this.volumeCount);
                this.polys = ((OctreeImpl)octree).cellPolys;
            }
        }
    }

    private final class StateImpl
    extends Octree.State
    implements Volume {
        int currentPolygon;
        int excludeStartFace;
        int excludeEndFace;
        private final int[] markedPolys;
        private final int[] edgeSigns;
        private final IntList nonzeroEdgeSigns = new IntList(16);
        private float dx;
        private float dy;
        private float dz;
        private float cx;
        private float cy;
        private float cz;

        StateImpl() {
            this.edgeSigns = new int[MeshVolume.this.edges.length + 31 >> 5];
            this.markedPolys = new int[MeshVolume.this.polys.length + 31 >> 5];
        }

        void setLine(Line line, int n, int n2) {
            Vector3d vector3d = this.tmpVector0;
            vector3d.set(line.origin);
            vector3d.cross(vector3d, line.direction);
            this.dx = (float)line.direction.x;
            this.dy = (float)line.direction.y;
            this.dz = (float)line.direction.z;
            this.cx = (float)vector3d.x;
            this.cy = (float)vector3d.y;
            this.cz = (float)vector3d.z;
            int[] nArray = this.nonzeroEdgeSigns.elements;
            for (int i = this.nonzeroEdgeSigns.size - 1; i >= 0; --i) {
                this.edgeSigns[nArray[i]] = 0;
            }
            this.nonzeroEdgeSigns.size = 0;
            this.excludeStartFace = n;
            this.excludeEndFace = n2;
        }

        private int getSign(int n) {
            int n2;
            int n3;
            float[] fArray;
            int n4;
            float[] fArray2;
            int n5 = n & 0x7FFFFFFE;
            int n6 = this.edgeSigns[n5 >> 5];
            if ((n6 & 2 << n5) != 0) {
                return n + (n6 >> n5);
            }
            if (n6 == 0) {
                this.nonzeroEdgeSigns.push(n5 >> 5);
            }
            if (this.dx * (fArray2 = MeshVolume.this.crossProducts)[n4 = n5 * 3 >> 1] + this.dy * fArray2[n4 + 1] + this.dz * fArray2[n4 + 2] + this.cx * ((fArray = MeshVolume.this.vertexCoordinates)[n3 = MeshVolume.this.edges[n5 + 1]] - fArray[n2 = MeshVolume.this.edges[n5]]) + this.cy * (fArray[n3 + 1] - fArray[n2 + 1]) + this.cz * (fArray[n3 + 2] - fArray[n2 + 2]) >= 0.0f) {
                this.edgeSigns[n5 >> 5] = n6 | 3 << n5;
                return n + 1;
            }
            this.edgeSigns[n5 >> 5] = n6 | 2 << n5;
            return n;
        }

        public boolean mark(int n) {
            int n2 = this.markedPolys[n >> 5];
            if ((n2 & 1 << n) != 0) {
                return false;
            }
            this.markedPolys[n >> 5] = n2 | 1 << n;
            return true;
        }

        public void clear(int n) {
            int n2 = n >> 5;
            this.markedPolys[n2] = this.markedPolys[n2] & ~(1 << n);
        }

        public int getId() {
            return this.currentPolygon;
        }

        public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
            int n2 = this.getSign(MeshVolume.this.polys[this.currentPolygon + 1]);
            int n3 = this.currentPolygon + 3;
            int n4;
            while ((n2 + this.getSign(n4 = MeshVolume.this.polys[n3]) & 1) == 0) {
                if (n4 < 0) {
                    if (this.currentPolygon == this.excludeStartFace) {
                        this.excludeStartFace = -1;
                        return false;
                    }
                    if (this.currentPolygon == this.excludeEndFace) {
                        this.excludeEndFace = -1;
                        return false;
                    }
                    Vector3d vector3d = intersectionList.tmpVector1;
                    Vector3d vector3d2 = intersectionList.tmpVector2;
                    MeshVolume.this.getNormal(this.currentPolygon, vector3d);
                    int n5 = MeshVolume.this.edges[n4 & 0x7FFFFFFE];
                    vector3d2.x = MeshVolume.this.vertexCoordinates[n5];
                    vector3d2.y = MeshVolume.this.vertexCoordinates[n5 + 1];
                    vector3d2.z = MeshVolume.this.vertexCoordinates[n5 + 2];
                    vector3d2.sub(line.origin);
                    double d = vector3d2.dot(vector3d) / line.direction.dot(vector3d);
                    if (d >= line.start && d <= line.end) {
                        intersectionList.add((Volume)MeshVolume.this, (Line)line, (double)d, (int)(MeshVolume.this.closed ? ((n2 & 1) == 0 ? 1 : -1) : 0), (int)this.currentPolygon).volumeVector.z = -1.0;
                    }
                    return false;
                }
                n3 += 2;
            }
            return false;
        }

        public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
            return MeshVolume.this.boxContainsPolygon(boundingBox.min, boundingBox.max, variables, this.currentPolygon);
        }

        public boolean contains(Tuple3d tuple3d, boolean bl) {
            return false;
        }

        public void computeNormal(Intersection intersection, Vector3d vector3d) {
            throw new UnsupportedOperationException();
        }

        public void computeUV(Intersection intersection, Vector2d vector2d) {
            throw new UnsupportedOperationException();
        }

        public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
            throw new UnsupportedOperationException();
        }

        public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
            throw new UnsupportedOperationException();
        }

        public void setId(int n) {
            throw new UnsupportedOperationException();
        }

        public Volume operator$com() {
            throw new UnsupportedOperationException();
        }

        public Volume operator$or(Volume volume) {
            throw new UnsupportedOperationException();
        }

        public Volume operator$and(Volume volume) {
            throw new UnsupportedOperationException();
        }

        public Volume operator$sub(Volume volume) {
            throw new UnsupportedOperationException();
        }
    }
}

