/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class HalfSpace
extends TransformableVolume {
    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        double d;
        boolean bl;
        if (intersection != null && intersection.volume == this) {
            return this.m20 * line.direction.x + this.m21 * line.direction.y + this.m22 * line.direction.z <= 0.0;
        }
        if (intersection2 != null && intersection2.volume == this) {
            return this.m20 * line.direction.x + this.m21 * line.direction.y + this.m22 * line.direction.z >= 0.0;
        }
        Point3d point3d = intersectionList.tmpPoint0;
        this.transformPoint(line.origin, point3d);
        Vector3d vector3d = intersectionList.tmpVector0;
        this.transformVector(line.direction, vector3d);
        boolean bl2 = bl = point3d.z <= 0.0;
        if (vector3d.z != 0.0 && line.start <= (d = -point3d.z / vector3d.z) && d <= line.end) {
            intersectionList.add(this, line, d, bl ? -1 : 1);
        }
        return bl;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        double d = this.m20 * (tuple3d.x - this.t0) + this.m21 * (tuple3d.y - this.t1) + this.m22 * (tuple3d.z - this.t2);
        return bl ? d < 0.0 : d <= 0.0;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        tuple3d2.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        Point3d point3d = variables.tmpPoint0;
        Point3d point3d2 = variables.tmpPoint1;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i <= 1; ++i) {
            point3d.x = i == 0 ? boundingBox.min.x : boundingBox.max.x;
            for (int j = 0; j <= 1; ++j) {
                point3d.y = j == 0 ? boundingBox.min.y : boundingBox.max.y;
                for (int k = 0; k <= 1; ++k) {
                    point3d.z = k == 0 ? boundingBox.min.z : boundingBox.max.z;
                    this.transformPoint(point3d, point3d2);
                    if (point3d2.z >= 0.0) {
                        if (bl2) {
                            return true;
                        }
                        bl = true;
                        continue;
                    }
                    if (bl) {
                        return true;
                    }
                    bl2 = true;
                }
            }
        }
        return false;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        vector3d.x = this.m20;
        vector3d.y = this.m21;
        vector3d.z = this.m22;
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        vector2d.x = vector3d.x;
        vector2d.y = vector3d.y;
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        vector3d.set(1.0, 0.0, 0.0);
        vector3d2.set(0.0, 1.0, 0.0);
        this.getObjectToWorldRotationScale().transform(vector3d);
        this.getObjectToWorldRotationScale().transform(vector3d2);
    }
}

