/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Octree;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class DefaultCellIterator
implements CellIterator,
Cloneable {
    private Line line;
    private Octree tree = null;
    private Point3d min;
    private Point3d max;
    private Vector3d eps = new Vector3d();
    private BoundingBox bounds;
    private Vector3d coordToGrid;
    private int enteredFace;
    private Octree.Cell lastCell;
    private Octree.Cell nextCell;
    private double enteringParameter;
    private boolean done;
    private IntersectionList list = new IntersectionList();
    private Vector3d tmpVector = new Vector3d();
    private BoundingBox cellBounds = new BoundingBox(new Point3d(), new Point3d());

    public CellIterator dup() {
        try {
            DefaultCellIterator defaultCellIterator = (DefaultCellIterator)this.clone();
            defaultCellIterator.list = new IntersectionList();
            defaultCellIterator.tmpVector = new Vector3d();
            defaultCellIterator.cellBounds = new BoundingBox(new Point3d(), new Point3d());
            return defaultCellIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public void initialize(Octree octree) {
        this.tree = octree;
        this.min = octree.min;
        this.max = octree.max;
        this.eps.scale(0.1, octree.minCellSize);
        this.bounds = new BoundingBox(this.min, this.max);
        this.coordToGrid = new Vector3d(1.0 / octree.minCellSize.x, 1.0 / octree.minCellSize.y, 1.0 / octree.minCellSize.z);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        if (this.nextCell != null) {
            return true;
        }
        boolean bl = this.hasNextImpl();
        this.done = !bl;
        return bl;
    }

    protected boolean hasNextImpl() {
        double d = this.line.start;
        double d2 = this.line.end;
        this.line.start = -1.7976931348623157E308;
        this.line.end = Double.MAX_VALUE;
        this.list.clear();
        this.lastCell.getExtent(this.tree, this.cellBounds.min, this.cellBounds.max);
        BoundingBox.computeIntersections(this.cellBounds, this.cellBounds.min, this.cellBounds.max, this.line, this.enteredFace < 0, this.list, this.enteredFace, -1);
        this.line.start = d;
        this.line.end = d2;
        if (this.list.size == 0) {
            return false;
        }
        if (this.enteredFace < 0) {
            this.list.remove(0, 1);
        }
        if (this.list.size != 1) {
            throw new RuntimeException("list.size = " + this.list.size);
        }
        Intersection intersection = this.list.elements[0];
        if (intersection.type == 1) {
            throw new RuntimeException("cell entered: " + intersection);
        }
        this.tmpVector.set(intersection.getPoint());
        switch (intersection.face) {
            case 2: {
                this.nextCell = this.lastCell.front;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.y -= this.eps.y;
                if (this.tmpVector.y < this.min.y) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            case 3: {
                this.nextCell = this.lastCell.back;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.y += this.eps.y;
                if (this.tmpVector.y > this.max.y) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            case 5: {
                this.nextCell = this.lastCell.top;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.z += this.eps.z;
                if (this.tmpVector.z > this.max.z) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            case 4: {
                this.nextCell = this.lastCell.bottom;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.z -= this.eps.z;
                if (this.tmpVector.z < this.min.z) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            case 0: {
                this.nextCell = this.lastCell.left;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.x -= this.eps.x;
                if (this.tmpVector.x < this.min.x) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            case 1: {
                this.nextCell = this.lastCell.right;
                if (this.nextCell == null) {
                    return false;
                }
                if (this.nextCell.children == null) break;
                this.tmpVector.x += this.eps.x;
                if (this.tmpVector.x > this.max.x) {
                    return false;
                }
                this.nextCell = this.getCellFromPoint(this.nextCell, this.tmpVector);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.enteringParameter = intersection.parameter;
        this.enteredFace = intersection.face ^ 1;
        return true;
    }

    public void setLine(Line line) {
        this.line = line;
        this.done = false;
        this.tmpVector.scaleAdd(line.start, line.direction, line.origin);
        if (this.bounds.contains((Tuple3d)this.tmpVector, true)) {
            this.nextCell = this.getCellFromPoint(this.tree.getRoot(), this.tmpVector);
            this.enteringParameter = Double.NEGATIVE_INFINITY;
            this.enteredFace = -1;
        } else {
            this.list.clear();
            BoundingBox.computeIntersections(this.bounds, this.min, this.max, line, false, this.list, -1, -1);
            if (this.list.size == 0) {
                this.done = true;
                return;
            }
            this.nextCell = this.getCellFromPoint(this.tree.getRoot(), this.list.elements[0].getPoint());
            this.enteringParameter = this.list.elements[0].parameter;
            this.enteredFace = this.list.elements[0].face;
        }
    }

    private Octree.Cell getCellFromPoint(Octree.Cell cell, Tuple3d tuple3d) {
        this.tmpVector.sub(tuple3d, this.min);
        int n = cell.position;
        int n2 = n >> 5 & 0x1FF;
        int n3 = n >> 14 & 0x1FF;
        int n4 = n >> 23 & 0x1FF;
        int n5 = (int)(this.tmpVector.x * this.coordToGrid.x);
        int n6 = (int)(this.tmpVector.y * this.coordToGrid.y);
        int n7 = (int)(this.tmpVector.z * this.coordToGrid.z);
        int n8 = n & 0xF;
        int n9 = (1 << n8) - 1;
        if (n5 > n2 + n9) {
            n5 = n2 + n9;
        } else if (n5 < n2) {
            n5 = n2;
        }
        if (n6 > n3 + n9) {
            n6 = n3 + n9;
        } else if (n6 < n3) {
            n6 = n3;
        }
        if (n7 > n4 + n9) {
            n7 = n4 + n9;
        } else if (n7 < n4) {
            n7 = n4;
        }
        n5 <<= 2;
        n6 <<= 1;
        while (cell.children != null) {
            int n10 = (n5 >> --n8 & 4) + (n6 >> n8 & 2) + (n7 >> n8 & 1);
            cell = cell.children[n10];
        }
        return cell;
    }

    public Octree.Cell next() {
        if (!this.hasNext()) {
            return null;
        }
        this.lastCell = this.nextCell;
        this.nextCell = null;
        return this.lastCell;
    }

    public double getEnteringParameter() {
        return this.enteringParameter;
    }
}

