/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Cube;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import de.grogra.vecmath.geom.VolumeBase;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class BoundingBox
extends VolumeBase {
    public Point3d min;
    public Point3d max;
    public static final int INTERSECTION = -1;
    public static final int NO_INTERSECTION = 0;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;

    public BoundingBox(Point3d point3d, Point3d point3d2) {
        this.min = point3d;
        this.max = point3d2;
    }

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        int n2 = intersection != null && intersection.volume == this ? intersection.face : -1;
        int n3 = intersection2 != null && intersection2.volume == this ? intersection2.face : -1;
        return BoundingBox.computeIntersections(this, this.min, this.max, line, n == 0, intersectionList, n2, n3);
    }

    public static boolean computeIntersections(Volume volume, Tuple3d tuple3d, Tuple3d tuple3d2, Line line, boolean bl, IntersectionList intersectionList, int n, int n2) {
        double d;
        if (n >= 0 && n2 >= 0) {
            return true;
        }
        double d2 = line.start;
        double d3 = line.end;
        int n3 = -1;
        int n4 = -1;
        if (line.direction.x > 0.0) {
            if (n == 1 || n2 == 0) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d2.x - line.origin.x) / line.direction.x) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 1;
            }
            if (n < 0 && (d = (tuple3d.x - line.origin.x) / line.direction.x) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 0;
            }
        } else if (line.direction.x < 0.0) {
            if (n == 0 || n2 == 1) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d.x - line.origin.x) / line.direction.x) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 0;
            }
            if (n < 0 && (d = (tuple3d2.x - line.origin.x) / line.direction.x) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 1;
            }
        } else if (line.origin.x > tuple3d2.x || line.origin.x < tuple3d.x) {
            return false;
        }
        if (line.direction.y > 0.0) {
            if (n == 3 || n2 == 2) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d2.y - line.origin.y) / line.direction.y) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 3;
            }
            if (n < 0 && (d = (tuple3d.y - line.origin.y) / line.direction.y) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 2;
            }
        } else if (line.direction.y < 0.0) {
            if (n == 2 || n2 == 3) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d.y - line.origin.y) / line.direction.y) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 2;
            }
            if (n < 0 && (d = (tuple3d2.y - line.origin.y) / line.direction.y) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 3;
            }
        } else if (line.origin.y > tuple3d2.y || line.origin.y < tuple3d.y) {
            return false;
        }
        if (line.direction.z > 0.0) {
            if (n == 5 || n2 == 4) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d2.z - line.origin.z) / line.direction.z) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 5;
            }
            if (n < 0 && (d = (tuple3d.z - line.origin.z) / line.direction.z) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 4;
            }
        } else if (line.direction.z < 0.0) {
            if (n == 4 || n2 == 5) {
                return false;
            }
            if (n2 < 0 && (d = (tuple3d.z - line.origin.z) / line.direction.z) < d3) {
                if (d < d2) {
                    return false;
                }
                d3 = d;
                n3 = 4;
            }
            if (n < 0 && (d = (tuple3d2.z - line.origin.z) / line.direction.z) > d2) {
                if (d > d3) {
                    return false;
                }
                d2 = d;
                n4 = 5;
            }
        } else if (line.origin.z > tuple3d2.z || line.origin.z < tuple3d.z) {
            return false;
        }
        if (n4 >= 0) {
            intersectionList.add(volume, line, d2, 1, n4);
        }
        if ((bl || n4 < 0) && n3 >= 0) {
            intersectionList.add(volume, line, d3, -1, n3);
        }
        return n4 < 0;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        if (bl) {
            return Math2.lessThan(this.min, tuple3d) && Math2.lessThan(tuple3d, this.max);
        }
        return Math2.lessThanOrEqual(this.min, tuple3d) && Math2.lessThanOrEqual(tuple3d, this.max);
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(this.min);
        tuple3d2.set(this.max);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        if (!Math2.lessThanOrEqual(boundingBox.min, this.max) || !Math2.lessThanOrEqual(this.min, boundingBox.max)) {
            return false;
        }
        return !Math2.lessThan(this.min, boundingBox.min) || !Math2.lessThan(boundingBox.max, this.max);
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        Cube.getNormal(intersection.face, vector3d);
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Point3d point3d = intersection.tmpPoint0;
        point3d.add(this.min, this.max);
        point3d.scaleAdd(-0.5, intersection.getPoint());
        point3d.x *= 2.0 / (this.max.x - this.min.x);
        point3d.y *= 2.0 / (this.max.y - this.min.y);
        point3d.z *= 2.0 / (this.max.z - this.min.z);
        Cube.getUV(intersection.face, point3d, vector2d);
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        Cube.getTangents(intersection.face, vector3d, vector3d2);
    }

    public int testParallelogram(Tuple3d tuple3d, Tuple3d tuple3d2, Tuple3d tuple3d3, Tuple3d tuple3d4, Matrix3d matrix3d, Vector3d vector3d, Vector3d vector3d2) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        if (this.contains(tuple3d, false) || this.contains(tuple3d2, false) || this.contains(tuple3d3, false) || this.contains(tuple3d4, false)) {
            return -1;
        }
        vector3d.sub(tuple3d2, tuple3d);
        vector3d2.sub(tuple3d4, tuple3d);
        matrix3d.setColumn(0, vector3d);
        matrix3d.setColumn(1, vector3d2);
        vector3d.cross(vector3d, vector3d2);
        matrix3d.setColumn(2, vector3d);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (n = 0; n <= 1; ++n) {
            d4 = ((n == 0 ? this.min.x : this.max.x) - tuple3d.x) * vector3d.x;
            for (int i = 0; i <= 1; ++i) {
                d3 = ((i == 0 ? this.min.y : this.max.y) - tuple3d.y) * vector3d.y;
                for (int j = 0; j <= 1; ++j) {
                    double d5 = d4 + d3 + ((j == 0 ? this.min.z : this.max.z) - tuple3d.z) * vector3d.z;
                    if (d5 > 0.0) {
                        bl = true;
                        n2 |= 1 << n + (i << 1) + (j << 2);
                        continue;
                    }
                    if (!(d5 < 0.0)) continue;
                    bl2 = true;
                }
            }
        }
        if (bl && !bl2) {
            return 1;
        }
        if (bl2 && !bl) {
            return 2;
        }
        for (n = 0; n < 4; ++n) {
            d4 = tuple3d2.x - tuple3d.x;
            double d6 = tuple3d2.y - tuple3d.y;
            double d7 = tuple3d2.z - tuple3d.z;
            for (int i = 0; i <= 1; ++i) {
                double d8;
                double d9;
                double d10;
                Point3d point3d = i == 0 ? this.min : this.max;
                double d11 = (point3d.x - tuple3d.x) / d4;
                if (0.0 <= d11 && d11 <= 1.0) {
                    double d12;
                    d10 = tuple3d.y + d11 * d6;
                    if (this.min.y <= d12 && d10 <= this.max.y) {
                        double d13;
                        d10 = tuple3d.z + d11 * d7;
                        if (this.min.z <= d13 && d10 <= this.max.z) {
                            return -1;
                        }
                    }
                }
                if (0.0 <= (d11 = (point3d.y - tuple3d.y) / d6) && d11 <= 1.0) {
                    double d14;
                    d10 = tuple3d.x + d11 * d4;
                    if (this.min.x <= d14 && d10 <= this.max.x) {
                        double d15;
                        d10 = tuple3d.z + d11 * d7;
                        if (this.min.z <= d15 && d10 <= this.max.z) {
                            return -1;
                        }
                    }
                }
                if (!(0.0 <= (d11 = (point3d.z - tuple3d.z) / d7)) || !(d11 <= 1.0)) continue;
                d10 = tuple3d.x + d11 * d4;
                if (!(this.min.x <= d9) || !(d10 <= this.max.x)) continue;
                d10 = tuple3d.y + d11 * d6;
                if (!(this.min.y <= d8) || !(d10 <= this.max.y)) continue;
                return -1;
            }
            Tuple3d tuple3d5 = tuple3d;
            tuple3d = tuple3d2;
            tuple3d2 = tuple3d3;
            tuple3d3 = tuple3d4;
            tuple3d4 = tuple3d5;
        }
        matrix3d.invert();
        double d16 = this.max.x - this.min.x;
        double d17 = this.max.y - this.min.y;
        d3 = this.max.z - this.min.z;
        if (((n2 >> 0 ^ n2 >> 7) & 1) != 0) {
            vector3d2.set(this.min.x, this.min.y, this.min.z);
            vector3d2.sub(tuple3d);
            double d18 = d16;
            double d19 = d17;
            d2 = d3;
            d = -vector3d.dot(vector3d2) / (d18 * vector3d.x + d19 * vector3d.y + d2 * vector3d.z);
            vector3d2.x += d * d18;
            vector3d2.y += d * d19;
            vector3d2.z += d * d2;
            matrix3d.transform(vector3d2);
            if (0.0 <= vector3d2.x && vector3d2.x <= 1.0 && 0.0 <= vector3d2.y && vector3d2.y <= 1.0) {
                return -1;
            }
        }
        if (((n2 >> 1 ^ n2 >> 6) & 1) != 0) {
            vector3d2.set(this.min.x + d16, this.min.y, this.min.z);
            vector3d2.sub(tuple3d);
            double d20 = -d16;
            double d21 = d17;
            d2 = d3;
            d = -vector3d.dot(vector3d2) / (d20 * vector3d.x + d21 * vector3d.y + d2 * vector3d.z);
            vector3d2.x += d * d20;
            vector3d2.y += d * d21;
            vector3d2.z += d * d2;
            matrix3d.transform(vector3d2);
            if (0.0 <= vector3d2.x && vector3d2.x <= 1.0 && 0.0 <= vector3d2.y && vector3d2.y <= 1.0) {
                return -1;
            }
        }
        if (((n2 >> 2 ^ n2 >> 5) & 1) != 0) {
            vector3d2.set(this.min.x, this.min.y + d17, this.min.z);
            vector3d2.sub(tuple3d);
            double d22 = d16;
            double d23 = -d17;
            d2 = d3;
            d = -vector3d.dot(vector3d2) / (d22 * vector3d.x + d23 * vector3d.y + d2 * vector3d.z);
            vector3d2.x += d * d22;
            vector3d2.y += d * d23;
            vector3d2.z += d * d2;
            matrix3d.transform(vector3d2);
            if (0.0 <= vector3d2.x && vector3d2.x <= 1.0 && 0.0 <= vector3d2.y && vector3d2.y <= 1.0) {
                return -1;
            }
        }
        if (((n2 >> 3 ^ n2 >> 4) & 1) != 0) {
            vector3d2.set(this.min.x + d16, this.min.y + d17, this.min.z);
            vector3d2.sub(tuple3d);
            double d24 = -d16;
            double d25 = -d17;
            d2 = d3;
            d = -vector3d.dot(vector3d2) / (d24 * vector3d.x + d25 * vector3d.y + d2 * vector3d.z);
            vector3d2.x += d * d24;
            vector3d2.y += d * d25;
            vector3d2.z += d * d2;
            matrix3d.transform(vector3d2);
            if (0.0 <= vector3d2.x && vector3d2.x <= 1.0 && 0.0 <= vector3d2.y && vector3d2.y <= 1.0) {
                return -1;
            }
        }
        return 0;
    }

    public boolean contains(Tuple3d tuple3d, int n) {
        switch (n) {
            case 0: {
                return this.min.y <= tuple3d.y && tuple3d.y <= this.max.y && this.min.z <= tuple3d.z && tuple3d.z <= this.max.z;
            }
            case 1: {
                return this.min.x <= tuple3d.x && tuple3d.x <= this.max.x && this.min.z <= tuple3d.z && tuple3d.z <= this.max.z;
            }
            case 2: {
                return this.min.x <= tuple3d.x && tuple3d.x <= this.max.x && this.min.y <= tuple3d.y && tuple3d.y <= this.max.y;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "BoundingBox[" + this.min + ',' + this.max + ']';
    }
}

