/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class BoundingBox3d {
    private Point3d min;
    private Point3d max;

    public BoundingBox3d() {
        this.empty();
    }

    public double volume() {
        return Math.max(0.0, this.max.x - this.min.x) * Math.max(0.0, this.max.y - this.min.y) * Math.max(0.0, this.max.z - this.min.z);
    }

    public double area() {
        double d = Math.max(0.0, this.max.x - this.min.x);
        double d2 = Math.max(0.0, this.max.y - this.min.y);
        double d3 = Math.max(0.0, this.max.z - this.min.z);
        return 2.0 * (d * d2 + d * d3 + d2 * d3);
    }

    public boolean isEmpty() {
        return this.volume() == 0.0;
    }

    public void empty() {
        this.max = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.min = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void extent(Tuple3d tuple3d) {
        this.max.max(tuple3d);
        this.min.min(tuple3d);
    }

    public void extent(BoundingBox3d boundingBox3d) {
        this.max.max(boundingBox3d.max);
        this.min.min(boundingBox3d.min);
    }

    public Tuple3d getMax() {
        return this.max;
    }

    public Tuple3d getMin() {
        return this.min;
    }

    public void getCenter(Tuple3d tuple3d) {
        tuple3d.interpolate((Tuple3d)this.min, (Tuple3d)this.max, 0.5);
    }

    public double getRadius() {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.max, this.min);
        return vector3d.length() / 2.0;
    }

    public BoundingBox3d clone() {
        BoundingBox3d boundingBox3d = new BoundingBox3d();
        boundingBox3d.min = (Point3d)this.min.clone();
        boundingBox3d.max = (Point3d)this.max.clone();
        return boundingBox3d;
    }
}

