/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import raskob.geometry.Point;
import raskob.geometry.PointCollection;
import raskob.geometry.PointComparatorEx;

public final class PointArrayList
extends PointCollection {
    public PointArrayList() {
        super(new ArrayList());
    }

    public final Point get(int i) {
        return (Point)((ArrayList)this.getData()).get(i);
    }

    public final boolean contains(Point p) {
        if (this.isEmpty()) {
            return false;
        }
        this.gotoFirst();
        while (this.hasNext()) {
            Point q = this.getNext();
            if (!q.equals(p)) continue;
            return true;
        }
        return false;
    }

    public final boolean isRadiusFree(Point p, double radius) {
        if (this.isEmpty()) {
            return true;
        }
        this.gotoFirst();
        while (this.hasNext()) {
            Point q = this.getNext();
            if (!(q.distance(p) < radius)) continue;
            return false;
        }
        return true;
    }

    public final Point[] toSortedArrayEx() {
        Object[] arr = this.getData().toArray();
        Point[] pointArr = new Point[this.size()];
        int i = 0;
        while (i < this.size()) {
            pointArr[i] = (Point)arr[i];
            ++i;
        }
        Arrays.sort(pointArr, new PointComparatorEx());
        return pointArr;
    }
}

