/*
 * Decompiled with CFR 0.152.
 */
package raskob.geometry;

public final class InsecSweepPoint {
    public static final int IN0IN1 = 3;
    public static final int IN0OUT1 = 1;
    public static final int OUT0IN1 = 2;
    public static final int OUT0OUT1 = 0;
    private final int edge;
    private final int polN;
    private int inOrOut;
    private boolean verticalLower;

    public InsecSweepPoint(int edge, int polN, int inOrOut) {
        this(edge, polN, inOrOut, true);
    }

    public InsecSweepPoint(int edge, int polN, int inOrOut, boolean verticalLower) {
        this.edge = edge;
        this.polN = polN;
        this.inOrOut = inOrOut;
        this.verticalLower = verticalLower;
    }

    public final int getEdge() {
        return this.edge;
    }

    public final int getPolN() {
        return this.polN;
    }

    public final boolean isVerticalLower() {
        return this.verticalLower;
    }

    public final void clearVerticalLower() {
        this.verticalLower = false;
    }

    public final int getInOrOut() {
        return this.inOrOut;
    }

    public final int invertInOrOut0() {
        switch (this.inOrOut) {
            case 3: {
                this.inOrOut = 2;
                break;
            }
            case 1: {
                this.inOrOut = 0;
                break;
            }
            case 2: {
                this.inOrOut = 3;
                break;
            }
            case 0: {
                this.inOrOut = 1;
            }
        }
        return this.inOrOut;
    }

    public final int invertInOrOut1() {
        switch (this.inOrOut) {
            case 3: {
                this.inOrOut = 1;
                break;
            }
            case 1: {
                this.inOrOut = 3;
                break;
            }
            case 2: {
                this.inOrOut = 0;
                break;
            }
            case 0: {
                this.inOrOut = 2;
            }
        }
        return this.inOrOut;
    }

    public final int invertInOrOut(int polN) {
        if (polN == 0) {
            return this.invertInOrOut0();
        }
        return this.invertInOrOut1();
    }

    public final String toString() {
        String str = new String();
        switch (this.inOrOut) {
            case 3: {
                str = new StringBuilder(String.valueOf(str)).append("0+1+").toString();
                break;
            }
            case 1: {
                str = new StringBuilder(String.valueOf(str)).append("0+1-").toString();
                break;
            }
            case 2: {
                str = new StringBuilder(String.valueOf(str)).append("0-1+").toString();
                break;
            }
            case 0: {
                str = new StringBuilder(String.valueOf(str)).append("0-1-").toString();
            }
        }
        str = new StringBuilder(String.valueOf(str)).append(": ").append(this.edge).append("/").append(this.polN).toString();
        str = this.verticalLower ? new StringBuilder(String.valueOf(str)).append(" (lower)").toString() : new StringBuilder(String.valueOf(str)).append(" (upper)").toString();
        return str;
    }
}

