/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.texgen;

import de.grogra.imp.objects.ImageAdapter;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import de.grogra.texgen.SyntheticTexture;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Random;

public class AutoregressiveTexture
extends SyntheticTexture {
    int width = 256;
    int height = 256;
    float[] image = new float[0];
    float a0 = -0.1f;
    float a1 = 0.5f;
    float a2 = -0.1f;
    float a3 = 0.5f;
    float noise = 0.3f;
    private BufferedImage img;
    private static final Random rnd = new Random();
    private transient int imageStamp = -1;
    public static final Type $TYPE = new Type(AutoregressiveTexture.class);
    public static final SCOType.Field width$FIELD = Type._addManagedField($TYPE, "width", 0x200000, de.grogra.reflect.Type.INT, null, 0);
    public static final SCOType.Field height$FIELD = Type._addManagedField($TYPE, "height", 0x200000, de.grogra.reflect.Type.INT, null, 1);
    public static final SCOType.Field a0$FIELD = Type._addManagedField($TYPE, "a0", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field a1$FIELD = Type._addManagedField($TYPE, "a1", 0x200000, de.grogra.reflect.Type.FLOAT, null, 3);
    public static final SCOType.Field a2$FIELD = Type._addManagedField($TYPE, "a2", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field a3$FIELD = Type._addManagedField($TYPE, "a3", 0x200000, de.grogra.reflect.Type.FLOAT, null, 5);
    public static final SCOType.Field noise$FIELD = Type._addManagedField($TYPE, "noise", 0x200000, de.grogra.reflect.Type.FLOAT, null, 6);

    private int ensureRange(int n, int n2, int n3) {
        int n4 = n3 - n2;
        while (n < n2) {
            n += n4;
        }
        while (n >= n3) {
            n -= n4;
        }
        return n;
    }

    protected float getPixel(int n, int n2) {
        n = this.ensureRange(n, 0, this.width);
        n2 = this.ensureRange(n2, 0, this.height);
        return this.image[n2 * this.width + n];
    }

    protected void setPixel(int n, int n2, float f) {
        n = this.ensureRange(n, 0, this.width);
        n2 = this.ensureRange(n2, 0, this.height);
        this.image[n2 * this.width + n] = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getBufferedImage() {
        int n = this.getStamp();
        AutoregressiveTexture autoregressiveTexture = this;
        synchronized (autoregressiveTexture) {
            if (n != this.imageStamp) {
                this.createImage();
                this.imageStamp = n;
            }
        }
        return this.img;
    }

    int randomRGB() {
        return rnd.nextInt();
    }

    public Dimension getPreferredIconSize(boolean bl) {
        return bl ? new Dimension(this.width * 32 / this.height, 32) : new Dimension(this.width, this.height);
    }

    protected void createImage() {
        if (this.image == null || this.image.length < this.width * this.height) {
            this.image = new float[this.width * this.height];
        }
        assert (this.image.length >= this.width * this.height);
        this.calculateImageData();
        this.img = new BufferedImage(this.width, this.height, 1);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n = (int)(this.getPixel(j, i) * 255.0f);
                n = Math.min(255, Math.max(0, n));
                this.img.setRGB(j, i, 65793 * n);
            }
        }
    }

    protected void calculateImageData() {
        int n;
        for (n = 0; n < this.width; ++n) {
            this.setPixel(n, this.height - 1, rnd.nextFloat());
        }
        for (n = 0; n < this.height; ++n) {
            this.setPixel(this.width - 1, n, rnd.nextFloat());
        }
        for (n = 0; n < this.height; ++n) {
            for (int i = 0; i < this.width; ++i) {
                float f = 0.0f;
                f += this.a0 * this.getPixel(i - 1, n - 1);
                f += this.a1 * this.getPixel(i, n - 1);
                f += this.a2 * this.getPixel(i + 1, n - 1);
                f += this.a3 * this.getPixel(i - 1, n);
                this.setPixel(i, n, f += this.noise * rnd.nextFloat());
            }
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public float getA0() {
        return this.a0;
    }

    public void setA0(float f) {
        this.a0 = f;
    }

    public float getA1() {
        return this.a1;
    }

    public void setA1(float f) {
        this.a1 = f;
    }

    public float getA2() {
        return this.a2;
    }

    public void setA2(float f) {
        this.a2 = f;
    }

    public float getA3() {
        return this.a3;
    }

    public void setA3(float f) {
        this.a3 = f;
    }

    public float getNoise() {
        return this.noise;
    }

    public void setNoise(float f) {
        this.noise = f;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ImageAdapter.Type {
        private static final int SUPER_FIELD_COUNT = 0;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(AutoregressiveTexture autoregressiveTexture, SCOType sCOType) {
            super((ImageAdapter)autoregressiveTexture, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)SyntheticTexture.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 0: {
                    ((AutoregressiveTexture)((Object)object)).width = n2;
                    return;
                }
                case 1: {
                    ((AutoregressiveTexture)((Object)object)).height = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 0: {
                    return ((AutoregressiveTexture)((Object)object)).getWidth();
                }
                case 1: {
                    return ((AutoregressiveTexture)((Object)object)).getHeight();
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((AutoregressiveTexture)((Object)object)).a0 = f;
                    return;
                }
                case 3: {
                    ((AutoregressiveTexture)((Object)object)).a1 = f;
                    return;
                }
                case 4: {
                    ((AutoregressiveTexture)((Object)object)).a2 = f;
                    return;
                }
                case 5: {
                    ((AutoregressiveTexture)((Object)object)).a3 = f;
                    return;
                }
                case 6: {
                    ((AutoregressiveTexture)((Object)object)).noise = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((AutoregressiveTexture)((Object)object)).getA0();
                }
                case 3: {
                    return ((AutoregressiveTexture)((Object)object)).getA1();
                }
                case 4: {
                    return ((AutoregressiveTexture)((Object)object)).getA2();
                }
                case 5: {
                    return ((AutoregressiveTexture)((Object)object)).getA3();
                }
                case 6: {
                    return ((AutoregressiveTexture)((Object)object)).getNoise();
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new AutoregressiveTexture();
        }
    }
}

