/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.query.CompiletimeModel;
import de.grogra.xl.query.RuntimeModel;
import de.grogra.xl.query.RuntimeModelFactory;
import de.grogra.xl.vmx.VMXState;

public class ModelExpression
extends Expression
implements Completable {
    private CompiletimeModel model;
    private String modelString;
    private RuntimeModel rtModel;
    Field modelField;

    public ModelExpression(Type type) {
        super(type);
    }

    public ModelExpression(CompiletimeModel compiletimeModel) {
        super((Type)ClassAdapter.wrap(RuntimeModel.class));
        this.setModel(compiletimeModel);
    }

    public boolean allowsIteration(int n) {
        return false;
    }

    protected void setModel(CompiletimeModel compiletimeModel) {
        this.model = compiletimeModel;
        this.modelString = compiletimeModel.getRuntimeName();
    }

    public void complete(MethodScope methodScope) {
        this.modelField = methodScope.getDeclaredType().getFieldForModel(this.model);
    }

    protected RuntimeModel getRuntimeModel() {
        RuntimeModel runtimeModel = this.rtModel;
        if (runtimeModel == null) {
            this.rtModel = runtimeModel = RuntimeModelFactory.getInstance().modelForName(this.modelString, this.getTypeLoader().getClassLoader());
        }
        return runtimeModel;
    }

    protected String paramString() {
        return super.paramString() + ",model=" + this.modelString;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        return this.getRuntimeModel();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        if (!bl) {
            bytecodeWriter.visitFieldInsn(178, this.modelField, null);
        }
    }
}

