/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.Utils;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.lang.DisposableIterator;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class FinishIteratorGenerator
extends Expression
implements Generator,
LocalAccess {
    private Expression iterator;
    private Expression value;
    private Expression statement;
    private Local iter;
    private VMXState.Local vmxIter;
    private static final Type ITERATOR_TYPE = ClassAdapter.wrap(DisposableIterator.class);
    private Label start;
    private Label handler;

    public FinishIteratorGenerator(Type type, Local local) {
        super(type);
        this.iter = local;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return false;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return '\u0000';
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0L;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0.0f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return 0.0;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        this.evaluateVoidImpl(vMXState);
        return null;
    }

    protected void evaluateVoidImpl(VMXState vMXState) {
        DisposableIterator disposableIterator = (DisposableIterator)this.iterator.evaluateObject(vMXState);
        vMXState.aset(this.vmxIter, (Object)disposableIterator, null);
        try {
            while (disposableIterator.next()) {
                if (this.value != null) {
                    this.value.push(vMXState);
                }
                this.statement.evaluateAsVoid(vMXState);
            }
        }
        catch (Throwable throwable) {
            disposableIterator.dispose(throwable);
            Utils.rethrow((Throwable)throwable);
        }
        disposableIterator.dispose(null);
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return 10;
    }

    public Local getLocal(int n) {
        return this.iter;
    }

    public void setLocal(int n, Local local) {
        this.iter = local;
    }

    public void complete(MethodScope methodScope) {
        this.vmxIter = this.iter.createVMXLocal();
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public void link(boolean bl) {
        this.iterator = this.getObjectExpression(0, ITERATOR_TYPE, bl);
        this.statement = this.iterator.getNextExpression();
        Expression expression = this.statement.getNextExpression();
        if (expression != null) {
            this.value = this.statement;
            this.statement = expression;
        }
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl);
        this.iterator.write(bytecodeWriter, false);
        bytecodeWriter.visitStore(this.vmxIter, ITERATOR_TYPE);
        Label label = new Label();
        bytecodeWriter.visitJumpInsn(167, label);
        this.handler = new Label();
        bytecodeWriter.visitLabel(this.handler);
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitInsn(95);
        bytecodeWriter.visitMethodInsn(DisposableIterator.class, "dispose");
        bytecodeWriter.visitInsn(191);
        this.start = new Label();
        bytecodeWriter.visitLabel(this.start);
        Label label2 = this.start;
        if (this.value != null) {
            this.value.write(bytecodeWriter, false);
        }
        this.statement.write(bytecodeWriter, true);
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitMethodInsn(DisposableIterator.class, "next");
        bytecodeWriter.visitJumpInsn(154, label2);
        Label label3 = new Label();
        bytecodeWriter.visitLabel(label3);
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitaconst(null);
        bytecodeWriter.visitMethodInsn(DisposableIterator.class, "dispose");
        bytecodeWriter.visitTryCatchBlock(this.start, label3, this.handler, null);
    }

    public void writeFinally(BytecodeWriter bytecodeWriter, int n, ControlTransfer controlTransfer) {
        Label label = new Label();
        bytecodeWriter.visitLabel(label);
        if (label.getOffset() != this.start.getOffset()) {
            bytecodeWriter.visitTryCatchBlock(this.start, label, this.handler, null);
        }
        bytecodeWriter.visitLoad(this.vmxIter, ITERATOR_TYPE);
        bytecodeWriter.visitaconst(null);
        bytecodeWriter.visitMethodInsn(DisposableIterator.class, "dispose");
        super.writeFinally(bytecodeWriter, n, controlTransfer);
        this.start = new Label();
        bytecodeWriter.visitLabel(this.start);
    }
}

