/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import antlr.collections.AST;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.Transaction;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.ClassLoaderAdapter;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeId;
import de.grogra.reflect.TypeLoader;
import de.grogra.util.I18NBundle;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.BooleanConst;
import de.grogra.xl.expr.ByteConst;
import de.grogra.xl.expr.Cast;
import de.grogra.xl.expr.CharConst;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.DoubleConst;
import de.grogra.xl.expr.ExpressionFactory;
import de.grogra.xl.expr.FloatConst;
import de.grogra.xl.expr.IllegalCastException;
import de.grogra.xl.expr.IllegalOperandTypeException;
import de.grogra.xl.expr.IntConst;
import de.grogra.xl.expr.InvokeVirtual;
import de.grogra.xl.expr.LocalValue;
import de.grogra.xl.expr.LongConst;
import de.grogra.xl.expr.ObjectConst;
import de.grogra.xl.expr.ShortConst;
import de.grogra.xl.expr.UndefinedInputException;
import de.grogra.xl.expr.ValidationException;
import de.grogra.xl.expr.ValueObserver;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public class Expression
extends Node
implements TypeId,
ValueObserver,
Cloneable,
ExpressionFactory {
    public static final I18NBundle I18N = I18NBundle.getInstance(Expression.class);
    public static final Expression[] EXPR_0 = new Expression[0];
    static final Type VMX_TYPE = ClassAdapter.wrap(VMXState.class);
    static final Type ABRUPT_COMPLETION_TYPE = ClassAdapter.wrap(AbruptCompletion.class);
    static final Type RETURN_TYPE = ClassAdapter.wrap(AbruptCompletion.Return.class);
    static final Type THROW_TYPE = ClassAdapter.wrap(AbruptCompletion.Throw.class);
    static final Type NONLOCAL_TYPE = ClassAdapter.wrap(AbruptCompletion.Nonlocal.class);
    public int etype = -1;
    private static final int LINKED = 2048;
    public static final int VALID = 4096;
    public static final int USED_BITS = 13;
    public long lval;
    public double dval;
    public Object aval;
    private Type exprType = null;
    public static final Node.NType $TYPE = new Node.NType((Node)new Expression());
    public static final Node.NType.Field lval$FIELD = new _Field("lval", 0x200001, Type.LONG, null, 0);
    public static final Node.NType.Field dval$FIELD;
    public static final Node.NType.Field aval$FIELD;
    public static final Node.NType.Field valid$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Expression();
    }

    public Expression() {
    }

    public Expression(Type type) {
        this();
        if (type != null) {
            this.setType(type);
        }
    }

    public Type getType() {
        return this.exprType;
    }

    public Expression createExpression(Scope scope, AST aST) {
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public boolean hasType(Type type) {
        return (type.getModifiers() & 0x200) != 0 ? Reflection.isSupertypeOrSame((Type)type, (Type)this.getType()) : Reflection.isSuperclassOrSame((Type)type, (Type)this.getType());
    }

    public boolean hasType(Class clazz) {
        return clazz.isInterface() ? Reflection.isSupertypeOrSame((Class)clazz, (Type)this.getType()) : Reflection.isSuperclassOrSame((Class)clazz, (Type)this.getType());
    }

    public boolean isPrimitiveOrStringConstant() {
        return this instanceof Constant && Reflection.isPrimitiveOrString((Type)this.getType());
    }

    public Expression setType(Type type) {
        this.checkSetType(type);
        this.etype = type.getTypeId();
        this.exprType = type;
        return this;
    }

    protected void checkSetType(Type type) {
        if (this.etype >= 0 && this.etype != type.getTypeId()) {
            throw new AssertionError();
        }
    }

    public boolean isRequired(int n) {
        return true;
    }

    public boolean discards(int n) {
        return !this.isRequired(n);
    }

    public boolean needsEmptyOperandStackForFinally() {
        return false;
    }

    public boolean allowsIteration(int n) {
        return true;
    }

    public TypeLoader getTypeLoader() {
        Node node = this.getAxisParent();
        return node instanceof Expression ? ((Expression)node).getTypeLoader() : new ClassLoaderAdapter(this.getClass().getClassLoader());
    }

    public void link(boolean bl) {
    }

    public final void linkGraph(boolean bl) {
        if ((this.bits & 0x800) != 0) {
            return;
        }
        this.link(bl);
        this.bits |= 0x800;
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.linkGraph(bl);
        }
    }

    public final void unlinkTree() {
        if ((this.bits & 0x800) == 0) {
            return;
        }
        this.bits &= 0xFFFFF7FF;
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.unlinkTree();
        }
    }

    public int getSupportedTypes(int n) {
        return 0;
    }

    protected void fireValueChanged(Transaction transaction) {
        Edge edge;
        int n = 0;
        Expression expression = this;
        Node node = null;
        block0: do {
            for (edge = expression.getFirstEdge(); edge != null; edge = edge.getNext((Node)expression)) {
                node = edge.getSource();
                if (node == expression) continue;
                int n2 = edge.getEdgeBits();
                if ((n2 & 0x100) != 0) {
                    ++n;
                    expression = node;
                    continue block0;
                }
                if ((n2 & 0x200) == 0) continue;
                if (node instanceof ValueObserver) {
                    ((ValueObserver)node).valueChanged(this, n, transaction);
                }
                return;
            }
        } while (edge != null);
    }

    public void valueChanged(Expression expression, int n, Transaction transaction) {
        boolean bl = true;
        try {
            switch (this.etype) {
                case 2: {
                    lval$FIELD.setLong((Object)this, null, this.evaluateBooleanImpl(VMXState.current()) ? 1L : 0L, transaction);
                    break;
                }
                case 3: {
                    lval$FIELD.setLong((Object)this, null, (long)this.evaluateByteImpl(VMXState.current()), transaction);
                    break;
                }
                case 4: {
                    lval$FIELD.setLong((Object)this, null, (long)this.evaluateShortImpl(VMXState.current()), transaction);
                    break;
                }
                case 5: {
                    lval$FIELD.setLong((Object)this, null, (long)this.evaluateCharImpl(VMXState.current()), transaction);
                    break;
                }
                case 6: {
                    lval$FIELD.setLong((Object)this, null, (long)this.evaluateIntImpl(VMXState.current()), transaction);
                    break;
                }
                case 7: {
                    lval$FIELD.setLong((Object)this, null, this.evaluateLongImpl(VMXState.current()), transaction);
                    break;
                }
                case 8: {
                    dval$FIELD.setDouble((Object)this, null, (double)this.evaluateFloatImpl(VMXState.current()), transaction);
                    break;
                }
                case 9: {
                    dval$FIELD.setDouble((Object)this, null, this.evaluateDoubleImpl(VMXState.current()), transaction);
                    break;
                }
                case 0: {
                    aval$FIELD.setObject((Object)this, null, this.evaluateObjectImpl(VMXState.current()), transaction);
                }
            }
        }
        catch (UndefinedInputException undefinedInputException) {
            bl = false;
        }
        if (bl != ((this.bits & 0x1000) != 0)) {
            valid$FIELD.setBoolean((Object)this, null, bl, transaction);
        }
        this.fireValueChanged(transaction);
    }

    public AbruptCompletion.Return evaluateRet(VMXState vMXState) {
        switch (this.etype) {
            case 2: {
                return vMXState.ireturn(this.evaluateBoolean(vMXState) ? 1 : 0);
            }
            case 3: {
                return vMXState.ireturn((int)this.evaluateByte(vMXState));
            }
            case 4: {
                return vMXState.ireturn((int)this.evaluateShort(vMXState));
            }
            case 5: {
                return vMXState.ireturn((int)this.evaluateChar(vMXState));
            }
            case 6: {
                return vMXState.ireturn(this.evaluateInt(vMXState));
            }
            case 7: {
                return vMXState.lreturn(this.evaluateLong(vMXState));
            }
            case 8: {
                return vMXState.freturn(this.evaluateFloat(vMXState));
            }
            case 9: {
                return vMXState.dreturn(this.evaluateDouble(vMXState));
            }
            case 0: {
                return vMXState.areturn(this.evaluateObject(vMXState));
            }
            case 1: {
                this.evaluateVoidImpl(vMXState);
                return vMXState.vreturn();
            }
        }
        throw new AssertionError();
    }

    public final void evaluateAsVoid(VMXState vMXState) {
        switch (this.etype) {
            case 2: {
                this.evaluateBoolean(vMXState);
                return;
            }
            case 3: {
                this.evaluateByte(vMXState);
                return;
            }
            case 4: {
                this.evaluateShort(vMXState);
                return;
            }
            case 5: {
                this.evaluateChar(vMXState);
                return;
            }
            case 6: {
                this.evaluateInt(vMXState);
                return;
            }
            case 7: {
                this.evaluateLong(vMXState);
                return;
            }
            case 8: {
                this.evaluateFloat(vMXState);
                return;
            }
            case 9: {
                this.evaluateDouble(vMXState);
                return;
            }
            case 0: {
                this.evaluateObject(vMXState);
                return;
            }
            case 1: {
                this.evaluateVoidImpl(vMXState);
                return;
            }
        }
        throw new AssertionError();
    }

    public final Object evaluateAsObject(VMXState vMXState) {
        switch (this.etype) {
            case 2: {
                return this.evaluateBoolean(vMXState) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.evaluateByte(vMXState);
            }
            case 4: {
                return this.evaluateShort(vMXState);
            }
            case 5: {
                return Character.valueOf(this.evaluateChar(vMXState));
            }
            case 6: {
                return this.evaluateInt(vMXState);
            }
            case 7: {
                return this.evaluateLong(vMXState);
            }
            case 8: {
                return Float.valueOf(this.evaluateFloat(vMXState));
            }
            case 9: {
                return this.evaluateDouble(vMXState);
            }
            case 0: {
                return this.evaluateObject(vMXState);
            }
            case 1: {
                this.evaluateVoidImpl(vMXState);
                return null;
            }
        }
        throw new AssertionError();
    }

    public final boolean evaluateBoolean() {
        this.linkGraph(false);
        return this.evaluateBoolean(VMXState.current());
    }

    public final boolean evaluateBoolean(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return this.lval != 0L;
        }
        return this.evaluateBooleanImpl(vMXState);
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final byte evaluateByte() {
        this.linkGraph(false);
        return this.evaluateByte(VMXState.current());
    }

    public final byte evaluateByte(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return (byte)this.lval;
        }
        switch (this.etype) {
            case 4: {
                return (byte)this.evaluateShortImpl(vMXState);
            }
            case 5: {
                return (byte)this.evaluateCharImpl(vMXState);
            }
            case 6: {
                return (byte)this.evaluateIntImpl(vMXState);
            }
            case 7: {
                return (byte)this.evaluateLongImpl(vMXState);
            }
            case 8: {
                return (byte)this.evaluateFloatImpl(vMXState);
            }
            case 9: {
                return (byte)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateByteImpl(vMXState);
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final short evaluateShort() {
        this.linkGraph(false);
        return this.evaluateShort(VMXState.current());
    }

    public final short evaluateShort(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return (short)this.lval;
        }
        switch (this.etype) {
            case 3: {
                return this.evaluateByteImpl(vMXState);
            }
            case 5: {
                return (short)this.evaluateCharImpl(vMXState);
            }
            case 6: {
                return (short)this.evaluateIntImpl(vMXState);
            }
            case 7: {
                return (short)this.evaluateLongImpl(vMXState);
            }
            case 8: {
                return (short)this.evaluateFloatImpl(vMXState);
            }
            case 9: {
                return (short)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateShortImpl(vMXState);
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final char evaluateChar() {
        this.linkGraph(false);
        return this.evaluateChar(VMXState.current());
    }

    public final char evaluateChar(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return (char)this.lval;
        }
        switch (this.etype) {
            case 3: {
                return (char)this.evaluateByteImpl(vMXState);
            }
            case 4: {
                return (char)this.evaluateShortImpl(vMXState);
            }
            case 6: {
                return (char)this.evaluateIntImpl(vMXState);
            }
            case 7: {
                return (char)this.evaluateLongImpl(vMXState);
            }
            case 8: {
                return (char)this.evaluateFloatImpl(vMXState);
            }
            case 9: {
                return (char)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateCharImpl(vMXState);
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final int evaluateInt() {
        this.linkGraph(false);
        return this.evaluateInt(VMXState.current());
    }

    public final int evaluateInt(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return (int)this.lval;
        }
        switch (this.etype) {
            case 3: {
                return this.evaluateByteImpl(vMXState);
            }
            case 4: {
                return this.evaluateShortImpl(vMXState);
            }
            case 5: {
                return this.evaluateCharImpl(vMXState);
            }
            case 7: {
                return (int)this.evaluateLongImpl(vMXState);
            }
            case 8: {
                return (int)this.evaluateFloatImpl(vMXState);
            }
            case 9: {
                return (int)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateIntImpl(vMXState);
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final long evaluateLong() {
        this.linkGraph(false);
        return this.evaluateLong(VMXState.current());
    }

    public final long evaluateLong(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return this.lval;
        }
        switch (this.etype) {
            case 3: {
                return this.evaluateByteImpl(vMXState);
            }
            case 4: {
                return this.evaluateShortImpl(vMXState);
            }
            case 5: {
                return this.evaluateCharImpl(vMXState);
            }
            case 6: {
                return this.evaluateIntImpl(vMXState);
            }
            case 8: {
                return (long)this.evaluateFloatImpl(vMXState);
            }
            case 9: {
                return (long)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateLongImpl(vMXState);
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final float evaluateFloat() {
        this.linkGraph(false);
        return this.evaluateFloat(VMXState.current());
    }

    public final float evaluateFloat(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return (float)this.dval;
        }
        switch (this.etype) {
            case 3: {
                return this.evaluateByteImpl(vMXState);
            }
            case 4: {
                return this.evaluateShortImpl(vMXState);
            }
            case 5: {
                return this.evaluateCharImpl(vMXState);
            }
            case 6: {
                return this.evaluateIntImpl(vMXState);
            }
            case 7: {
                return this.evaluateLongImpl(vMXState);
            }
            case 9: {
                return (float)this.evaluateDoubleImpl(vMXState);
            }
        }
        return this.evaluateFloatImpl(vMXState);
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final double evaluateDouble() {
        this.linkGraph(false);
        return this.evaluateDouble(VMXState.current());
    }

    public final double evaluateDouble(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return this.dval;
        }
        switch (this.etype) {
            case 3: {
                return this.evaluateByteImpl(vMXState);
            }
            case 4: {
                return this.evaluateShortImpl(vMXState);
            }
            case 5: {
                return this.evaluateCharImpl(vMXState);
            }
            case 6: {
                return this.evaluateIntImpl(vMXState);
            }
            case 7: {
                return this.evaluateLongImpl(vMXState);
            }
            case 8: {
                return this.evaluateFloatImpl(vMXState);
            }
        }
        return this.evaluateDoubleImpl(vMXState);
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public final Object evaluateObject() {
        this.linkGraph(false);
        return this.evaluateObject(VMXState.current());
    }

    public final Object evaluateObject(VMXState vMXState) {
        if ((this.bits & 0x1000) != 0) {
            return this.aval;
        }
        return this.etype == 0 || this.etype < 0 ? this.evaluateObjectImpl(vMXState) : this.evaluateAsObject(vMXState);
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    protected void evaluateVoidImpl(VMXState vMXState) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    public Expression toConst() {
        return this;
    }

    protected Expression toConstImpl() {
        this.linkGraph(true);
        Type type = this.getType();
        if (this.etype == 0 && !Reflection.equal((Type)type, (Type)Type.NULL) && !Reflection.equal((Type)type, (Type)Type.STRING)) {
            return this;
        }
        try {
            Expression expression = Expression.createConst(type, this.evaluateAsObject(null));
            Compiler.copyInfo(this, expression);
            return expression;
        }
        catch (RuntimeException runtimeException) {
            return this;
        }
    }

    public final void push(VMXState vMXState) {
        switch (this.etype) {
            case 2: {
                vMXState.ipush(this.evaluateBoolean(vMXState) ? 1 : 0);
                return;
            }
            case 3: {
                vMXState.ipush((int)this.evaluateByte(vMXState));
                return;
            }
            case 4: {
                vMXState.ipush((int)this.evaluateShort(vMXState));
                return;
            }
            case 5: {
                vMXState.ipush((int)this.evaluateChar(vMXState));
                return;
            }
            case 6: {
                vMXState.ipush(this.evaluateInt(vMXState));
                return;
            }
            case 7: {
                vMXState.lpush(this.evaluateLong(vMXState));
                return;
            }
            case 8: {
                vMXState.fpush(this.evaluateFloat(vMXState));
                return;
            }
            case 9: {
                vMXState.dpush(this.evaluateDouble(vMXState));
                return;
            }
            case 0: {
                vMXState.apush(this.evaluateObject(vMXState));
                return;
            }
            case 1: {
                this.evaluateVoidImpl(vMXState);
                return;
            }
        }
        throw new AssertionError();
    }

    public Expression add(Expression expression) {
        if (expression != null) {
            this.appendBranchNode(expression);
        }
        return this;
    }

    public Expression setNextSibling(Expression expression) {
        this.setSuccessor(expression);
        return this;
    }

    public Expression receiveChildren(Expression expression) {
        Node node = expression.getBranch();
        expression.setBranch(null);
        this.setBranch(node);
        return this;
    }

    public Expression substitute(Expression expression) {
        Node node = expression.getPredecessor();
        if (node == null) {
            node = expression.getAxisParent();
            node.setBranch((Node)this);
        } else {
            node.setSuccessor((Node)this);
        }
        node = expression.getSuccessor();
        if (node != null) {
            expression.setNextSibling(null);
            this.setSuccessor(node);
        }
        return this;
    }

    public Expression getFirstExpression() {
        return (Expression)this.getBranch();
    }

    public Expression getNextExpression() {
        return (Expression)this.getSuccessor();
    }

    public Expression getLastExpression() {
        Expression expression;
        for (Expression expression2 = expression = this.getFirstExpression(); expression2 != null; expression2 = expression2.getNextExpression()) {
            expression = expression2;
        }
        return expression;
    }

    public int getExpressionCount() {
        return this.getBranchLength();
    }

    public Expression getExpression(int n) {
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            if (n-- != 0) continue;
            return expression;
        }
        return null;
    }

    public Expression getLeastCommonAncestor(Expression expression) {
        for (Expression expression2 = this; expression2 != null; expression2 = (Expression)expression2.getAxisParent()) {
            for (Expression expression3 = expression; expression3 != null; expression3 = (Expression)expression3.getAxisParent()) {
                if (expression2 != expression3) continue;
                return expression2;
            }
        }
        return null;
    }

    public int getPromotedType(Expression expression, Expression expression2) {
        int n;
        Type type;
        int n2 = expression.etype;
        int n3 = expression2.etype;
        if (n2 == 0 && (type = Reflection.getUnwrappedType((Type)expression.getType())) != Type.INVALID) {
            n2 = type.getTypeId();
        }
        if (n3 == 0 && (type = Reflection.getUnwrappedType((Type)expression2.getType())) != Type.INVALID) {
            n3 = type.getTypeId();
        }
        if (((n = 1 << n2 | 1 << n3) & 2) != 0) {
            return -1;
        }
        if ((n & 4) != 0) {
            return n == 4 ? 2 : -1;
        }
        if ((n & 1) != 0) {
            return n == 1 ? 0 : -1;
        }
        if ((n & 0xFFFFFC07) != 0) {
            return -1;
        }
        if ((n & 0x200) != 0) {
            return 9;
        }
        if ((n & 0x100) != 0) {
            return 8;
        }
        if ((n & 0x80) != 0) {
            return 7;
        }
        return 6;
    }

    public Expression promote(Scope scope, int n) {
        if (this.etype == 0) {
            Type type = Reflection.getUnwrappedType((Type)this.getType());
            if (type != Type.INVALID) {
                Expression expression = this.unboxingConversion();
                return expression.promote(scope, n);
            }
        } else {
            int n2;
            for (int i = n2 = this.etype; i == 5 || Reflection.isWideningConversion((int)n2, (int)i); ++i) {
                if (i == 5 && n2 != 5 || (1 << i & n) == 0) continue;
                return this.implicitConversion(scope, Reflection.getType((int)i));
            }
        }
        throw new IllegalOperandTypeException(I18N.msg("expr.illegal-promotion", (Object)this.getType()));
    }

    public Expression compile(Scope scope, Expression expression) {
        throw new AssertionError();
    }

    public Expression compile(Scope scope, Expression expression, Expression expression2) {
        throw new AssertionError();
    }

    public Expression implicitConversion(Scope scope, Type type) {
        if (Reflection.equal((Type)this.getType(), (Type)type)) {
            return this;
        }
        Expression expression = scope.getCompiler().standardImplicitConversion(this, type, true, scope, null, null, false);
        if (expression == null) {
            throw new IllegalCastException(this.getType(), type);
        }
        return expression.toConst();
    }

    public Expression unboxingConversion() {
        Type type = Reflection.getUnwrappedType((Type)this.getType());
        if (type != Type.INVALID) {
            return new InvokeVirtual(Reflection.getDeclaredMethod((Type)this.getType(), (String)(type.getBinaryName() + "Value"))).add(this);
        }
        return this;
    }

    public Expression cast(Type type) {
        return Reflection.equal((Type)type, (Type)this.getType()) ? this : new Cast(type).add(this).toConst();
    }

    public final void checkExpressionCount(int n) {
        if (n != this.getExpressionCount()) {
            throw new ValidationException(I18N.msg("expr.wrong-expr-count", (Object)this.getClass().getName(), (Object)n, (Object)this.getExpressionCount()));
        }
    }

    public final Expression getExpression(int n, int n2, boolean bl) {
        Expression expression = this.getExpression(n);
        if (bl && expression.etype != n2) {
            throw new ValidationException(I18N.msg("expr.wrong-expr-type", (Object)this.getClass().getName(), (Object)n, (Object)Reflection.getTypeName((int)n2), (Object)expression.getType().getName()));
        }
        return expression;
    }

    public final Expression getExpression(int n, Class clazz) {
        Expression expression = this.getExpression(n);
        if (!clazz.isInstance(expression)) {
            throw new ValidationException(I18N.msg("expr.wrong-expr-class", (Object)this.getClass().getName(), (Object)n, (Object)clazz.getName(), (Object)expression.getClass().getName()));
        }
        return expression;
    }

    public final Expression getObjectExpression(int n, Class clazz, boolean bl) {
        return this.getObjectExpression(n, (Type)ClassAdapter.wrap((Class)clazz), bl);
    }

    public final Expression getObjectExpression(int n, Type type, boolean bl) {
        Expression expression = this.getExpression(n, 0, bl);
        if (bl && !Reflection.isAssignableFrom((Type)type, (Type)expression.getType())) {
            throw new ValidationException(I18N.msg("expr.wrong-expr-type", (Object)this.getClass().getName(), (Object)n, (Object)type.getName(), (Object)expression.getType().getName()));
        }
        return expression;
    }

    public static final Expression createConst(Type type, Object object) {
        switch (type.getTypeId()) {
            case 2: {
                return new BooleanConst(object == null ? false : (Boolean)object);
            }
            case 3: {
                return new ByteConst(object == null ? (byte)0 : ((Number)object).byteValue());
            }
            case 4: {
                return new ShortConst(object == null ? (short)0 : ((Number)object).shortValue());
            }
            case 5: {
                return new CharConst(object == null ? (char)'\u0000' : ((Character)object).charValue());
            }
            case 6: {
                return new IntConst(object == null ? 0 : ((Number)object).intValue());
            }
            case 7: {
                return new LongConst(object == null ? 0L : ((Number)object).longValue());
            }
            case 8: {
                return new FloatConst(object == null ? 0.0f : ((Number)object).floatValue());
            }
            case 9: {
                return new DoubleConst(object == null ? 0.0 : ((Number)object).doubleValue());
            }
            case 0: {
                return new ObjectConst(object, type);
            }
        }
        throw new AssertionError();
    }

    public static final Expression createMinConst(int n) {
        switch (n) {
            case 3: {
                return new ByteConst(-128);
            }
            case 4: {
                return new ShortConst(Short.MIN_VALUE);
            }
            case 5: {
                return new CharConst('\u0000');
            }
            case 6: {
                return new IntConst(Integer.MIN_VALUE);
            }
            case 7: {
                return new LongConst(Long.MIN_VALUE);
            }
            case 8: {
                return new FloatConst(Float.NEGATIVE_INFINITY);
            }
            case 9: {
                return new DoubleConst(Double.NEGATIVE_INFINITY);
            }
        }
        throw new AssertionError(n);
    }

    public static final Expression createMaxConst(int n) {
        switch (n) {
            case 3: {
                return new ByteConst(127);
            }
            case 4: {
                return new ShortConst(Short.MAX_VALUE);
            }
            case 5: {
                return new CharConst('\uffff');
            }
            case 6: {
                return new IntConst(Integer.MAX_VALUE);
            }
            case 7: {
                return new LongConst(Long.MAX_VALUE);
            }
            case 8: {
                return new FloatConst(Float.POSITIVE_INFINITY);
            }
            case 9: {
                return new DoubleConst(Double.POSITIVE_INFINITY);
            }
        }
        throw new AssertionError(n);
    }

    public boolean evaluatesWithoutSideeffect() {
        return this instanceof LocalValue || this instanceof Constant;
    }

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + '[' + this.paramString() + "]@" + Integer.toHexString(this.hashCode());
    }

    protected String paramString() {
        return this.getType() != null ? this.getType().getBinaryName() : "";
    }

    static String getDescriptorNoBS(int n) {
        return n == 3 || n == 4 ? "I" : Reflection.getType((int)n).getDescriptor();
    }

    public static int opcode(int n, int[] nArray) {
        int n2;
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 0;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        n2 = nArray[n2];
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return n2;
    }

    public int opcode(int[] nArray) {
        return Expression.opcode(this.etype, nArray);
    }

    public void writeChildren(BytecodeWriter bytecodeWriter) {
        int n = 0;
        for (Expression expression = this.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            expression.write(bytecodeWriter, this.discards(n++));
        }
    }

    public final void write(BytecodeWriter bytecodeWriter, boolean bl) {
        AST aST = Compiler.getAST(this);
        if (aST != null) {
            bytecodeWriter.visitLineNumber(aST.getLine());
        }
        this.writeImpl(bytecodeWriter, bl);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        this.writeChildren(bytecodeWriter);
        this.writeOperator(bytecodeWriter);
        if (bl) {
            bytecodeWriter.visitPop(this.etype);
        }
    }

    public boolean isConditional() {
        return false;
    }

    public int writeConditional(BytecodeWriter bytecodeWriter, Label label, Label label2) {
        assert (this.etype == 2);
        this.write(bytecodeWriter, false);
        if (label2 == null) {
            if (label != null) {
                bytecodeWriter.visitJumpInsn(153, label);
            } else {
                bytecodeWriter.visitInsn(87);
            }
        } else {
            bytecodeWriter.visitJumpInsn(154, label2);
            if (label != null) {
                bytecodeWriter.visitJumpInsn(167, label);
            }
        }
        return 0;
    }

    protected void writeConditional(BytecodeWriter bytecodeWriter, boolean bl) {
        if (bl) {
            this.writeConditional(bytecodeWriter, null, null);
        } else {
            Label label = new Label();
            Label label2 = new Label();
            int n = this.writeConditional(bytecodeWriter, label, null);
            if (n != 0) {
                bytecodeWriter.visitLabel(label);
                bytecodeWriter.visiticonst(n > 0 ? 1 : 0);
            } else {
                bytecodeWriter.visiticonst(1);
                bytecodeWriter.visitJumpInsn(167, label2);
                bytecodeWriter.visitLabel(label);
                bytecodeWriter.visiticonst(0);
                bytecodeWriter.visitLabel(label2);
            }
        }
    }

    public void writeFinally(BytecodeWriter bytecodeWriter, int n, ControlTransfer controlTransfer) {
        ((Expression)this.getAxisParent()).writeFinally(bytecodeWriter, n, controlTransfer);
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        throw new AssertionError((Object)("Method not implemented in " + this.getClass()));
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)lval$FIELD);
        dval$FIELD = new _Field("dval", 0x200001, Type.DOUBLE, null, 1);
        $TYPE.addManagedField((ManageableType.Field)dval$FIELD);
        aval$FIELD = new _Field("aval", 0x200001, (Type)ClassAdapter.wrap(Object.class), null, 2);
        $TYPE.addManagedField((ManageableType.Field)aval$FIELD);
        valid$FIELD = new Node.NType.BitField($TYPE, "valid", 0x200001, Type.BOOLEAN, 4096);
        $TYPE.addManagedField((ManageableType.Field)valid$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setLong(Object object, long l) {
            switch (this.id) {
                case 0: {
                    ((Expression)object).lval = l;
                    return;
                }
            }
            super.setLong(object, l);
        }

        public long getLong(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Expression)object).lval;
                }
            }
            return super.getLong(object);
        }

        public void setDouble(Object object, double d) {
            switch (this.id) {
                case 1: {
                    ((Expression)object).dval = d;
                    return;
                }
            }
            super.setDouble(object, d);
        }

        public double getDouble(Object object) {
            switch (this.id) {
                case 1: {
                    return ((Expression)object).dval;
                }
            }
            return super.getDouble(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 2: {
                    ((Expression)object).aval = object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 2: {
                    return ((Expression)object).aval;
                }
            }
            return super.getObject(object);
        }
    }
}

