/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.AssignArrayComponent;
import de.grogra.xl.expr.Assignment;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class AssignArrayGenerator
extends Assignment
implements Generator,
LocalAccess {
    Expression container;
    Expression expr;
    Expression statement;
    private Local array;
    private Local counter;
    private VMXState.Local vmxArray;
    private VMXState.Local vmxCounter;

    public AssignArrayGenerator(Type type, Local local, Local local2, int n) {
        super(type, n);
        this.array = local;
        this.counter = local2;
    }

    public int getLocalCount() {
        return 2;
    }

    public int getAccessType(int n) {
        return 10;
    }

    public Local getLocal(int n) {
        return n == 0 ? this.array : this.counter;
    }

    public void setLocal(int n, Local local) {
        if (n == 0) {
            this.array = local;
        } else {
            this.counter = local;
        }
    }

    public void complete(MethodScope methodScope) {
        this.vmxArray = this.array.createVMXLocal();
        this.vmxCounter = this.counter.createVMXLocal();
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean[] blArray = (boolean[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl;
            switch (this.assignmentType) {
                case 0: {
                    blArray[i] = bl = this.expr.evaluateBoolean(vMXState);
                    break;
                }
                case 1: {
                    vMXState.ipush(blArray[i] ? 1 : 0);
                    blArray[i] = bl = this.expr.evaluateBoolean(vMXState);
                    break;
                }
                case 2: {
                    bl = blArray[i];
                    vMXState.ipush(bl ? 1 : 0);
                    blArray[i] = this.expr.evaluateBoolean(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.ipush(bl ? 1 : 0);
            this.statement.evaluateAsVoid(vMXState);
        }
        return false;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte[] byArray = (byte[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < byArray.length; ++i) {
            byte by;
            switch (this.assignmentType) {
                case 0: {
                    byArray[i] = by = this.expr.evaluateByte(vMXState);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)byArray[i]);
                    byArray[i] = by = this.expr.evaluateByte(vMXState);
                    break;
                }
                case 2: {
                    by = byArray[i];
                    vMXState.ipush((int)by);
                    byArray[i] = this.expr.evaluateByte(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.ipush((int)by);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short[] sArray = (short[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < sArray.length; ++i) {
            short s;
            switch (this.assignmentType) {
                case 0: {
                    sArray[i] = s = this.expr.evaluateShort(vMXState);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)sArray[i]);
                    sArray[i] = s = this.expr.evaluateShort(vMXState);
                    break;
                }
                case 2: {
                    s = sArray[i];
                    vMXState.ipush((int)s);
                    sArray[i] = this.expr.evaluateShort(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.ipush((int)s);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char[] cArray = (char[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            switch (this.assignmentType) {
                case 0: {
                    cArray[i] = c = this.expr.evaluateChar(vMXState);
                    break;
                }
                case 1: {
                    vMXState.ipush((int)cArray[i]);
                    cArray[i] = c = this.expr.evaluateChar(vMXState);
                    break;
                }
                case 2: {
                    c = cArray[i];
                    vMXState.ipush((int)c);
                    cArray[i] = this.expr.evaluateChar(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.ipush((int)c);
            this.statement.evaluateAsVoid(vMXState);
        }
        return '\u0000';
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int[] nArray = (int[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            switch (this.assignmentType) {
                case 0: {
                    nArray[i] = n = this.expr.evaluateInt(vMXState);
                    break;
                }
                case 1: {
                    vMXState.ipush(nArray[i]);
                    nArray[i] = n = this.expr.evaluateInt(vMXState);
                    break;
                }
                case 2: {
                    n = nArray[i];
                    vMXState.ipush(n);
                    nArray[i] = this.expr.evaluateInt(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.ipush(n);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long[] lArray = (long[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < lArray.length; ++i) {
            long l;
            switch (this.assignmentType) {
                case 0: {
                    lArray[i] = l = this.expr.evaluateLong(vMXState);
                    break;
                }
                case 1: {
                    vMXState.lpush(lArray[i]);
                    lArray[i] = l = this.expr.evaluateLong(vMXState);
                    break;
                }
                case 2: {
                    l = lArray[i];
                    vMXState.lpush(l);
                    lArray[i] = this.expr.evaluateLong(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.lpush(l);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0L;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float[] fArray = (float[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < fArray.length; ++i) {
            float f;
            switch (this.assignmentType) {
                case 0: {
                    fArray[i] = f = this.expr.evaluateFloat(vMXState);
                    break;
                }
                case 1: {
                    vMXState.fpush(fArray[i]);
                    fArray[i] = f = this.expr.evaluateFloat(vMXState);
                    break;
                }
                case 2: {
                    f = fArray[i];
                    vMXState.fpush(f);
                    fArray[i] = this.expr.evaluateFloat(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.fpush(f);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double[] dArray = (double[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            switch (this.assignmentType) {
                case 0: {
                    dArray[i] = d = this.expr.evaluateDouble(vMXState);
                    break;
                }
                case 1: {
                    vMXState.dpush(dArray[i]);
                    dArray[i] = d = this.expr.evaluateDouble(vMXState);
                    break;
                }
                case 2: {
                    d = dArray[i];
                    vMXState.dpush(d);
                    dArray[i] = this.expr.evaluateDouble(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.dpush(d);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object[] objectArray = (Object[])this.container.evaluateObject(vMXState);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            switch (this.assignmentType) {
                case 0: {
                    objectArray[i] = object = this.expr.evaluateObject(vMXState);
                    break;
                }
                case 1: {
                    vMXState.apush(objectArray[i]);
                    objectArray[i] = object = this.expr.evaluateObject(vMXState);
                    break;
                }
                case 2: {
                    object = objectArray[i];
                    vMXState.apush(object);
                    objectArray[i] = this.expr.evaluateObject(vMXState);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            vMXState.apush(object);
            this.statement.evaluateAsVoid(vMXState);
        }
        return null;
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.container = this.getExpression(0, 0, bl);
        this.expr = this.getExpression(1, this.etype, bl);
        this.statement = this.expr.getNextExpression();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl && this.vmxCounter.isJavaLocal());
        this.container.write(bytecodeWriter, false);
        bytecodeWriter.visitStore(this.vmxArray, this.container.getType());
        bytecodeWriter.visiticonst(0);
        bytecodeWriter.visitStore(this.vmxCounter, Type.INT);
        Label label = new Label();
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitLoad(this.vmxArray, this.container.getType());
        bytecodeWriter.visitLoad(this.vmxCounter, Type.INT);
        bytecodeWriter.visitIincInsn(this.vmxCounter.getIndex(), 1);
        AssignArrayComponent.write(this.etype, this.assignmentType, this.expr, bytecodeWriter, false);
        this.statement.write(bytecodeWriter, true);
        bytecodeWriter.visitLabel(label2);
        bytecodeWriter.visitLoad(this.vmxCounter, Type.INT);
        bytecodeWriter.visitLoad(this.vmxArray, this.container.getType());
        bytecodeWriter.visitInsn(190);
        bytecodeWriter.visitJumpInsn(161, label);
    }
}

