/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Utils;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.scope.BlockScope;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.AssignLocal;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Break;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.EnterFrame;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Finally;
import de.grogra.xl.expr.GetLocal;
import de.grogra.xl.expr.InvokeStatic;
import de.grogra.xl.expr.LeaveFrame;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.expr.NonlocalGenerator;
import de.grogra.xl.expr.Return;
import de.grogra.xl.expr.TryFinally;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.VMXState;
import java.util.HashMap;

public class MethodScope
extends BlockScope {
    public Local consumer;
    public Local enclosingInstance;
    public AST ast;
    private final ObjectList allLocals = new ObjectList(10, false);
    private final ObjectList exceptionTypes = new ObjectList(5, false);
    private XMethod method;
    private int jsize = 0;
    private int xsize = 0;
    private final long modifiers;
    private final ObjectList labelStack = new ObjectList(10);
    private final IntList labelIdStack = new IntList(10);
    private static final int CONTINUE_LABEL = 1;
    private static final int USED = 2;
    private final IntList labelFlags = new IntList(10);
    private final IntHashMap labelToTarget = new IntHashMap(10);
    private int nextLabelId = 1;
    private ObjectList paramsForLocals;
    private Local result;
    private Local localForVMX;
    private int uniqueInt = 0;
    private int nesting;
    private HashMap<Local, Local> nestedLocals;

    MethodScope(TypeScope typeScope, long l) {
        super(typeScope);
        this.modifiers = l;
        if ((l & 8L) == 0L) {
            this.declareParameter("this", 0x1000000010L, (Type)typeScope.getDeclaredType());
        }
        if ((l & 0x800000000L) != 0L && !typeScope.isStatic()) {
            this.enclosingInstance = this.declareParameter("this$0", 16L, typeScope.getDeclaredType().getDeclaringType());
        }
    }

    public MethodScope(MethodScope methodScope) {
        super(methodScope);
        this.modifiers = 17179873304L;
        this.declareLocalForVMX();
        methodScope.createVMXFrame();
    }

    public Member getDeclaredEntity() {
        return this.method;
    }

    public void createVMXFrame() {
        if (this.localForVMX != null) {
            return;
        }
        this.declareLocalForVMX();
        Block block = new Block();
        Compiler.setBlockScope(block, this);
        block.add(new EnterFrame(this.localForVMX));
        TryFinally tryFinally = new TryFinally();
        tryFinally.setBranch(this.method.getBranch());
        tryFinally.add(new Finally(null, null).add(new LeaveFrame(this.localForVMX)));
        block.add(tryFinally);
        this.method.setBranch(block);
    }

    public void createLocalForVMX() {
        if (this.localForVMX == null) {
            this.declareLocalForVMX();
            InvokeStatic invokeStatic = new InvokeStatic(Reflection.findMethodInClasses((Type)this.localForVMX.getType(), (String)"current"));
            invokeStatic.complete(this);
            AssignLocal assignLocal = this.localForVMX.createSet();
            assignLocal.complete(this);
            this.getBlock().insertBranchNode(0, assignLocal.add(invokeStatic));
        }
    }

    public Local getLocalForVMX() {
        return this.localForVMX;
    }

    private void declareLocalForVMX() {
        this.localForVMX = this.declareLocal("vmx.", 16L, (Type)ClassAdapter.wrap(VMXState.class), null);
        this.allocateFixed(this.localForVMX);
    }

    public XMethod createAndDeclareMethod(String string, Type type) {
        if (this.method != null) {
            throw new IllegalStateException("method != null");
        }
        if ((this.modifiers & 0x800001000L) == 4096L) {
            string = string.replace('<', '$').replace('>', '$');
            string = Reflection.getSyntheticName((Member[])Reflection.getDeclaredMethods((Type)this.getDeclaredType()), (String)string);
        }
        if (!((this.modifiers & 0x800000000L) == 0L || "<init>".equals(string) && type.getTypeId() == 1)) {
            throw new IllegalArgumentException(string + " " + type);
        }
        this.method = new XMethod(string, this.modifiers, this, type, (Type[])this.exceptionTypes.toArray((Object[])new Type[this.exceptionTypes.size]));
        Compiler.setBlockScope(this.method, this);
        this.method.add(this.getBlock());
        return this.method;
    }

    final int nextUniqueInt() {
        return this.getOutmost().uniqueInt++;
    }

    public Expression setBlock(Expression expression) {
        if (this.method == null && this.getBlock() == null) {
            return super.setBlock(expression);
        }
        throw new AssertionError();
    }

    public XMethod getMethod() {
        return this.method;
    }

    public boolean isStatic() {
        return (this.modifiers & 8L) != 0L;
    }

    public boolean isInitializer() {
        return (this.modifiers & 0x2000000000L) != 0L;
    }

    public boolean isConstructor() {
        return (this.modifiers & 0x800000000L) != 0L;
    }

    public boolean isIllegalUseBeforeDeclaration(Field field) {
        AST aST;
        TypeScope typeScope = TypeScope.get(this);
        if ((this.modifiers & 0x2000000000L) == 0L || Reflection.isStatic((Member)field) != this.isStatic() || typeScope.getDeclaredType() != field.getDeclaringType()) {
            return false;
        }
        AST aST2 = typeScope.getASTOfDeclaration(field);
        if (aST2 == null) {
            if ((field.getModifiers() & 0x1000) != 0) {
                return false;
            }
            throw new AssertionError();
        }
        for (aST = this.ast; aST != null; aST = aST.getNextSibling()) {
            if (aST != aST2) continue;
            return true;
        }
        for (aST = aST2; aST != null; aST = aST.getNextSibling()) {
            if (aST != this.ast) continue;
            return false;
        }
        throw new AssertionError();
    }

    public boolean isLocal() {
        return false;
    }

    public static MethodScope get(Expression expression) {
        while (!(expression instanceof XMethod)) {
            expression = (Expression)expression.getAxisParent();
        }
        return (MethodScope)Compiler.getBlockScope(expression);
    }

    public static MethodScope get(Scope scope) {
        while (!(scope instanceof MethodScope)) {
            if (scope == null) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        return (MethodScope)scope;
    }

    public MethodScope getOutmost() {
        MethodScope methodScope = this;
        MethodScope methodScope2;
        while ((methodScope2 = MethodScope.get(methodScope.getEnclosingScope())) != null) {
            methodScope = methodScope2;
        }
        return methodScope;
    }

    public void declareException(Type type) {
        this.exceptionTypes.add((Object)type);
    }

    public Local declareParameter(String string, long l, Class clazz) {
        return this.declareParameter(string, l, (Type)ClassAdapter.wrap((Class)clazz));
    }

    public Local declareParameter(String string, long l, Type type) {
        Local local = this.declareLocal(string, l | 0x200000000L, type, null);
        if ((this.modifiers & 0x400000000L) != 0L) {
            local.nesting = 0;
        }
        this.allocateFixed(local);
        return local;
    }

    public Local getParameterForEnclosingLocal(Local local) {
        if (!this.isConstructor()) {
            return null;
        }
        ObjectList<Local> objectList = TypeScope.get(this).getEnclosingLocals();
        int n = objectList.indexOf((Object)local);
        if (n < 0) {
            return null;
        }
        if (this.paramsForLocals == null) {
            this.paramsForLocals = new ObjectList();
        }
        for (int i = this.paramsForLocals.size(); i <= n; ++i) {
            Local local2 = (Local)objectList.get(i);
            Local local3 = this.declareParameter("arg$" + local2.getName() + '.', 0L, local2.getType());
            this.paramsForLocals.add((Object)local3);
        }
        return (Local)this.paramsForLocals.get(n);
    }

    void declareResultLocal() {
        if (this.result == null) {
            this.result = this.declareLocal("result.", 0L, this.method.getReturnType(), null);
        }
    }

    public VMXState.Local getResultLocal() {
        return this.result != null ? this.result.createVMXLocal() : null;
    }

    public boolean enterLabel(String string) {
        boolean bl = this.getTargetId(string, false) >= 0;
        this.labelStack.push((Object)string);
        this.labelFlags.push(0);
        this.labelIdStack.push(this.nextLabelId++);
        return bl;
    }

    public void enterBreakTarget(String string) {
        int n;
        this.labelStack.push(null);
        this.labelFlags.push(0);
        if (string != null) {
            n = this.labelIdStack.peek(1);
        } else {
            int n2 = this.nextLabelId;
            n = n2;
            this.nextLabelId = n2 + 1;
        }
        this.labelIdStack.push(n);
    }

    public void enterContinueTarget(String string) {
        this.labelStack.push((Object)string);
        this.labelFlags.push(1);
        this.labelIdStack.push(this.nextLabelId++);
    }

    public void leave(BreakTarget breakTarget) {
        int n = this.labelIdStack.pop();
        if ((this.labelFlags.pop() & 2) != 0) {
            breakTarget.initialize(n);
            this.labelToTarget.put(n, (Object)breakTarget);
        }
        this.labelStack.pop();
    }

    public int getTargetId(String string, boolean bl) {
        for (int i = this.labelStack.size() - 1; i >= 0; --i) {
            Object object = this.labelStack.get(i);
            int n = this.labelFlags.get(i);
            if (bl) {
                if ((n & 1) != 0) {
                    if (string != null && !string.equals(object)) continue;
                    this.labelFlags.set(i, n | 2);
                    return this.labelIdStack.get(i);
                }
                if (string == null || !string.equals(object)) continue;
                return -2;
            }
            if ((n & 1) != 0 || !Utils.equal((Object)string, (Object)object)) continue;
            this.labelFlags.set(i, n | 2);
            return this.labelIdStack.get(i);
        }
        return -1;
    }

    public BreakTarget getTargetFor(Break break_) {
        return (BreakTarget)this.labelToTarget.get(break_.getLabel(), null);
    }

    public Expression createThis() {
        assert ((this.modifiers & 8L) == 0L);
        GetLocal getLocal = this.findLocal("this", false).createGet();
        getLocal.lval |= 3L;
        return getLocal;
    }

    public final Local makeVMXLocal(Local local) {
        assert (local.isJavaLocal());
        this.receiveLocal(local);
        Local local2 = null;
        if (local.isParameter()) {
            if (Reflection.isFinal((Member)local)) {
                local2 = local;
                local = this.declareLocal(local.getName() + '.', 16L, local.getType(), local.getAST());
            } else {
                local2 = this.declareLocal(local.getName() + '.', 0x200000010L, local.getType(), local.getAST());
                local2.index = local.index;
                local.unsetParameter();
            }
        } else if (local.index >= 0) {
            throw new AssertionError(local);
        }
        local.nesting = 0;
        if (local2 != null) {
            this.getBlock().insertBranchNode(0, local.createSet().add(local2.createGet()));
        }
        return local;
    }

    public Type[] getParameterTypes() {
        ObjectList objectList = new ObjectList();
        for (int i = 0; i < this.allLocals.size; ++i) {
            Local local = (Local)this.allLocals.get(i);
            if (!local.isParameter() || (local.getModifiersEx() & 0x1000000000L) != 0L) continue;
            objectList.add((Object)local.getType());
        }
        if (objectList.size == 0) {
            return Type.TYPE_0;
        }
        Object[] objectArray = new Type[objectList.size];
        objectList.toArray(objectArray);
        return objectArray;
    }

    public Local getParameter(int n) {
        for (int i = 0; i < this.allLocals.size; ++i) {
            Local local = (Local)this.allLocals.get(i);
            if (!local.isParameter() || (local.getModifiersEx() & 0x1000000000L) != 0L || --n >= 0) continue;
            return local;
        }
        return null;
    }

    private int allocateFixed(Local local) {
        if (local.ref == null && local.index < 0) {
            int n;
            local.index = n = local.nesting == -1 ? this.jsize : this.xsize;
            n += Reflection.getJVMStackSize((Type)local.getType());
            if (local.nesting == -1) {
                this.jsize = n;
            } else {
                this.xsize = n;
            }
        }
        return local.index;
    }

    public void removeLocal(Local local) {
        this.allLocals.remove((Object)local);
    }

    void receiveLocal(Local local) {
        if (local.methodScope != this) {
            if (local.methodScope != null) {
                local.methodScope.allLocals.remove((Object)local);
            }
            this.allLocals.add((Object)local);
            local.methodScope = this;
        }
    }

    private static int computeAccesses(Expression expression, int n) {
        Local local;
        int n2;
        Object object;
        ++n;
        for (object = expression.getFirstExpression(); object != null; object = ((Expression)object).getNextExpression()) {
            n = MethodScope.computeAccesses((Expression)object, n);
        }
        ++n;
        if (expression instanceof LocalAccess) {
            object = (LocalAccess)((Object)expression);
            for (n2 = object.getLocalCount() - 1; n2 >= 0; --n2) {
                local = object.getLocal(n2);
                if (local == null) continue;
                if (local.firstAccess == null) {
                    local.firstAccess = expression;
                    local.accessRoot = expression;
                    local.lastAccess = expression;
                    continue;
                }
                local.lastAccess = expression;
                local.accessRoot = (Expression)local.accessRoot.getCommonAncestor(expression);
            }
        }
        if (expression instanceof XMethod) {
            object = MethodScope.get(expression);
            for (n2 = ((MethodScope)object).allLocals.size - 1; n2 >= 0; --n2) {
                MethodScope methodScope;
                local = (Local)((MethodScope)object).allLocals.elements[n2];
                if (local.accessRoot == null || local.isParameter() || (methodScope = MethodScope.get(local.accessRoot)) == object) continue;
                methodScope.receiveLocal(local);
            }
        }
        return n;
    }

    private void computeNesting(Expression expression, MethodScope methodScope) {
        block16: {
            Object object;
            block17: {
                MethodScope methodScope2;
                for (object = expression.getFirstExpression(); object != null; object = ((Expression)object).getNextExpression()) {
                    if (object instanceof XMethod) {
                        methodScope2 = MethodScope.get((Expression)object);
                        methodScope2.nesting = this.nesting + 1;
                        methodScope2.computeNesting((Expression)object, methodScope);
                        continue;
                    }
                    this.computeNesting((Expression)object, methodScope);
                }
                if (!(expression instanceof ControlTransfer)) break block17;
                object = (ControlTransfer)expression;
                if (object instanceof Break) {
                    methodScope2 = MethodScope.get(methodScope.getTargetFor((Break)object));
                } else if (object instanceof Return) {
                    methodScope2 = ((Return)object).getScope();
                } else {
                    throw new AssertionError(object);
                }
                ((ControlTransfer)object).setNesting(this.nesting - methodScope2.nesting);
                MethodScope methodScope3 = this;
                if (methodScope3 != methodScope2) {
                    while (methodScope3 != methodScope2) {
                        expression = (Expression)methodScope3.getMethod().getAxisParent();
                        methodScope3 = MethodScope.get(methodScope3.getEnclosingScope());
                    }
                    ((NonlocalGenerator)((Object)expression)).addTransfer((ControlTransfer)object);
                }
                if (!(object instanceof Return)) break block16;
                while (expression != methodScope3.getBlock()) {
                    if (expression.needsEmptyOperandStackForFinally()) {
                        methodScope3.declareResultLocal();
                        break block16;
                    }
                    expression = (Expression)expression.getAxisParent();
                }
                break block16;
            }
            if (expression instanceof LocalAccess) {
                object = (LocalAccess)((Object)expression);
                for (int i = object.getLocalCount() - 1; i >= 0; --i) {
                    Local local;
                    Local local2 = object.getLocal(i);
                    if (local2 == null || local2.methodScope == this) continue;
                    if (local2.isJavaLocal()) {
                        local2 = local2.methodScope.makeVMXLocal(local2);
                    }
                    if (this.nestedLocals == null) {
                        this.nestedLocals = new HashMap();
                        local = null;
                    } else {
                        local = this.nestedLocals.get(local2);
                    }
                    if (local == null) {
                        local = this.declareLocal(local2.getName(), 0L, local2.getType(), local2.getAST());
                        local.ref = local2;
                        local.nesting = this.nesting - local2.methodScope.nesting;
                        this.nestedLocals.put(local2, local);
                    }
                    object.setLocal(i, local);
                }
            }
        }
    }

    public void complete() {
        assert (this.method != null) : this;
        if (this.method == null) {
            throw new NullPointerException();
        }
        MethodScope.computeAccesses(this.method, 0);
        this.nesting = 0;
        this.computeNesting(this.getBlock(), this);
        MethodScope.complete(this.method, null);
    }

    private static void complete(Expression expression, MethodScope methodScope) {
        MethodScope methodScope2;
        if (expression instanceof XMethod) {
            methodScope = MethodScope.get(expression);
            methodScope.allocateLocals();
            expression.removeFromChain();
            methodScope2 = methodScope;
        } else {
            methodScope2 = null;
        }
        if (expression instanceof Completable) {
            ((Completable)((Object)expression)).complete(methodScope);
        }
        expression = expression.getFirstExpression();
        while (expression != null) {
            Expression expression2 = expression.getNextExpression();
            MethodScope.complete(expression, methodScope);
            expression = expression2;
        }
        if (methodScope2 != null) {
            methodScope2.method.setJFrameSize(methodScope2.jsize);
            methodScope2.method.setXFrameSize(methodScope2.xsize);
        }
    }

    private void allocateLocals() {
        for (int i = 0; i < this.allLocals.size; ++i) {
            this.allocateFixed((Local)this.allLocals.elements[i]);
        }
    }

    public void dumpLocals() {
        for (int i = 0; i < this.allLocals.size; ++i) {
            System.err.println(this.allLocals.get(i));
        }
    }

    public String toString() {
        return "MethodScope[" + TypeScope.get(this).getDeclaredType() + ',' + this.method + ',' + Reflection.modifiersToString((int)((int)this.modifiers)) + ']';
    }

    public void dispose() {
        super.dispose();
        this.allLocals.clear();
        this.labelToTarget.clear();
        this.nestedLocals = null;
        this.paramsForLocals = null;
        this.result = null;
        this.localForVMX = null;
        this.consumer = null;
        this.enclosingInstance = null;
    }
}

