/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Annotation;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.StringMap;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.util.ObjectList;
import java.util.HashMap;

public final class CompilationUnitScope
extends Scope
implements Member {
    public HashMap<AST, Object> properties = new HashMap();
    private final StringMap types = new StringMap(32, true);
    private final ObjectList<CClass> localClasses = new ObjectList();
    private final String source;
    private final Compiler compiler;
    private Annotation[] annotations;

    public static CompilationUnitScope get(Scope scope) {
        while (!(scope instanceof CompilationUnitScope)) {
            if (scope == null) {
                return null;
            }
            scope = scope.getEnclosingScope();
        }
        return (CompilationUnitScope)scope;
    }

    public CompilationUnitScope(Scope scope, String string, Compiler compiler) {
        super(scope);
        this.source = string;
        this.compiler = compiler;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public String getSource() {
        return this.source;
    }

    public void findMembers(String string, int n, Members members) {
        if ((n & 0x24) != 0) {
            TypeScope.addTypeOrPatterns((Type)this.types.get(string), members, this, n);
        }
        super.findMembers(string, n, members);
    }

    public void declareType(CClass cClass) {
        this.types.put(cClass.getSimpleName(), (Object)cClass);
        this.getPackage().declareType((Type)cClass);
    }

    public void declareLocalClass(CClass cClass) {
        this.localClasses.add((Object)cClass);
    }

    public Type[] getDeclaredTypes() {
        Type[] typeArray = new Type[this.types.size()];
        for (int i = typeArray.length - 1; i >= 0; --i) {
            typeArray[i] = (Type)this.types.getValueAt(i);
        }
        return typeArray;
    }

    public Type[] getLocalClasses() {
        return (Type[])this.localClasses.toArray((Object[])new Type[this.localClasses.size()]);
    }

    public Type getDeclaredPublicType() {
        return Reflection.getPublicType((Type[])this.getDeclaredTypes());
    }

    public void setAnnotations(Annotation[] annotationArray) {
        this.annotations = annotationArray;
    }

    public Annotation getDeclaredAnnotation(int n) {
        return this.annotations[n];
    }

    public int getDeclaredAnnotationCount() {
        return this.annotations != null ? this.annotations.length : 0;
    }

    public void dispose() {
        int n;
        this.properties.clear();
        this.properties = null;
        for (n = this.types.size() - 1; n >= 0; --n) {
            ((CClass)this.types.getValueAt(n)).dispose();
        }
        for (n = this.localClasses.size() - 1; n >= 0; --n) {
            ((CClass)this.localClasses.get(n)).dispose();
        }
    }

    public Member getDeclaredEntity() {
        return this;
    }

    public Type getDeclaringType() {
        return null;
    }

    public String getDescriptor() {
        return 'u' + this.source + ';';
    }

    public int getModifiers() {
        return 1;
    }

    public String getName() {
        return this.source;
    }

    public String getSimpleName() {
        return this.source;
    }
}

