/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.reflect.XField;
import de.grogra.xl.compiler.AccessMethod;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.ComplexMethod;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.lang.BooleanConsumer;
import de.grogra.xl.lang.ByteConsumer;
import de.grogra.xl.lang.CharConsumer;
import de.grogra.xl.lang.DoubleConsumer;
import de.grogra.xl.lang.FloatConsumer;
import de.grogra.xl.lang.IntConsumer;
import de.grogra.xl.lang.LongConsumer;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.lang.ShortConsumer;
import de.grogra.xl.lang.VoidConsumer;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.Routine;
import de.grogra.xl.vmx.VMXState;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMethod
extends ComplexMethod
implements Method {
    String noRetDescriptor;
    AccessMethod accessMethod;
    private final String routineId;
    private String descriptor;
    private long modifiers;
    private final CClass declaringClass;
    private final MethodScope scope;
    private final Type returnType;
    private Type[] parameterTypes;
    private int xsize = 0;
    private final Type[] exceptionTypes;
    private final XField routineField;
    private ArrayList<Annotation> annotations = new ArrayList();

    public XMethod(String string, long l, CClass cClass, Type[] typeArray, Type type, Expression expression) {
        this.setName(string);
        this.declaringClass = cClass;
        this.scope = null;
        this.modifiers = l;
        this.returnType = type;
        this.parameterTypes = typeArray;
        this.exceptionTypes = Type.TYPE_0;
        this.updateParameters();
        this.routineId = null;
        cClass.declareMethod(this);
        this.routineField = null;
        this.add(expression);
    }

    public XMethod(String string, long l, MethodScope methodScope, Type type, Type[] typeArray) {
        this.setName(string);
        this.scope = methodScope;
        this.modifiers = l;
        this.returnType = type;
        this.exceptionTypes = typeArray;
        if ((l & 0x400000000L) != 0L) {
            this.declaringClass = methodScope.getDeclaredType().getCallbackClass();
            this.routineField = this.declaringClass.addRoutine(this);
        } else {
            this.declaringClass = methodScope.getDeclaredType();
            this.routineField = null;
        }
        this.updateParameters();
        this.routineId = (this.declaringClass.getBinaryName() + '.' + string + '(' + Reflection.getDescriptor((Type[])this.parameterTypes) + ')').intern();
        this.setJFrameSize(0);
        this.declaringClass.declareMethod(this);
    }

    public Local getLocalForVMX() {
        return this.scope.getLocalForVMX();
    }

    public Field getRoutineField() {
        return this.routineField;
    }

    public void updateParameters() {
        boolean bl;
        if (this.scope != null) {
            bl = this.parameterTypes != null;
            this.parameterTypes = this.scope.getParameterTypes();
        } else {
            bl = false;
        }
        this.descriptor = Reflection.getMethodDescriptor((String)this.getName(), (Type)this.returnType, (Type[])this.parameterTypes);
        this.noRetDescriptor = this.descriptor.substring(0, this.descriptor.lastIndexOf(41) + 1);
        this.setParameterSize(Reflection.getJVMStackSize((Type[])this.parameterTypes) + ((this.modifiers & 8L) == 0L ? 1 : 0));
        if (bl) {
            this.declaringClass.getLookup().update();
        }
    }

    public String getRoutineId() {
        return this.routineId;
    }

    @Override
    public TypeLoader getTypeLoader() {
        return this.declaringClass.getTypeLoader();
    }

    public final void setXFrameSize(int n) {
        this.xsize = n;
    }

    @Override
    public int getFrameSize() {
        return this.xsize;
    }

    @Override
    public boolean hasJavaParameters() {
        return (this.modifiers & 0x400000000L) == 0L;
    }

    public final int getModifiers() {
        return (int)this.modifiers;
    }

    public final long getModifiersEx() {
        return this.modifiers;
    }

    public final void setPublic() {
        this.modifiers = this.modifiers & 0xFFFFFFFFFFFFFFF8L | 1L;
    }

    public final Type getDeclaringType() {
        return this.declaringClass;
    }

    public final String getSimpleName() {
        return this.getName();
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final int getParameterCount() {
        return this.parameterTypes.length;
    }

    public final Type getParameterType(int n) {
        return this.parameterTypes[n];
    }

    public int getExceptionCount() {
        return this.exceptionTypes.length;
    }

    public Type getExceptionType(int n) {
        return this.exceptionTypes[n];
    }

    public int getDeclaredAnnotationCount() {
        return this.annotations.size();
    }

    public Annotation getDeclaredAnnotation(int n) {
        return this.annotations.get(n);
    }

    List<Annotation> getDeclaredAnnotations() {
        return this.annotations;
    }

    public int getParameterAnnotationCount(int n) {
        if (this.scope == null) {
            return 0;
        }
        return this.scope.getParameter(n).getDeclaredAnnotationCount();
    }

    public Annotation getParameterAnnotation(int n, int n2) {
        return this.scope.getParameter(n).getDeclaredAnnotation(n2);
    }

    public final Object invoke(Object object, Object[] objectArray) throws InvocationTargetException {
        return this.invoke(object, objectArray, VMXState.current());
    }

    public final Object invoke(Object object, Object[] objectArray, VMXState vMXState) throws InvocationTargetException {
        AbruptCompletion.Return return_ = this.invoke0(object, objectArray, vMXState);
        if (return_ == null) {
            return null;
        }
        switch (return_.getTypeId()) {
            case 2: {
                return return_.iget() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return (byte)return_.iget();
            }
            case 4: {
                return (short)return_.iget();
            }
            case 5: {
                return Character.valueOf((char)return_.iget());
            }
            case 6: {
                return return_.iget();
            }
            case 7: {
                return return_.lget();
            }
            case 8: {
                return Float.valueOf(return_.fget());
            }
            case 9: {
                return return_.dget();
            }
        }
        return return_.aget();
    }

    private AbruptCompletion.Return invoke0(Object object, Object[] objectArray, VMXState vMXState) throws InvocationTargetException {
        if ((this.modifiers & 8L) == 0L) {
            if ((this.modifiers & 0x800000000L) != 0L) {
                vMXState.apush((Object)this.declaringClass);
            } else {
                if (object == null) {
                    throw new NullPointerException();
                }
                if (!this.declaringClass.isInstance(object)) {
                    throw new IllegalArgumentException();
                }
                vMXState.apush(object);
            }
        }
        if (objectArray == null ? this.parameterTypes.length != 0 : this.parameterTypes.length != objectArray.length) {
            throw new IllegalArgumentException();
        }
        block7: for (int i = 0; i < this.parameterTypes.length; ++i) {
            Object object2 = objectArray[i];
            int n = this.parameterTypes[i].getTypeId();
            switch (n) {
                case 2: {
                    if (!(object2 instanceof Boolean)) break;
                    vMXState.ipush((Boolean)object2 != false ? 1 : 0);
                    continue block7;
                }
                case 5: {
                    if (!(object2 instanceof Character)) break;
                    vMXState.ipush((int)((Character)object2).charValue());
                    continue block7;
                }
                case 7: {
                    if (!(object2 instanceof Number)) break;
                    vMXState.lpush(((Number)object2).longValue());
                    continue block7;
                }
                case 8: {
                    if (!(object2 instanceof Number)) break;
                    vMXState.fpush(((Number)object2).floatValue());
                    continue block7;
                }
                case 9: {
                    if (!(object2 instanceof Number)) break;
                    vMXState.dpush(((Number)object2).doubleValue());
                    continue block7;
                }
                default: {
                    if ((1 << n & 0x7C) != 0) {
                        if (!(object2 instanceof Number)) break;
                        vMXState.ipush(((Number)object2).intValue());
                        continue block7;
                    }
                    if (object2 != null && !this.parameterTypes[i].isInstance(object2)) break;
                    vMXState.apush(object2);
                    continue block7;
                }
            }
            throw new IllegalArgumentException();
        }
        AbruptCompletion.Return return_ = vMXState.invoke((Routine)this, -1, null);
        if (return_ != null && return_.getTypeId() == 1) {
            return_.dispose();
            return_ = null;
        }
        if (((this.modifiers & 0x800000000L) != 0L ? 0 : this.returnType.getTypeId()) != (return_ == null ? 1 : return_.getTypeId())) {
            throw new AssertionError();
        }
        return return_;
    }

    @Override
    protected void evaluateImpl(VMXState vMXState) {
        if ((this.modifiers & 0x800000008L) != 0L) {
            this.declaringClass.initialize();
        }
        if ((this.modifiers & 0x800000000L) != 0L) {
            try {
                super.evaluateImpl(vMXState);
            }
            catch (AbruptCompletion.Return return_) {
                return_.dispose();
            }
            throw vMXState.areturn(vMXState.agetj(0, null));
        }
        super.evaluateImpl(vMXState);
        if ((this.modifiers & 0x100000000L) != 0L) {
            switch (this.returnType.getTypeId()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    throw vMXState.ireturn(0);
                }
                case 7: {
                    throw vMXState.lreturn(0L);
                }
                case 8: {
                    throw vMXState.freturn(0.0f);
                }
                case 9: {
                    throw vMXState.dreturn(0.0);
                }
                case 0: {
                    throw vMXState.areturn(null);
                }
                case 1: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.returnType.getTypeId() != 1) {
            throw new RuntimeException("Method " + Reflection.getDescription((Member)this) + " exited without return value");
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ',' + Reflection.getDescription((Member)this) + ',' + Long.toHexString(this.getModifiersEx());
    }

    public static Type getGeneratorType(Method method) {
        if (method.getParameterCount() == 0) {
            return null;
        }
        Type type = method.getParameterType(0);
        for (int i = 0; i < 10; ++i) {
            if (!Reflection.equal((Class)XMethod.getConsumerType(i), (Type)type)) continue;
            if (i != 0) {
                return Reflection.getType((int)i);
            }
            Type type2 = method.getReturnType();
            return type2.getTypeId() == 0 ? type2 : Type.OBJECT;
        }
        return null;
    }

    public static Type getGeneratorOrReturnType(Method method) {
        Type type = XMethod.getGeneratorType(method);
        return type != null ? type : method.getReturnType();
    }

    public static Class getConsumerType(int n) {
        switch (n) {
            case 2: {
                return BooleanConsumer.class;
            }
            case 3: {
                return ByteConsumer.class;
            }
            case 4: {
                return ShortConsumer.class;
            }
            case 5: {
                return CharConsumer.class;
            }
            case 6: {
                return IntConsumer.class;
            }
            case 7: {
                return LongConsumer.class;
            }
            case 8: {
                return FloatConsumer.class;
            }
            case 9: {
                return DoubleConsumer.class;
            }
            case 0: {
                return ObjectConsumer.class;
            }
            case 1: {
                return VoidConsumer.class;
            }
        }
        throw new AssertionError(n);
    }

    public boolean hasEmptyBytecode() {
        Expression expression = this.getFirstExpression();
        return expression instanceof Block && ((Block)expression).isEmpty() && !this.containsAssertionStatusInit();
    }

    private boolean containsAssertionStatusInit() {
        return this.scope != null && "<clinit>".equals(this.getName()) && TypeScope.get(this.scope).hasAssertionsDisabledField();
    }

    @Override
    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl);
        if (this.containsAssertionStatusInit()) {
            bytecodeWriter.visitaconst(this.declaringClass);
            bytecodeWriter.visitMethodInsn(182, "java/lang/Class", "desiredAssertionStatus", "()Z");
            bytecodeWriter.visiticonst(1);
            bytecodeWriter.visitInsn(130);
            bytecodeWriter.visitFieldInsn(179, TypeScope.get(this.scope).getAssertionsDisabledField(), null);
        }
        this.writeChildren(bytecodeWriter);
        if (!bytecodeWriter.isUnreachable()) {
            bytecodeWriter.visitNull(this.returnType.getTypeId());
            bytecodeWriter.visitReturn(this.returnType.getTypeId());
        }
    }

    void dispose() {
        this.removeAll(null);
        if (this.scope != null) {
            this.scope.dispose();
        }
    }
}

