/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.collections.AST;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Signature;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerBase;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.lang.Aggregate;
import de.grogra.xl.lang.Filter;

class ArgumentTransformations {
    static final Type[] NO_IMPLICIT = Type.TYPE_0;
    static final Type[] GENERATOR = new Type[1];
    static final Type[] FIRST_TERM = new Type[1];
    static final Type AGGREGATE_TYPE = ClassAdapter.wrap(Aggregate.class);
    static final Type[] AGGREGATE = new Type[]{AGGREGATE_TYPE};
    static final Type[] FILTER = new Type[]{ClassAdapter.wrap(Filter.class)};
    static final ArgumentTransformations NO_IMPLICIT_ARGS = new ArgumentTransformations(new Type[1][0], null);
    static final ArgumentTransformations PREDICATE_ARGS = new ArgumentTransformations(new Type[][]{NO_IMPLICIT, FIRST_TERM}, null);
    Type[][] types;
    int[][] indices;

    ArgumentTransformations(Type[][] typeArray, int[][] nArray) {
        this.types = typeArray;
        this.indices = nArray;
    }

    ArgumentTransformations(Type[][] typeArray) {
        this.types = typeArray;
        int[][] nArrayArray = new int[typeArray.length][];
        for (int i = 0; i < nArrayArray.length; ++i) {
            int[] nArray = new int[typeArray[i].length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = j;
            }
            nArrayArray[i] = nArray;
        }
        this.indices = nArrayArray;
    }

    boolean isGenerator(int n) {
        return this.types[n] == GENERATOR;
    }

    boolean isAggregate(int n) {
        return this.types[n].length > 0 && this.types[n][0] == AGGREGATE_TYPE;
    }

    boolean isFilter(int n) {
        return this.types[n] == FILTER;
    }

    final int getAlternativeCount() {
        return this.types.length;
    }

    Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
        if (n2 == 0 && (this.isGenerator(n) || this.isAggregate(n) || this.isFilter(n))) {
            return null;
        }
        throw new AssertionError();
    }

    int getApplicableOption(Signature signature, Members.Applicability applicability, Expression[] expressionArray, Scope scope) {
        for (int i = 0; i < this.getAlternativeCount(); ++i) {
            if (!this.isApplicable(signature, applicability, i, expressionArray, scope)) continue;
            return i;
        }
        return -1;
    }

    final Expression[] complete(Signature signature, int n, Expression[] expressionArray, boolean bl, Scope scope, AST aST) {
        Type[] typeArray = this.types[n];
        if (typeArray.length == 0) {
            return expressionArray;
        }
        int[] nArray = this.indices == null ? null : this.indices[n];
        int n2 = typeArray.length + expressionArray.length;
        Expression[] expressionArray2 = new Expression[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            Type type = Reflection.getParameterType((Signature)signature, (int)i, (boolean)bl);
            expressionArray2[i] = n3 < typeArray.length && (nArray == null || nArray[n3] == i || nArray[n3] == i - n2) ? this.createImplicitArgument(n, n3++, type, scope, aST) : expressionArray[n4++];
        }
        return expressionArray2;
    }

    boolean isApplicable(Signature signature, Members.Applicability applicability, int n, Expression[] expressionArray, Scope scope) {
        Type[] typeArray = this.types[n];
        int[] nArray = this.indices == null ? null : this.indices[n];
        int n2 = typeArray.length + expressionArray.length;
        Compiler compiler = scope.getCompiler();
        applicability.actualArguments.clear();
        applicability.varArity = false;
        if (compiler.resolutionPhase == 3 && (((Method)signature).getModifiers() & 0x80) != 0) {
            if (n2 < signature.getParameterCount() - 1) {
                return false;
            }
            applicability.varArity = true;
        } else if (signature.getParameterCount() != n2) {
            return false;
        }
        if ((this.isAggregate(n) || this.isFilter(n)) && n2 == 1) {
            return false;
        }
        applicability.implicitCount = typeArray.length;
        applicability.array2Generator = false;
        applicability.transformationAlternative = n;
        int n3 = 0;
        int n4 = 0;
        block0: for (int i = 0; i < n2; ++i) {
            Type type;
            boolean bl;
            if (i == 0 && this.isGenerator(n) && (!(signature instanceof Method) || XMethod.getGeneratorType((Method)signature) == null)) {
                return false;
            }
            Type type2 = Reflection.getParameterType((Signature)signature, (int)i, (boolean)applicability.varArity);
            boolean bl2 = bl = n3 < typeArray.length && (nArray == null || nArray[n3] == i || nArray[n3] == i - n2);
            if (!bl && n4 == expressionArray.length) {
                return false;
            }
            Type type3 = type = bl ? typeArray[n3++] : expressionArray[n4++].getType();
            if (type == null) {
                applicability.actualArguments.add((Object)type);
                continue;
            }
            if (bl) {
                if (this.matchesImplicit(type2, n3 - 1, n, type)) {
                    applicability.actualArguments.add((Object)type);
                    continue;
                }
                return false;
            }
            if (signature instanceof PatternWrapper && type.getTypeId() == 0 && type2.getTypeId() == 0) {
                if (Reflection.isCastableFrom((Type)type2, (Type)type)) {
                    applicability.actualArguments.add((Object)type);
                    continue;
                }
                return false;
            }
            if (i == 1 && (this.isAggregate(n) || this.isFilter(n)) && Reflection.isArray((Type)type)) {
                type = type.getComponentType();
                applicability.array2Generator = true;
            }
            while (true) {
                if (CompilerBase.stdCvType(type, type2, compiler.resolutionPhase >= 1, scope) != 0) {
                    applicability.actualArguments.add((Object)type);
                    continue block0;
                }
                if (signature instanceof PatternWrapper) {
                    return false;
                }
                if (compiler.resolutionPhase == 1 && compiler.standardImplicitConversion(new Expression(type), type2, true, scope, null, null, true) != null) {
                    applicability.actualArguments.add((Object)type);
                    continue block0;
                }
                if (compiler.resolutionPhase >= 2 && compiler.implicitConversion(new Expression(type), type2, true, scope, null, null, true) != null) {
                    applicability.actualArguments.add((Object)type);
                    continue block0;
                }
                if (type == type3) break;
                applicability.array2Generator = false;
                type = type3;
            }
            return false;
        }
        return true;
    }

    boolean matchesImplicit(Type type, int n, int n2, Type type2) {
        return Reflection.equal((Type)type, (Type)type2);
    }
}

