/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.GraphUtilities;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.Random;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class RandomLayout
extends Layout {
    float magnitude = 5.0f;
    int count = 1;
    boolean startWithRandom = false;
    boolean displayTransformation = true;
    public static final Type $TYPE = new Type(RandomLayout.class);
    public static final SCOType.Field magnitude$FIELD = Type._addManagedField($TYPE, "magnitude", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field count$FIELD = Type._addManagedField($TYPE, "count", 0x200000, de.grogra.reflect.Type.INT, null, 3);
    public static final SCOType.Field startWithRandom$FIELD = Type._addManagedField($TYPE, "startWithRandom", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 4);
    public static final SCOType.Field displayTransformation$FIELD = Type._addManagedField($TYPE, "displayTransformation", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 5);

    protected Layout.Algorithm createAlgorithm() {
        return new Layout.Algorithm(){
            private Random rnd = new Random();

            protected void layout(Node node) {
                if (RandomLayout.this.startWithRandom) {
                    this.setRandomStartPositions(node);
                }
                if (RandomLayout.this.transformationSteps > 1) {
                    RandomLayout.this.startWithRandom = false;
                }
                for (int i = 0; i < RandomLayout.this.count; ++i) {
                    this.layoutList(node);
                }
            }

            private void layoutList(Node node) {
                GraphUtilities graphUtilities = new GraphUtilities();
                LinkedList linkedList = graphUtilities.getNodesList(node);
                Vector3d vector3d = new Vector3d();
                Dimension dimension = this.view.getSize();
                Matrix3d matrix3d = this.view.getTransformation();
                matrix3d.invert();
                matrix3d.transform((Tuple3d)new Vector3d((double)(-dimension.width / 2), (double)(-dimension.height / 2), 0.0), (Tuple3d)vector3d);
                ((Node)((Object)linkedList.get((int)0))).x = (float)vector3d.x;
                ((Node)((Object)linkedList.get((int)0))).y = (float)vector3d.y;
                for (int i = 1; i < linkedList.size(); ++i) {
                    Node node2 = (Node)((Object)linkedList.get(i));
                    float f = this.rnd.nextFloat();
                    node2.x += RandomLayout.this.magnitude * (f - 0.5f);
                    float f2 = this.rnd.nextFloat();
                    node2.y += RandomLayout.this.magnitude * (f2 - 0.5f);
                }
            }

            private void setRandomStartPositions(Node node) {
                while (node != null) {
                    node.x = this.rnd.nextFloat();
                    node.y = this.rnd.nextFloat();
                    node = node.next;
                }
            }
        };
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 6;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(RandomLayout randomLayout, SCOType sCOType) {
            super(randomLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 4: {
                    ((RandomLayout)((Object)object)).startWithRandom = bl;
                    return;
                }
                case 5: {
                    ((RandomLayout)((Object)object)).displayTransformation = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 4: {
                    return ((RandomLayout)((Object)object)).startWithRandom;
                }
                case 5: {
                    return ((RandomLayout)((Object)object)).displayTransformation;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 3: {
                    ((RandomLayout)((Object)object)).count = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((RandomLayout)((Object)object)).count;
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((RandomLayout)((Object)object)).magnitude = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((RandomLayout)((Object)object)).magnitude;
                }
            }
            return super.getFloat(object, n);
        }

        public Object newInstance() {
            return new RandomLayout();
        }
    }
}

