/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

class NodeWrapper
implements Comparable {
    private double edgeCrossesIndicator = 0.0;
    private int additions = 0;
    int level = 0;
    int gridPosition = 0;
    int priority = 0;
    Object node = null;

    NodeWrapper(int n, double d, Object object) {
        this.level = n;
        this.edgeCrossesIndicator = d;
        this.node = object;
        ++this.additions;
    }

    Object getNode() {
        return this.node;
    }

    void resetEdgeCrossesIndicator() {
        this.edgeCrossesIndicator = 0.0;
        this.additions = 0;
    }

    double getEdgeCrossesIndicator() {
        if (this.additions == 0) {
            return 0.0;
        }
        return this.edgeCrossesIndicator / (double)this.additions;
    }

    void addToEdgeCrossesIndicator(double d) {
        this.edgeCrossesIndicator += d;
        ++this.additions;
    }

    int getLevel() {
        return this.level;
    }

    int getGridPosition() {
        return this.gridPosition;
    }

    void setGridPosition(int n) {
        this.gridPosition = n;
    }

    void incrementPriority() {
        ++this.priority;
    }

    int getPriority() {
        return this.priority;
    }

    public int compareTo(Object object) {
        if (((NodeWrapper)object).getEdgeCrossesIndicator() == this.getEdgeCrossesIndicator()) {
            return 0;
        }
        double d = ((NodeWrapper)object).getEdgeCrossesIndicator() - this.getEdgeCrossesIndicator();
        return (int)(d * 1000.0);
    }
}

