/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.ForceBasedLayout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.SCOType;
import java.util.Random;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class FruchtermanReingoldLayout
extends ForceBasedLayout {
    private double frameX = 10.0;
    private double frameY = 10.0;
    private double frameArea = this.frameX * this.frameY;
    private double scaleFactor = 1.0;
    public static final Type $TYPE = new Type(FruchtermanReingoldLayout.class);
    public static final SCOType.Field frameX$FIELD = Type._addManagedField($TYPE, "frameX", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 7);
    public static final SCOType.Field frameY$FIELD = Type._addManagedField($TYPE, "frameY", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 8);
    public static final SCOType.Field scaleFactor$FIELD = Type._addManagedField($TYPE, "scaleFactor", 0x200002, de.grogra.reflect.Type.DOUBLE, null, 9);

    protected void setRandomPosition(Node node, Random random) {
        node.x = random.nextFloat();
        node.y = random.nextFloat();
    }

    protected void computeForce(Node node, Node node2, Vector2f vector2f) {
        double d = Math.sqrt(Math.abs(this.frameArea / (double)this.nodesSize)) * this.scaleFactor;
        double d2 = node2.distance(node);
        if (d2 == 0.0) {
            d2 = 0.001;
        }
        vector2f.sub((Tuple2f)node2, (Tuple2f)node);
        if (d2 > 0.0) {
            vector2f.scale((float)(1.0 / d2));
        }
        vector2f.scale((float)(d * d / d2));
    }

    protected void computeForce(Edge edge, Vector2f vector2f) {
        double d = Math.sqrt(Math.abs(this.frameArea / (double)this.nodesSize)) * this.scaleFactor;
        double d2 = edge.source.distance(edge.target);
        if (d2 == 0.0) {
            d2 = 0.001;
        }
        vector2f.sub((Tuple2f)edge.source, (Tuple2f)edge.target);
        vector2f.scale((float)(1.0 / d2));
        vector2f.scale((float)(d2 * d2 / d));
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends ForceBasedLayout.Type {
        private static final int SUPER_FIELD_COUNT = 7;
        protected static final int FIELD_COUNT = 10;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(FruchtermanReingoldLayout fruchtermanReingoldLayout, SCOType sCOType) {
            super(fruchtermanReingoldLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)ForceBasedLayout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setDouble(Object object, int n, double d) {
            switch (n) {
                case 7: {
                    ((FruchtermanReingoldLayout)((Object)object)).frameX = d;
                    return;
                }
                case 8: {
                    ((FruchtermanReingoldLayout)((Object)object)).frameY = d;
                    return;
                }
                case 9: {
                    ((FruchtermanReingoldLayout)((Object)object)).scaleFactor = d;
                    return;
                }
            }
            super.setDouble(object, n, d);
        }

        protected double getDouble(Object object, int n) {
            switch (n) {
                case 7: {
                    return ((FruchtermanReingoldLayout)((Object)object)).frameX;
                }
                case 8: {
                    return ((FruchtermanReingoldLayout)((Object)object)).frameY;
                }
                case 9: {
                    return ((FruchtermanReingoldLayout)((Object)object)).scaleFactor;
                }
            }
            return super.getDouble(object, n);
        }

        public Object newInstance() {
            return new FruchtermanReingoldLayout();
        }
    }
}

