/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.layout;

import de.grogra.imp2d.layout.Edge;
import de.grogra.imp2d.layout.Layout;
import de.grogra.imp2d.layout.Node;
import de.grogra.persistence.SCOType;
import java.util.Random;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public abstract class ForceBasedLayout
extends Layout {
    float relaxation = 0.0378f;
    boolean displayTransformation = true;
    float accuracy = 0.01f;
    int count = 100;
    boolean startWithRandom = true;
    public int connectedNodesSize = 0;
    public int nodesSize = 0;
    public static final Type $TYPE = new Type(ForceBasedLayout.class);
    public static final SCOType.Field relaxation$FIELD = Type._addManagedField($TYPE, "relaxation", 0x200000, de.grogra.reflect.Type.FLOAT, null, 2);
    public static final SCOType.Field displayTransformation$FIELD = Type._addManagedField($TYPE, "displayTransformation", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 3);
    public static final SCOType.Field accuracy$FIELD = Type._addManagedField($TYPE, "accuracy", 0x200000, de.grogra.reflect.Type.FLOAT, null, 4);
    public static final SCOType.Field count$FIELD = Type._addManagedField($TYPE, "count", 0x200000, de.grogra.reflect.Type.INT, null, 5);
    public static final SCOType.Field startWithRandom$FIELD = Type._addManagedField($TYPE, "startWithRandom", 0x200000, de.grogra.reflect.Type.BOOLEAN, null, 6);

    public void setStartWithRandom(boolean bl) {
        this.startWithRandom = bl;
    }

    protected Layout.Algorithm createAlgorithm() {
        return new FBAlgorithm();
    }

    protected abstract void computeForce(Node var1, Node var2, Vector2f var3);

    protected abstract void computeForce(Edge var1, Vector2f var2);

    protected abstract void setRandomPosition(Node var1, Random var2);

    static {
        $TYPE.validate();
    }

    public static class Type
    extends Layout.Type {
        private static final int SUPER_FIELD_COUNT = 2;
        protected static final int FIELD_COUNT = 7;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(ForceBasedLayout forceBasedLayout, SCOType sCOType) {
            super(forceBasedLayout, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)Layout.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setBoolean(Object object, int n, boolean bl) {
            switch (n) {
                case 3: {
                    ((ForceBasedLayout)((Object)object)).displayTransformation = bl;
                    return;
                }
                case 6: {
                    ((ForceBasedLayout)((Object)object)).startWithRandom = bl;
                    return;
                }
            }
            super.setBoolean(object, n, bl);
        }

        protected boolean getBoolean(Object object, int n) {
            switch (n) {
                case 3: {
                    return ((ForceBasedLayout)((Object)object)).displayTransformation;
                }
                case 6: {
                    return ((ForceBasedLayout)((Object)object)).startWithRandom;
                }
            }
            return super.getBoolean(object, n);
        }

        protected void setInt(Object object, int n, int n2) {
            switch (n) {
                case 5: {
                    ((ForceBasedLayout)((Object)object)).count = n2;
                    return;
                }
            }
            super.setInt(object, n, n2);
        }

        protected int getInt(Object object, int n) {
            switch (n) {
                case 5: {
                    return ((ForceBasedLayout)((Object)object)).count;
                }
            }
            return super.getInt(object, n);
        }

        protected void setFloat(Object object, int n, float f) {
            switch (n) {
                case 2: {
                    ((ForceBasedLayout)((Object)object)).relaxation = f;
                    return;
                }
                case 4: {
                    ((ForceBasedLayout)((Object)object)).accuracy = f;
                    return;
                }
            }
            super.setFloat(object, n, f);
        }

        protected float getFloat(Object object, int n) {
            switch (n) {
                case 2: {
                    return ((ForceBasedLayout)((Object)object)).relaxation;
                }
                case 4: {
                    return ((ForceBasedLayout)((Object)object)).accuracy;
                }
            }
            return super.getFloat(object, n);
        }
    }

    public class FBAlgorithm
    extends Layout.Algorithm {
        private float maxForce;
        private final Vector2f sumForce;
        private final Vector2f tmpForce;

        public FBAlgorithm() {
            super(ForceBasedLayout.this);
            this.sumForce = new Vector2f();
            this.tmpForce = new Vector2f();
        }

        protected void layout(Node node) {
            Random random = new Random();
            Node node2 = node;
            while (node2 != null) {
                ++ForceBasedLayout.this.nodesSize;
                if (ForceBasedLayout.this.startWithRandom && !node2.equals((Tuple2f)node)) {
                    ForceBasedLayout.this.setRandomPosition(node2, random);
                }
                if (node2.getFirstEdge() != null) {
                    ++ForceBasedLayout.this.connectedNodesSize;
                }
                node2 = node2.next;
            }
            if (ForceBasedLayout.this.transformationSteps > 1) {
                ForceBasedLayout.this.startWithRandom = false;
            }
            float f = 0.0f;
            for (int i = 0; i < ForceBasedLayout.this.count; ++i) {
                f = this.maxForce;
                this.maxForce = 0.0f;
                this.layoutList(node);
                if (this.maxForce > f + 1.0f && f != 0.0f) {
                    ForceBasedLayout.this.progressText = "parametres of the layout algorithm do not suit - stop!";
                    break;
                }
                if (this.maxForce < ForceBasedLayout.this.accuracy) break;
            }
            ForceBasedLayout.this.param = 0;
            if (ForceBasedLayout.this.progressText.equals("")) {
                ForceBasedLayout.this.progressText = "layout calculated successfully";
            }
        }

        private void layoutList(Node node) {
            Node node2 = node;
            while (node2 != null) {
                node2.layoutVarY = 0.0f;
                node2.layoutVarX = 0.0f;
                node2 = node2.next;
            }
            node2 = node;
            while (node2 != null) {
                Node node3 = node2.next;
                while (node3 != null) {
                    if (node2 != node3) {
                        ForceBasedLayout.this.computeForce(node2, node3, this.sumForce);
                        Edge edge = node2.getEdgeTo(node3);
                        if (edge != null) {
                            ForceBasedLayout.this.computeForce(edge, this.tmpForce);
                            this.sumForce.add((Tuple2f)this.tmpForce);
                        }
                        if ((edge = node3.getEdgeTo(node2)) != null) {
                            ForceBasedLayout.this.computeForce(edge, this.tmpForce);
                            this.sumForce.sub((Tuple2f)this.tmpForce);
                        }
                        node2.layoutVarX -= this.sumForce.x;
                        node2.layoutVarY -= this.sumForce.y;
                        node3.layoutVarX += this.sumForce.x;
                        node3.layoutVarY += this.sumForce.y;
                    }
                    node3 = node3.next;
                }
                this.maxForce = Math.max(Math.max(Math.abs(node2.layoutVarX), Math.abs(node2.layoutVarY)), this.maxForce);
                node2.x += ForceBasedLayout.this.relaxation * node2.layoutVarX;
                node2.y += ForceBasedLayout.this.relaxation * node2.layoutVarY;
                node2 = node2.next;
            }
        }
    }
}

