/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d.graphs;

import de.grogra.graph.AccessorMap;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeOverwritingFilter;
import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.EdgePattern;
import de.grogra.graph.EdgePatternImpl;
import de.grogra.graph.EventSupport;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphFilter;
import de.grogra.graph.GraphState;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ObjectMapImpl;
import de.grogra.graph.Path;
import de.grogra.graph.SpecialEdgeDescriptor;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.Node;
import de.grogra.imp.IMP;
import de.grogra.imp2d.ClickEvent2D;
import de.grogra.imp2d.IMP2D;
import de.grogra.imp2d.View2D;
import de.grogra.imp2d.edit.Editable;
import de.grogra.imp2d.graphs.EdgeBits;
import de.grogra.imp2d.graphs.ObjectData;
import de.grogra.imp2d.objects.Arrow;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.imp2d.objects.Connection;
import de.grogra.imp2d.objects.NURBSShape2D;
import de.grogra.imp2d.objects.Rhombus;
import de.grogra.imp2d.objects.Shape2D;
import de.grogra.imp2d.objects.StrokeAdapter;
import de.grogra.pf.registry.Item;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.UI;
import de.grogra.reflect.Type;
import de.grogra.util.EnumValueImpl;
import de.grogra.util.EventListener;
import de.grogra.util.Int2ObjectMap;
import de.grogra.util.ThreadContext;
import de.grogra.xl.util.ObjectList;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3f;

public class TopologyGraph
extends AttributeOverwritingFilter
implements EventListener {
    final ObjectMapImpl data;
    private final String root;
    private GraphFilter.AccessorBridge nodeShape;
    private GraphFilter.AccessorBridge nodeTransformation;
    private GraphFilter.AccessorBridge nodeShape2D;
    private GraphFilter.AccessorBridge nodeEditable;
    private GraphFilter.AccessorBridge nodeTransform;
    private GraphFilter.AccessorBridge nodeCaption;
    private GraphFilter.AccessorBridge nodeHAlignment;
    private GraphFilter.AccessorBridge nodeFillColor;
    private GraphFilter.AccessorBridge edgeShape;
    private GraphFilter.AccessorBridge edgeTransformation;
    private GraphFilter.AccessorBridge edgeCurve;
    private GraphFilter.AccessorBridge edgeArrow;
    private GraphFilter.AccessorBridge edgeFilled;
    private GraphFilter.AccessorBridge edgeColor;
    private GraphFilter.AccessorBridge edgeStroke;
    private GraphFilter.AccessorBridge edgeBits;
    private GraphFilter.AccessorBridge edgeCaption;
    private GraphFilter.AccessorBridge edgeFillColor;
    private GraphFilter.AccessorBridge edgeWeight;
    private final Shape2D shapeInstance;
    private static final HashSet<Object> collapsedNodes = new HashSet();
    private static final Connection CONNECTION = new Connection();
    private static final Rectangle2D RECTANGLE = new Rectangle2D.Float(-0.5f, -0.12f, 1.0f, 0.24f);
    private static final RectangularShape ROUND_RECTANGLE = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 0.2f, 0.2f);
    private static final RectangularShape ELLIPSE = new Ellipse2D.Float();
    private static final RectangularShape RHOMBUS = new Rhombus();
    private static final Arrow EDGE_ARROW = new Arrow();
    private static final Color3f STANDARD_EDGE_COLOR = new Color3f(0.0f, 1.0f, 0.7f);
    private static final Color3f WHITE = new Color3f(1.0f, 1.0f, 1.0f);
    private static final Color3f SPECIAL_EDGE_COLOR = new Color3f(1.0f, 0.0f, 1.0f);
    private static final StrokeAdapter SOLID_STROKE = new StrokeAdapter();
    private static final StrokeAdapter DASHED_STROKE = new StrokeAdapter();
    private static final StrokeAdapter DASHED_DOTTED_STROKE = new StrokeAdapter();
    private Int2ObjectMap colors = new Int2ObjectMap();
    private static final ObjectAttribute PARENT;
    private static final EdgePatternImpl PATTERN;

    public TopologyGraph(Graph graph, String string) {
        super(graph);
        this.initAttributeOverwritingFilter();
        this.root = string;
        this.shapeInstance = new Shape2D();
        this.shapeInstance.setOutlined(false);
        this.data = new ObjectMapImpl();
    }

    protected void initNodeAccessors(AccessorMap accessorMap) {
        this.nodeShape = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.SHAPE, true);
        accessorMap.add((AttributeAccessor)this.nodeShape);
        this.nodeTransformation = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.TRANSFORMATION, true);
        accessorMap.add((AttributeAccessor)this.nodeTransformation);
        this.nodeShape2D = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.SHAPE_2D, true);
        accessorMap.add((AttributeAccessor)this.nodeShape2D);
        this.nodeFillColor = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.FILL_COLOR, true);
        accessorMap.add((AttributeAccessor)this.nodeFillColor);
        this.nodeEditable = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Editable.ATTRIBUTE, true);
        accessorMap.add((AttributeAccessor)this.nodeEditable);
        this.nodeTransform = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.TRANSFORM, true);
        accessorMap.add((AttributeAccessor)this.nodeTransform);
        this.nodeCaption = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.CAPTION, true);
        accessorMap.add((AttributeAccessor)this.nodeCaption);
        this.nodeHAlignment = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.HORIZONTAL_ALIGNMENT, true);
        accessorMap.add((AttributeAccessor)this.nodeHAlignment);
    }

    protected void initEdgeAccessors(AccessorMap accessorMap) {
        this.edgeShape = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.SHAPE, false);
        accessorMap.add((AttributeAccessor)this.edgeShape);
        this.edgeCurve = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.CURVE, false);
        accessorMap.add((AttributeAccessor)this.edgeCurve);
        this.edgeTransformation = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.TRANSFORMATION, false);
        accessorMap.add((AttributeAccessor)this.edgeTransformation);
        this.edgeArrow = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.END_ARROW, false);
        accessorMap.add((AttributeAccessor)this.edgeArrow);
        this.edgeFilled = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.FILLED, false);
        accessorMap.add((AttributeAccessor)this.edgeFilled);
        this.edgeColor = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.COLOR, false);
        accessorMap.add((AttributeAccessor)this.edgeColor);
        this.edgeFillColor = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.FILL_COLOR, false);
        accessorMap.add((AttributeAccessor)this.edgeFillColor);
        this.edgeStroke = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.STROKE, false);
        accessorMap.add((AttributeAccessor)this.edgeStroke);
        this.edgeBits = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)EdgeBits.ATTRIBUTE, false);
        accessorMap.add((AttributeAccessor)this.edgeBits);
        this.edgeCaption = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.CAPTION, false);
        accessorMap.add((AttributeAccessor)this.edgeCaption);
        this.edgeWeight = new GraphFilter.AccessorBridge((GraphFilter)this, (Attribute)Attributes.WEIGHT, false);
        accessorMap.add((AttributeAccessor)this.edgeWeight);
    }

    public Attribute[] getDependent(Object object, boolean bl, Attribute attribute) {
        return attribute.toArray();
    }

    protected Attribute[] getDependentOfSource(Object object, boolean bl, Attribute attribute) {
        return attribute == Attributes.NAME ? Attributes.CAPTION.toArray() : Attribute.ATTRIBUTE_0;
    }

    protected boolean isWritable(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return accessorBridge == this.nodeTransform || accessorBridge == this.edgeBits;
    }

    protected GraphState createState(ThreadContext threadContext) {
        return new GraphFilter.State(GraphState.get((Graph)this.source, (ThreadContext)threadContext), threadContext){

            public boolean containsInTree(Object object, boolean bl) {
                return true;
            }
        };
    }

    private synchronized Color3f getColor(int n) {
        Color3f color3f = (Color3f)this.colors.get(n &= 0xFFFFFF);
        if (color3f == null) {
            color3f = new Color3f();
            this.colors.put(n, (Object)IMP.setColor((Tuple3f)color3f, (int)n));
        }
        return color3f;
    }

    protected Object getObject(Object object, GraphFilter.AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        if (accessorBridge == this.nodeTransformation || accessorBridge == this.nodeTransform) {
            return this.getData(object, true, graphState);
        }
        if (accessorBridge == this.nodeShape || accessorBridge == this.nodeEditable) {
            return this.shapeInstance;
        }
        if (accessorBridge == this.nodeShape2D) {
            switch (this.source.getSymbol(object, true)) {
                case 0: {
                    if (collapsedNodes.contains(object)) {
                        return ROUND_RECTANGLE;
                    }
                    return RECTANGLE;
                }
                case 1: {
                    return ROUND_RECTANGLE;
                }
                case 2: {
                    return ELLIPSE;
                }
            }
            return RHOMBUS;
        }
        if (accessorBridge == this.nodeFillColor) {
            return this.getColor(this.source.getColor(object, true));
        }
        if (accessorBridge == this.nodeCaption) {
            return this.source.getDescription(object, true, "Name");
        }
        if (accessorBridge == this.edgeTransformation) {
            ObjectData objectData = this.getData(this.getSourceNode(object), true, graphState);
            ObjectData objectData2 = this.getData(this.getTargetNode(object), true, graphState);
            ObjectData objectData3 = this.getData(object, false, graphState);
            objectData3.x = 0.5 * (objectData.x + objectData2.x);
            objectData3.y = 0.5 * (objectData.y + objectData2.y);
            return objectData3;
        }
        if (accessorBridge == this.edgeShape) {
            return NURBSShape2D.$TYPE.getRepresentative();
        }
        if (accessorBridge == this.edgeCurve) {
            return CONNECTION;
        }
        if (accessorBridge == this.edgeArrow) {
            return EDGE_ARROW;
        }
        if (accessorBridge == this.edgeCaption) {
            int n = this.source.getEdgeBits(object);
            if (n == 256 || n == 512) {
                return null;
            }
            return this.source.getDescription(object, false, "Name");
        }
        if (accessorBridge == this.edgeStroke) {
            int n = this.source.getEdgeBits(object);
            switch (n) {
                case 256: {
                    return SOLID_STROKE;
                }
                case 512: {
                    return DASHED_DOTTED_STROKE;
                }
            }
            return (n & 0x100) != 0 ? SOLID_STROKE : DASHED_STROKE;
        }
        if (accessorBridge == this.edgeColor) {
            int n = this.source.getEdgeBits(object);
            switch (n) {
                case 256: 
                case 512: {
                    return STANDARD_EDGE_COLOR;
                }
            }
            return SPECIAL_EDGE_COLOR;
        }
        if (accessorBridge == this.edgeFillColor) {
            return WHITE;
        }
        if (accessorBridge == this.edgeBits) {
            int n;
            DefaultListModel<EnumValueImpl> defaultListModel = new DefaultListModel<EnumValueImpl>();
            defaultListModel.addElement(new EnumValueImpl(IMP2D.I18N, "topology.special-edge-none", defaultListModel));
            Object object3 = this.source.getSourceNode(object);
            Object object4 = this.source.getTargetNode(object);
            SpecialEdgeDescriptor[] specialEdgeDescriptorArray = this.source.getSpecialEdgeDescriptors(object3, true);
            for (n = 0; n < specialEdgeDescriptorArray.length; ++n) {
                if (!specialEdgeDescriptorArray[n].getNodeClass().isInstance(object4)) continue;
                defaultListModel.addElement(new EnumValueImpl((Object)specialEdgeDescriptorArray[n], defaultListModel));
            }
            specialEdgeDescriptorArray = this.source.getSpecialEdgeDescriptors(object4, false);
            for (n = 0; n < specialEdgeDescriptorArray.length; ++n) {
                if (!specialEdgeDescriptorArray[n].getNodeClass().isInstance(object3)) continue;
                defaultListModel.addElement(new EnumValueImpl((Object)specialEdgeDescriptorArray[n], defaultListModel));
            }
            EdgeBits edgeBits = new EdgeBits(defaultListModel);
            edgeBits.setBits(this.source.getEdgeBits(object));
            return edgeBits;
        }
        return super.getObject(object, accessorBridge, object2, graphState);
    }

    protected int getInt(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        if (accessorBridge == this.nodeHAlignment) {
            return 0;
        }
        return super.getInt(object, accessorBridge, graphState);
    }

    protected float getFloat(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        if (accessorBridge == this.edgeWeight) {
            return 1.0f;
        }
        return super.getFloat(object, accessorBridge, graphState);
    }

    protected boolean getBoolean(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        if (accessorBridge == this.edgeFilled) {
            return false;
        }
        return super.getBoolean(object, accessorBridge, graphState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectData getData(Object object, boolean bl, GraphState graphState) {
        ObjectData objectData = (ObjectData)this.data.getObject(object, bl);
        if (objectData == null) {
            ObjectMapImpl objectMapImpl = this.data;
            synchronized (objectMapImpl) {
                objectData = (ObjectData)this.data.getObject(object, bl);
                if (objectData == null) {
                    objectData = new ObjectData();
                    this.data.putObject(object, bl, (Object)objectData);
                }
            }
        }
        return objectData;
    }

    protected Object setObject(Object object, GraphFilter.AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        if (accessorBridge == this.nodeTransform) {
            this.getData(object, true, graphState).set((Tuple2d)object2);
            EventSupport.Queue queue = ((GraphFilter.State)graphState).getQueue();
            queue.postAttributeChanged(object, true, (Attribute)Attributes.TRANSFORM, null, null);
            queue.postAttributeChanged(object, true, (Attribute)Attributes.TRANSFORMATION, null, null);
            Object object3 = this.getFirstEdge(object);
            while (object3 != null) {
                queue.postAttributeChanged(object3, false, (Attribute)Attributes.TRANSFORMATION, null, null);
                object3 = this.getNextEdge(object3, object);
            }
            return object2;
        }
        if (accessorBridge == this.edgeBits) {
            graphState.setEdgeBits(object, ((EdgeBits)((Object)object2)).bits);
            EventSupport.Queue queue = ((GraphFilter.State)graphState).getQueue();
            queue.postAttributeChanged(object, false, (Attribute)EdgeBits.ATTRIBUTE, null, null);
            queue.postAttributeChanged(object, false, (Attribute)Attributes.COLOR, null, null);
            queue.postAttributeChanged(object, false, (Attribute)Attributes.STROKE, null, null);
            queue.postAttributeChanged(object, false, (Attribute)Attributes.CAPTION, null, null);
            return object2;
        }
        return super.setObject(object, accessorBridge, object2, graphState);
    }

    public int getEdgeBits(Object object) {
        return 512;
    }

    public ObjectAttribute getParentAttribute() {
        return PARENT;
    }

    public EdgePattern getTreePattern() {
        return PATTERN;
    }

    public Object getRoot(String string) {
        return this.source.getRoot(this.root);
    }

    public int getLifeCycleState(Object object, boolean bl) {
        if (bl && collapsedNodes.contains(((Node)object).findAdjacent(true, false, 768))) {
            return 2;
        }
        return super.getLifeCycleState(object, bl);
    }

    public void eventOccured(EventObject eventObject) {
        ClickEvent2D clickEvent2D;
        int n;
        if (eventObject instanceof ClickEvent2D && (n = (clickEvent2D = (ClickEvent2D)((Object)eventObject)).getClickCount()) == 2 && clickEvent2D.getEventType() == 500) {
            Object object = eventObject.getSource();
            ArrayPath arrayPath = (ArrayPath)object;
            if (!arrayPath.endsInNode()) {
                return;
            }
            Object object2 = arrayPath.getNode(arrayPath.getNodeAndEdgeCount() - 1);
            if (collapsedNodes.contains(object2)) {
                collapsedNodes.remove(object2);
            } else {
                collapsedNodes.add(object2);
            }
            clickEvent2D.getView().setTransformation(clickEvent2D.getView().getTransformation());
        }
    }

    public static void collapseAll(Item item, Object object, Context context) {
        Node node = UI.getRootOfProjectGraph((Context)context);
        Visitor visitor = new Visitor(){

            public GraphState getGraphState() {
                return null;
            }

            public Object visitEnter(Path path, boolean bl) {
                if (bl) {
                    collapsedNodes.add(path.getObject(-1));
                }
                return null;
            }

            public Object visitInstanceEnter() {
                return STOP;
            }

            public boolean visitInstanceLeave(Object object) {
                return true;
            }

            public boolean visitLeave(Object object, Path path, boolean bl) {
                return true;
            }
        };
        node.getGraph().accept((Object)node, visitor, null);
        View2D.layout(item, object, context);
    }

    public static void expandAll(Item item, Object object, Context context) {
        collapsedNodes.clear();
        View2D.layout(item, object, context);
    }

    static {
        EDGE_ARROW.setType(1);
        DASHED_STROKE.setLineStyle(1);
        DASHED_DOTTED_STROKE.setLineStyle(3);
        ROUND_RECTANGLE.setFrame(RECTANGLE);
        ELLIPSE.setFrame(RECTANGLE);
        RHOMBUS.setFrame(RECTANGLE);
        PARENT = new Parent();
        PATTERN = new EdgePatternImpl(512, 0, false, true);
    }

    private static final class Parent
    extends ObjectAttribute
    implements EdgeChangeListener,
    ChangeBoundaryListener {
        Parent() {
            super(Type.OBJECT, false, null);
        }

        public boolean isDerived() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getDerived(Object object, boolean bl, Object object2, GraphState graphState) {
            Parent parent = this;
            synchronized (parent) {
                if (this.getAttributeState(graphState) == null) {
                    this.setAttributeState(graphState, new ObjectList());
                    graphState.getGraph().addChangeBoundaryListener((ChangeBoundaryListener)this);
                    graphState.getGraph().addEdgeChangeListener((EdgeChangeListener)this);
                }
            }
            return bl ? null : graphState.getGraph().getSourceNode(object);
        }

        public void beginChange(GraphState graphState) {
            ((ObjectList)this.getAttributeState(graphState)).clear();
        }

        public void endChange(GraphState graphState) {
            ObjectList objectList = (ObjectList)this.getAttributeState(graphState);
            while (!objectList.isEmpty()) {
                graphState.fireAttributeChanged(objectList.pop(), false, (Attribute)this, null, null);
            }
        }

        public int getPriority() {
            return 10;
        }

        public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
            if (object3 != null) {
                ((ObjectList)this.getAttributeState(graphState)).push(object3);
            }
        }
    }
}

