/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d;

import de.grogra.imp.ViewEventHandler;
import de.grogra.imp2d.IMP2D;
import de.grogra.imp2d.View2D;
import de.grogra.util.DisposableEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;

public class Navigator2D
implements DisposableEventListener {
    private final ViewEventHandler handler;
    private int lastX;
    private int lastY;
    private final boolean wheel;

    public Navigator2D(ViewEventHandler viewEventHandler, EventObject eventObject) {
        this.handler = viewEventHandler;
        this.lastX = ((MouseEvent)eventObject).getX();
        this.lastY = ((MouseEvent)eventObject).getY();
        this.wheel = eventObject instanceof MouseWheelEvent;
    }

    public void dispose() {
    }

    public void eventOccured(EventObject eventObject) {
        if (!(eventObject instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        mouseEvent.consume();
        if (this.wheel) {
            if (!(mouseEvent instanceof MouseWheelEvent)) {
                this.handler.disposeNavigator((EventObject)mouseEvent);
                return;
            }
            IMP2D.move((View2D)this.handler.getView(), 0, -((MouseWheelEvent)mouseEvent).getWheelRotation() << 5);
            return;
        }
        switch (mouseEvent.getID()) {
            case 502: 
            case 503: {
                this.handler.disposeNavigator(null);
                return;
            }
            case 506: {
                int n = mouseEvent.getX() - this.lastX;
                int n2 = mouseEvent.getY() - this.lastY;
                if (n == 0 && n2 == 0) {
                    return;
                }
                this.lastX += n;
                this.lastY += n2;
                View2D view2D = (View2D)this.handler.getView();
                if (mouseEvent.isMetaDown()) {
                    IMP2D.zoom(view2D, n, n2);
                    break;
                }
                if (mouseEvent.isAltDown()) {
                    IMP2D.move(view2D, n, n2);
                    break;
                }
                IMP2D.rotate(view2D, n, n2);
            }
        }
    }
}

