/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d;

import de.grogra.graph.impl.Node;
import de.grogra.imp.IMPJobManager;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp2d.View2D;
import de.grogra.imp2d.objects.Connection;
import de.grogra.imp2d.objects.NURBSShape2D;
import de.grogra.pf.registry.Plugin;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.event.DragEvent;
import de.grogra.pf.ui.registry.CommandItem;
import de.grogra.pf.ui.registry.CommandPlugin;
import de.grogra.util.I18NBundle;
import java.awt.geom.RectangularShape;
import javax.vecmath.Matrix3d;

public final class IMP2D
extends Plugin
implements CommandPlugin {
    public static final I18NBundle I18N = I18NBundle.getInstance(IMP2D.class);
    private static IMP2D PLUGIN;

    public static IMP2D getInstance() {
        return PLUGIN;
    }

    public IMP2D() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public void run(Object object, Context context, CommandItem commandItem) {
        ViewSelection viewSelection;
        ViewSelection.Entry[] entryArray;
        String string = commandItem.getName();
        if ("move".equals(string)) {
            DragEvent dragEvent = (DragEvent)object;
            if (dragEvent.draggingContinued()) {
                IMP2D.move((View2D)dragEvent.getPanel(), dragEvent.getDeltaX(), dragEvent.getDeltaY());
            }
        } else if ("zoom".equals(string)) {
            DragEvent dragEvent = (DragEvent)object;
            if (dragEvent.draggingContinued()) {
                IMP2D.zoom((View2D)dragEvent.getPanel(), dragEvent.getDeltaX(), dragEvent.getDeltaY());
            }
        } else if ("rotate".equals(string)) {
            DragEvent dragEvent = (DragEvent)object;
            if (dragEvent.draggingContinued()) {
                IMP2D.rotate((View2D)dragEvent.getPanel(), dragEvent.getDeltaX(), dragEvent.getDeltaY());
            }
        } else if ("addconnection".equals(string) && (entryArray = (viewSelection = ViewSelection.get((Context)context)).getAll(4)).length >= 2) {
            Node node = (Node)entryArray[0].getPath().getObject(-1);
            if (node instanceof NURBSShape2D && ((NURBSShape2D)node).getCurve() instanceof Connection) {
                return;
            }
            Node node2 = (Node)entryArray[1].getPath().getObject(-1);
            if (node2 instanceof NURBSShape2D && ((NURBSShape2D)node2).getCurve() instanceof Connection) {
                return;
            }
            NURBSShape2D nURBSShape2D = new NURBSShape2D(new Connection());
            IMPJobManager iMPJobManager = (IMPJobManager)context.getWorkbench().getJobManager();
            node.addEdgeBitsTo((Node)nURBSShape2D, 513, null);
            nURBSShape2D.addEdgeBitsTo(node2, 128, null);
        }
    }

    static void zoom(View2D view2D, int n, int n2) {
        Matrix3d matrix3d = new Matrix3d(view2D.getTransformation());
        double d = Math.exp(0.01 * (double)(n + n2));
        matrix3d.m00 *= d;
        matrix3d.m10 *= d;
        matrix3d.m01 *= d;
        matrix3d.m11 *= d;
        matrix3d.m02 *= d;
        matrix3d.m12 *= d;
        view2D.setTransformation(matrix3d);
    }

    static void rotate(View2D view2D, int n, int n2) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.rotZ((double)(n - n2) * 0.005);
        matrix3d.mul(view2D.getTransformation());
        view2D.setTransformation(matrix3d);
    }

    static void move(View2D view2D, int n, int n2) {
        Matrix3d matrix3d = new Matrix3d(view2D.getTransformation());
        matrix3d.m02 += (double)n;
        matrix3d.m12 += (double)n2;
        view2D.setTransformation(matrix3d);
    }

    public static void copySize(RectangularShape rectangularShape, Object object) {
        if (object instanceof RectangularShape) {
            RectangularShape rectangularShape2 = (RectangularShape)object;
            double d = rectangularShape2.getWidth();
            double d2 = rectangularShape2.getHeight();
            rectangularShape.setFrame(-0.5 * d, -0.5 * d2, d, d2);
        }
    }
}

