/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp2d;

import de.grogra.graph.ArrayPath;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.Visitor;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.awt.CanvasAdapter;
import de.grogra.imp.edit.Tool;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp2d.AWTDrawable;
import de.grogra.imp2d.View2D;
import de.grogra.imp2d.Visitor2D;
import de.grogra.imp2d.objects.Attributes;
import de.grogra.math.Pool;
import de.grogra.pf.ui.Context;
import de.grogra.vecmath.Math2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import javax.vecmath.Matrix3d;

public class AWTCanvas2D
extends CanvasAdapter {
    public static final Stroke STROKE_1 = new BasicStroke();
    public static final Stroke STROKE_3 = new BasicStroke(3.0f);
    public final Pool pool = new Pool();
    private DrawVisitor visitor = new DrawVisitor();
    private int canvasWidth;
    private int canvasHeight;
    private int currentLayer;
    private int minLayer = 0;
    private int maxLayer = 2;
    private final AffineTransform transform = new AffineTransform();
    private final GeneralPath drawPath = new GeneralPath();

    public AWTCanvas2D() {
        this.initCanvas((Component)new CanvasAdapter.CanvasComponent((CanvasAdapter)this, 640, 480));
    }

    public View2D getView2D() {
        return (View2D)this.getView();
    }

    protected void initPaint(int n, int n2, int n3) {
        this.canvasWidth = n2;
        this.canvasHeight = n3;
    }

    protected void paintScene(int n, Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.setTransform(IDENTITY);
        graphics2D.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        this.visitor.init(this.getRenderGraphState(), 0, 0);
        this.currentLayer = this.getMaxLayer();
        while (this.currentLayer >= this.getMinLayer()) {
            this.getView().getGraph().accept(null, (Visitor)this.visitor, null);
            --this.currentLayer;
        }
    }

    protected void paintHighlight(int n, Graphics2D graphics2D) {
        if (ViewSelection.get((Context)this.getView()) == null) {
            System.err.println("NULL");
            return;
        }
        ArrayPath arrayPath = new ArrayPath(this.getView().getGraph());
        ViewSelection.Entry[] entryArray = ViewSelection.get((Context)this.getView()).getAll(-1);
        this.currentLayer = this.getMaxLayer();
        while (this.currentLayer >= this.getMinLayer()) {
            for (int i = 0; i < entryArray.length; ++i) {
                Path path = entryArray[i].getPath();
                this.visitor.init(this.getRenderGraphState(), entryArray[i].getValue(), path.getNodeAndEdgeCount());
                GraphUtils.acceptPath((Path)path, (Visitor)this.visitor, (ArrayPath)arrayPath);
            }
            --this.currentLayer;
        }
        Tool tool = this.getView().getActiveTool();
        if (tool != null) {
            this.visitor.init(GraphManager.STATIC_STATE, 0, 0);
            arrayPath.clear((Graph)GraphManager.STATIC);
            for (int i = 0; i < tool.getToolCount(); ++i) {
                GraphManager.acceptGraph((Node)tool.getRoot(i), (Visitor)this.visitor, (ArrayPath)arrayPath);
            }
        }
    }

    protected void finalizePaint() {
    }

    public int getWidth() {
        return this.canvasWidth;
    }

    public int getHeight() {
        return this.canvasHeight;
    }

    public int getCurrentLayer() {
        return this.currentLayer;
    }

    public int getMinLayer() {
        return this.minLayer;
    }

    public int getMaxLayer() {
        return this.maxLayer;
    }

    public boolean isCurrentLayer(int n) {
        return n == this.currentLayer || this.currentLayer == this.minLayer && n < this.minLayer || this.currentLayer == this.maxLayer && n > this.maxLayer;
    }

    public void setGraphicsTransform(Matrix3d matrix3d) {
        Math2.setAffineTransform((AffineTransform)this.transform, (Matrix3d)matrix3d);
        this.getGraphics().setTransform(this.transform);
    }

    public void draw(Shape shape, Matrix3d matrix3d, Stroke stroke) {
        Math2.setAffineTransform((AffineTransform)this.transform, (Matrix3d)matrix3d);
        PathIterator pathIterator = shape.getPathIterator(this.transform);
        this.drawPath.reset();
        this.drawPath.setWindingRule(pathIterator.getWindingRule());
        this.drawPath.append(pathIterator, false);
        this.resetGraphicsTransform();
        Graphics2D graphics2D = this.getGraphics();
        graphics2D.setStroke(stroke);
        graphics2D.draw(this.drawPath);
    }

    public void setColor(Color color) {
        this.getGraphics().setColor(color);
    }

    private class DrawVisitor
    extends Visitor2D {
        private int selectionState;
        private int minPathLength;

        private DrawVisitor() {
        }

        void init(GraphState graphState, int n, int n2) {
            this.init(graphState, graphState.getGraph().getTreePattern(), ((View2D)AWTCanvas2D.this.getView()).getCanvasTransformation());
            this.selectionState = n;
            this.minPathLength = n2;
        }

        protected void visitImpl(Object object, boolean bl, Path path) {
            Object object2;
            if (path.getNodeAndEdgeCount() - (bl ? 0 : 1) >= this.minPathLength && (object2 = this.state.getObjectDefault(object, bl, Attributes.SHAPE, null)) instanceof AWTDrawable) {
                ((AWTDrawable)object2).draw(object, bl, AWTCanvas2D.this, this.transformation, this.selectionState);
            }
        }
    }
}

