/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.util.IntList;

public class XBitSet {
    private int[] bits;
    private int capacity;

    public XBitSet() {
        this(256);
    }

    public XBitSet(int n) {
        this.bits = new int[Math.max(n, 32) + 31 >> 5];
        this.capacity = this.bits.length << 5;
    }

    private void ensureCapacity(int n) {
        int n2 = this.bits.length;
        if ((n = n + 31 >> 5) > n2) {
            this.bits = new int[n];
            IntList.arraycopy(this.bits, 0, this.bits, 0, this.capacity >> 5);
            this.capacity = n << 5;
        } else {
            n2 = this.capacity >> 5;
            if (n > n2) {
                IntList.clear(this.bits, n2, n - n2);
                this.capacity = n << 5;
            }
        }
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.ensureCapacity(n + 1);
            int n2 = n >> 5;
            this.bits[n2] = this.bits[n2] | 1 << n;
        } else if (n < this.capacity) {
            int n3 = n >> 5;
            this.bits[n3] = this.bits[n3] & ~(1 << n);
        }
    }

    public void set(int n) {
        this.ensureCapacity(n + 1);
        int n2 = n >> 5;
        this.bits[n2] = this.bits[n2] | 1 << n;
    }

    public void setRange(int n, int n2, boolean bl) {
        block6: {
            block5: {
                if (!bl) break block5;
                this.ensureCapacity(n2 + 1);
                for (int i = n; i < n2; ++i) {
                    if ((i & 0x1F) == 0 && i + 32 <= n2) {
                        this.bits[i >> 5] = -1;
                        i += 31;
                        continue;
                    }
                    int n3 = i >> 5;
                    this.bits[n3] = this.bits[n3] | 1 << i;
                }
                break block6;
            }
            if (n >= this.capacity) break block6;
            if (n2 > this.capacity) {
                n2 = this.capacity;
            }
            for (int i = n; i < n2; ++i) {
                if ((i & 0x1F) == 0 && i + 32 <= n2) {
                    this.bits[i >> 5] = 0;
                    i += 31;
                    continue;
                }
                int n4 = i >> 5;
                this.bits[n4] = this.bits[n4] & ~(1 << i);
            }
        }
    }

    public boolean add(int n) {
        this.ensureCapacity(n + 1);
        if ((this.bits[n >> 5] & 1 << n) == 0) {
            int n2 = n >> 5;
            this.bits[n2] = this.bits[n2] | 1 << n;
            return true;
        }
        return false;
    }

    public boolean remove(int n) {
        this.ensureCapacity(n + 1);
        if (n < this.capacity && (this.bits[n >> 5] & 1 << n) != 0) {
            int n2 = n >> 5;
            this.bits[n2] = this.bits[n2] & ~(1 << n);
            return true;
        }
        return false;
    }

    public boolean flip(int n) {
        if (n >= this.capacity) {
            this.set(n);
            return false;
        }
        if ((this.bits[n >> 5] & 1 << n) != 0) {
            int n2 = n >> 5;
            this.bits[n2] = this.bits[n2] & ~(1 << n);
            return true;
        }
        int n3 = n >> 5;
        this.bits[n3] = this.bits[n3] | 1 << n;
        return false;
    }

    public void clear(int n) {
        if (n < this.capacity) {
            int n2 = n >> 5;
            this.bits[n2] = this.bits[n2] & ~(1 << n);
        }
    }

    public boolean get(int n) {
        return n < this.capacity && (this.bits[n >> 5] & 1 << n) != 0;
    }

    public int getBits(int n) {
        return n < this.capacity ? this.bits[n >> 5] : 0;
    }

    public void setBits(int n, int n2) {
        this.ensureCapacity(n + 1);
        this.bits[n >> 5] = n2;
    }

    public void set(XBitSet xBitSet) {
        this.capacity = xBitSet.capacity;
        this.bits = (int[])xBitSet.bits.clone();
    }

    public boolean intersects(XBitSet xBitSet) {
        int n = Math.min(this.capacity, xBitSet.capacity) >> 5;
        int[] nArray = this.bits;
        int[] nArray2 = xBitSet.bits;
        while (--n >= 0) {
            if ((nArray[n] & nArray2[n]) == 0) continue;
            return true;
        }
        return false;
    }

    public void andNot(XBitSet xBitSet, XBitSet xBitSet2) {
        this.ensureCapacity(xBitSet.capacity);
        this.capacity = xBitSet.capacity;
        int n = this.capacity >> 5;
        int n2 = xBitSet2.capacity >> 5;
        int[] nArray = xBitSet.bits;
        int[] nArray2 = xBitSet2.bits;
        int[] nArray3 = this.bits;
        if (nArray3 == nArray && n > n2) {
            n = n2;
        }
        while (--n >= 0) {
            nArray3[n] = n >= n2 ? nArray[n] : nArray[n] & ~nArray2[n];
        }
    }

    public void and(XBitSet xBitSet, XBitSet xBitSet2) {
        int n = Math.min(xBitSet.capacity, xBitSet2.capacity);
        this.ensureCapacity(n);
        this.capacity = n;
        n >>= 5;
        int[] nArray = xBitSet.bits;
        int[] nArray2 = xBitSet2.bits;
        int[] nArray3 = this.bits;
        while (--n >= 0) {
            nArray3[n] = nArray[n] & nArray2[n];
        }
    }

    public void or(XBitSet xBitSet, XBitSet xBitSet2) {
        int n = Math.max(xBitSet.capacity, xBitSet2.capacity);
        this.ensureCapacity(n);
        this.capacity = n;
        n >>= 5;
        int n2 = xBitSet.capacity >> 5;
        int n3 = xBitSet2.capacity >> 5;
        int[] nArray = xBitSet.bits;
        int[] nArray2 = xBitSet2.bits;
        int[] nArray3 = this.bits;
        while (--n >= 0) {
            nArray3[n] = n >= n3 ? nArray[n] : (n >= n2 ? nArray2[n] : nArray[n] | nArray2[n]);
        }
    }

    public int cardinality() {
        int n = this.capacity >> 5;
        int n2 = 0;
        while (--n >= 0) {
            n2 += Integer.bitCount(this.bits[n]);
        }
        return n2;
    }

    public void clear() {
        this.setRange(0, this.capacity, false);
    }

    public final int nextSetBit(int n) {
        if (n >= this.capacity) {
            return -1;
        }
        int n2 = this.bits[n >> 5];
        while (true) {
            if ((n & 0x1F) == 0) {
                while ((n2 = this.bits[n >> 5]) == 0) {
                    if ((n += 32) < this.capacity) continue;
                    return -1;
                }
            }
            do {
                if ((n2 & 1 << n) != 0) {
                    return n;
                }
                if (++n != this.capacity) continue;
                return -1;
            } while ((n & 0x1F) != 0);
        }
    }

    public final int nextClearBit(int n) {
        if (n >= this.capacity) {
            return -1;
        }
        int n2 = this.bits[n >> 5];
        while (true) {
            if ((n & 0x1F) == 0) {
                while ((n2 = this.bits[n >> 5]) == -1) {
                    if ((n += 32) < this.capacity) continue;
                    return -1;
                }
            }
            do {
                if ((n2 & 1 << n) == 0) {
                    return n;
                }
                if (++n != this.capacity) continue;
                return -1;
            } while ((n & 0x1F) != 0);
        }
    }

    public final int nextBit(int n, boolean bl) {
        return bl ? this.nextSetBit(n) : this.nextClearBit(n);
    }

    public int size() {
        return this.capacity;
    }

    public void addToList(IntList intList) {
        int n = 0;
        for (int i = 0; i < this.capacity; ++i) {
            if ((i & 0x1F) == 0) {
                n = this.bits[i >> 5];
            }
            if ((n & 1 << i) == 0) continue;
            intList.add(i);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (int i = 0; i < this.capacity; ++i) {
            if (!this.get(i)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(i);
        }
        return stringBuffer.append('}').toString();
    }
}

