/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.DoubleConsumer;
import de.grogra.xl.lang.VoidToDoubleGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.DoubleBuffer;

public class DoubleList
implements Cloneable,
Serializable,
DoubleConsumer,
VoidToDoubleGenerator {
    private static final long serialVersionUID = -1901586723349450417L;
    public transient double[] elements;
    public int size = 0;
    private static final double[] EMPTY = new double[0];
    private static final double[] DOUBLE_NULL = new double[1024];

    public DoubleList(int n) {
        this.elements = new double[Math.max(n, 8)];
    }

    public DoubleList() {
        this(16);
    }

    public DoubleList(double[] dArray) {
        this(dArray.length);
        this.size = dArray.length;
        DoubleList.arraycopy(dArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            DoubleList doubleList = (DoubleList)super.clone();
            doubleList.elements = new double[Math.max(this.size, 8)];
            DoubleList.arraycopy(this.elements, 0, doubleList.elements, 0, this.size);
            return doubleList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            double[] dArray = new double[Math.max(n, this.elements.length * 2)];
            DoubleList.arraycopy(this.elements, 0, dArray, 0, this.size);
            this.elements = dArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new double[this.size];
                DoubleList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final DoubleList push(double d) {
        this.add(d);
        return this;
    }

    public final DoubleList push(double d, double d2) {
        this.add(d);
        this.add(d2);
        return this;
    }

    public final DoubleList push(double d, double d2, double d3) {
        this.add(d);
        this.add(d2);
        this.add(d3);
        return this;
    }

    public boolean add(double d) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = d;
        ++this.size;
        return true;
    }

    public void add(int n, double d) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            DoubleList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            DoubleList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = d;
        ++this.size;
    }

    public void addIfNotContained(double d) {
        if (!this.contains(d)) {
            this.add(d);
        }
    }

    public DoubleList addAll(DoubleList doubleList) {
        return this.addAll(doubleList.elements, 0, doubleList.size);
    }

    public DoubleList addAll(double[] dArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        DoubleList.arraycopy(dArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public double removeAt(int n) {
        double d = this.elements[n];
        DoubleList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return d;
    }

    public boolean remove(double d) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (d != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public double set(int n, double d) {
        double d2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            DoubleList.clear(this.elements, this.size, n - this.size);
            d2 = this.elements[n];
            this.elements[n] = d;
            this.size = n + 1;
        } else {
            d2 = this.elements[n];
            this.elements[n] = d;
        }
        return d2;
    }

    public double get(int n) {
        return n < this.size ? this.elements[n] : 0.0;
    }

    public double peek(int n) {
        return n > 0 ? this.elements[this.size - n] : 0.0;
    }

    public boolean contains(double d) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (d != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (d != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double d) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (d != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(double d) {
        return DoubleList.binarySearch(this.elements, d, 0, this.size);
    }

    public static int binarySearch(double[] dArray, double d) {
        return DoubleList.binarySearch(dArray, d, 0, dArray.length);
    }

    public static int binarySearch(double[] dArray, double d, int n, int n2) {
        while (n < n2) {
            double d2;
            int n3 = n + n2 >> 1;
            double d3 = dArray[n3];
            if (d2 < d) {
                n = n3 + 1;
                continue;
            }
            if (d3 > d) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(DoubleBuffer doubleBuffer) {
        doubleBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (n3 < 20) {
            if (dArray2 != dArray || n2 > n) {
                while (--n3 >= 0) {
                    dArray2[n2 + n3] = dArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    dArray2[n2 + i] = dArray[n + i];
                }
            }
        } else {
            System.arraycopy(dArray, n, dArray2, n2, n3);
        }
    }

    public static void clear(double[] dArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                dArray[n + n2] = 0.0;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                DoubleList.arraycopy(DOUBLE_NULL, 0, dArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public double pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public double[] toArray() {
        double[] dArray = new double[this.size];
        DoubleList.arraycopy(this.elements, 0, dArray, 0, this.size);
        return dArray;
    }

    public double[] toArray(double[] dArray) {
        int n = dArray.length;
        if (n > this.size) {
            dArray[this.size] = 0.0;
        } else if (n < this.size) {
            dArray = new double[this.size];
        }
        DoubleList.arraycopy(this.elements, 0, dArray, 0, this.size);
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoubleList)) {
            return false;
        }
        DoubleList doubleList = (DoubleList)object;
        if (this.size != doubleList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == doubleList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.elements[i]);
            n = 31 * n + ((int)l ^ (int)(l >>> 32));
        }
        return n;
    }

    public void consume(double d) {
        this.add(d);
    }

    public void evaluateDouble(DoubleConsumer doubleConsumer) {
        for (int i = 0; i < this.size; ++i) {
            doubleConsumer.consume(this.elements[i]);
        }
    }

    public void values(DoubleConsumer doubleConsumer) {
        this.evaluateDouble(doubleConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeDouble(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new double[this.size];
        double[] dArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            dArray[i] = objectInputStream.readDouble();
        }
    }
}

