/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vfs;

import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.TreeModelSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.FileNameMap;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class FileSystem
extends TreeModelSupport
implements TreeModel {
    public static final MimeType MIME_TYPE = new MimeType("application/x-grogra-fs", null);
    protected FileNameMap fileNameMap;
    protected Manifest manifest = new Manifest();
    private final String protocol;
    private final String fsName;
    private static Charset DEFAULT_CHARSET;

    public FileSystem(String string, String string2) {
        super(true);
        this.fsName = string;
        this.protocol = string2;
    }

    public String getFSName() {
        return this.fsName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public abstract boolean isPersistent();

    public abstract void delete(Object var1) throws IOException;

    public abstract String getName(Object var1);

    public abstract URL toURL(Object var1);

    public abstract Object toFile(URL var1);

    public abstract Object getParent(Object var1);

    public abstract boolean isReadOnly(Object var1);

    public abstract long getTime(Object var1);

    public abstract void setTime(Object var1, long var2);

    public abstract long getSize(Object var1);

    public abstract Object getRoot();

    public abstract Object[] listFiles(Object var1);

    public abstract Object getFile(Object var1, String var2);

    public boolean equals(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public Object create(Object object, String string, boolean bl) throws IOException {
        return this.create(object, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Object object, String string, boolean bl, boolean bl2) throws IOException {
        Object object2;
        FileSystem fileSystem = this;
        synchronized (fileSystem) {
            if (bl2) {
                int n = string.lastIndexOf(46);
                String string2 = n < 0 ? string : string.substring(0, n);
                String string3 = n < 0 ? "" : string.substring(n);
                n = 0;
                while (this.getFile(object, string) != null) {
                    string = string2 + ++n + string3;
                }
            }
            object2 = this.createImpl(object, string, bl);
        }
        return this.fireInserted(object2);
    }

    protected abstract Object createImpl(Object var1, String var2, boolean var3) throws IOException;

    protected Object fireInserted(Object object) {
        if (object instanceof TreeModelEvent) {
            this.fireTreeModelEvent(1, (TreeModelEvent)object);
            return FileSystem.getFile((TreeModelEvent)object);
        }
        return object;
    }

    public abstract InputStream getInputStream(Object var1) throws IOException;

    public abstract OutputStream getOutputStream(Object var1, boolean var2) throws IOException;

    public Reader getReader(Object object) throws IOException {
        return new InputStreamReader(this.getInputStream(object), this.getCharset(object));
    }

    public Writer getWriter(Object object, boolean bl) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(object, bl), this.getCharset(object));
    }

    private static synchronized Charset getDefaultCharset() {
        if (DEFAULT_CHARSET == null) {
            DEFAULT_CHARSET = Charset.forName(new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding());
        }
        return DEFAULT_CHARSET;
    }

    public Charset getCharset(Object object) {
        Object object2;
        MimeType mimeType = this.getMimeType(object);
        Charset charset = null;
        if (mimeType != null && (object2 = mimeType.getParameter("charset")) != null && Charset.isSupported((String)object2)) {
            charset = Charset.forName((String)object2);
        }
        if (charset == null) {
            charset = FileSystem.getDefaultCharset();
            if (mimeType != null) {
                object2 = mimeType.getParameters();
                ((StringMap)object2).put("charset", (Object)charset.name());
                mimeType = new MimeType(mimeType.getMediaType(), (StringMap)object2, mimeType.getRepresentationClass());
                this.setMimeType(object, mimeType);
            }
        }
        return charset;
    }

    public void setFileNameMap(FileNameMap fileNameMap) {
        this.fileNameMap = fileNameMap;
    }

    public MimeType getMimeType(Object object) {
        MimeType mimeType = MimeType.valueOf(this.getAttribute(object, Attributes.Name.CONTENT_TYPE));
        return mimeType != null ? mimeType : (this.fileNameMap == null ? MimeType.OCTET_STREAM : MimeType.valueOf(this.fileNameMap.getContentTypeFor(this.getName(object))));
    }

    public void setMimeType(Object object, MimeType mimeType) {
        String string;
        MimeType mimeType2;
        if (mimeType.getParameter("charset") == null && (mimeType2 = MimeType.valueOf(this.getAttribute(object, Attributes.Name.CONTENT_TYPE))) != null && (string = mimeType2.getParameter("charset")) != null) {
            StringMap stringMap = mimeType.getParameters();
            stringMap.put("charset", (Object)string);
            mimeType = new MimeType(mimeType.getMediaType(), stringMap, mimeType.getRepresentationClass());
        }
        this.getAttributes(object, true).put(Attributes.Name.CONTENT_TYPE, mimeType.toString());
    }

    public void setManifest(Manifest manifest) {
        if (manifest != this.manifest) {
            this.manifest = manifest;
        }
    }

    public final Manifest getManifest() {
        return this.manifest;
    }

    public synchronized Object getFile(String string) {
        int n;
        if ("/".equals(string)) {
            return this.getRoot();
        }
        int n2 = string.charAt(0) == '/' ? 1 : 0;
        Object object = this.getRoot();
        do {
            object = this.getFile(object, (n = string.indexOf(47, n2)) >= 0 ? string.substring(n2, n) : string.substring(n2));
            n2 = n + 1;
        } while (object != null && n >= 0 && n2 != string.length());
        return object;
    }

    public synchronized String getPath(Object object) {
        if (this.equals(object, this.getRoot())) {
            return "/";
        }
        StringBuffer stringBuffer = new StringBuffer(this.getName(object));
        while (!this.equals(object = this.getParent(object), this.getRoot())) {
            stringBuffer.insert(0, '/');
            stringBuffer.insert(0, this.getName(object));
        }
        return stringBuffer.toString();
    }

    public final String getPathWithLeadingSlash(Object object) {
        String string = this.getPath(object);
        return string.charAt(0) == '/' ? string : '/' + string;
    }

    public synchronized TreePath getTreePath(Object object) {
        if (this.equals(object, this.getRoot())) {
            return new TreePath(object);
        }
        Object object2 = this.getParent(object);
        if (object2 == null) {
            return null;
        }
        TreePath treePath = this.getTreePath(object2);
        return treePath != null ? treePath.pathByAddingChild(object) : null;
    }

    public synchronized TreeModelEvent getEventFor(Object object) {
        Object object2 = this.getParent(object);
        return new TreeModelEvent((Object)this, this.getTreePath(object2), new int[]{this.getIndexOfChild(object2, object)}, new Object[]{object});
    }

    public int getChildCount(Object object) {
        return this.listFiles(object).length;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Object[] objectArray = this.listFiles(object);
        if (objectArray == null) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.equals(object2, objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public Object getChild(Object object, int n) {
        return this.listFiles(object)[n];
    }

    public static boolean isContainedInChildren(Object object, TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        if (objectArray == null) {
            return false;
        }
        FileSystem fileSystem = (FileSystem)treeModelEvent.getSource();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!fileSystem.equals(object, objectArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Object getFile(TreeModelEvent treeModelEvent) {
        Object[] objectArray = treeModelEvent.getChildren();
        return objectArray == null ? treeModelEvent.getTreePath().getLastPathComponent() : objectArray[0];
    }

    public Attributes getAttributes(Object object, boolean bl) {
        String string = this.getManifestName(object);
        if (string.length() == 0) {
            return this.manifest.getMainAttributes();
        }
        Attributes attributes = this.manifest.getAttributes(string);
        if (attributes == null && bl) {
            attributes = new Attributes();
            this.manifest.getEntries().put(string, attributes);
        }
        return attributes;
    }

    public String getAttribute(Object object, Attributes.Name name) {
        Attributes attributes = this.getAttributes(object, false);
        return attributes == null ? null : attributes.getValue(name);
    }

    public String getAttribute(Object object, String string) {
        Attributes attributes = this.getAttributes(object, false);
        return attributes == null ? null : attributes.getValue(string);
    }

    protected synchronized String getManifestName(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object2;
        while ((object2 = this.getParent(object)) != null) {
            if (!this.isLeaf(object)) {
                stringBuffer.insert(0, '/');
            }
            stringBuffer.insert(0, this.getName(object));
            object = object2;
        }
        return stringBuffer.toString();
    }

    public void readJar(InputStream inputStream, boolean bl) throws IOException {
        JarEntry jarEntry;
        JarInputStream jarInputStream = new JarInputStream(inputStream, bl);
        this.setManifest(jarInputStream.getManifest());
        byte[] byArray = new byte[262144];
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            Object object;
            Object object2;
            int n;
            if (jarEntry.isDirectory()) continue;
            String string = jarEntry.getName();
            Object object3 = this.getRoot();
            int n2 = 0;
            while ((n = string.indexOf(47, n2)) >= 0) {
                object2 = string.substring(n2, n);
                object = this.getFile(object3, (String)object2);
                if (object == null) {
                    object = this.create(object3, (String)object2, true);
                }
                object3 = object;
                n2 = n + 1;
            }
            object2 = this.create(object3, string.substring(n2), false);
            object = this.getOutputStream(object2, false);
            while ((n = jarInputStream.read(byArray, 0, byArray.length)) >= 0) {
                if (object == null) continue;
                ((OutputStream)object).write(byArray, 0, n);
            }
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            if (jarEntry.getTime() <= 0L) continue;
            this.setTime(object2, jarEntry.getTime());
        }
    }

    public void writeJar(OutputStream outputStream) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream, this.getManifest());
        this.writeJar(jarOutputStream, new byte[262144], this.getRoot());
        jarOutputStream.flush();
        jarOutputStream.close();
    }

    private void writeJar(JarOutputStream jarOutputStream, byte[] byArray, Object object) throws IOException {
        if (!this.isLeaf(object)) {
            Object[] objectArray = this.listFiles(object);
            for (int i = 0; i < objectArray.length; ++i) {
                this.writeJar(jarOutputStream, byArray, objectArray[i]);
            }
        } else {
            int n;
            ZipEntry zipEntry = new ZipEntry(this.getPath(object));
            zipEntry.setSize(this.getSize(object));
            zipEntry.setTime(this.getTime(object));
            jarOutputStream.putNextEntry(zipEntry);
            InputStream inputStream = this.getInputStream(object);
            while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            jarOutputStream.closeEntry();
        }
    }

    public void copyFilesTo(Collection collection, FileSystem fileSystem) throws IOException {
        byte[] byArray = new byte[262144];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.copyFileTo(iterator.next(), fileSystem, byArray);
        }
    }

    public Object copyFileTo(Object object, FileSystem fileSystem) throws IOException {
        return this.copyFileTo(object, fileSystem, new byte[262144]);
    }

    public void copyFileTo(Object object, FileSystem fileSystem, Object object2) throws IOException {
        this.copyFileTo(object, fileSystem, object2, true, new byte[262144]);
    }

    public Object copyFileToDirectory(Object object, FileSystem fileSystem, Object object2) throws IOException {
        object2 = fileSystem.create(object2, this.getName(object), false);
        this.copyFileTo(object, fileSystem, object2, true, new byte[262144]);
        return object2;
    }

    public Object copyFileToDirectory(Object object, FileSystem fileSystem, Object object2, String string) throws IOException {
        object2 = fileSystem.create(object2, string, false);
        this.copyFileTo(object, fileSystem, object2, true, new byte[262144]);
        return object2;
    }

    private Object copyFileTo(Object object, FileSystem fileSystem, byte[] byArray) throws IOException {
        if (this.equals(object, this.getRoot())) {
            return fileSystem.getRoot();
        }
        Object object2 = object;
        object = fileSystem.create(this.getTargetDirectory(this.getParent(object), fileSystem), this.getName(object), false);
        this.copyFileTo(object2, fileSystem, object, true, byArray);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileTo(Object object, FileSystem fileSystem, Object object2, boolean bl, byte[] byArray) throws IOException {
        Attributes attributes;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = this.getInputStream(object);
            outputStream = fileSystem.getOutputStream(object2, false);
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        fileSystem.setTime(object2, this.getTime(object));
        if (bl && (attributes = this.getAttributes(object, false)) != null && !attributes.isEmpty()) {
            fileSystem.getAttributes(object2, true).putAll((Map<?, ?>)attributes);
        }
    }

    public Object addLocalFile(File file, Object object, String string) throws IOException {
        object = this.create(object, string, false);
        super.copyFileTo(file, this, object, false, new byte[262144]);
        return object;
    }

    private Object getTargetDirectory(Object object, FileSystem fileSystem) throws IOException {
        return this.equals(object, this.getRoot()) ? fileSystem.getRoot() : fileSystem.create(this.getTargetDirectory(this.getParent(object), fileSystem), this.getName(object), true);
    }

    public void removeNonlistedAttributes(Collection collection) {
        StringMap stringMap = new StringMap(collection.size());
        Object object = collection.iterator();
        while (object.hasNext()) {
            stringMap.put(this.getManifestName(object.next()), (Object)this);
        }
        object = this.getManifest().getEntries();
        Object[] objectArray = object.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (stringMap.containsKey(objectArray[i])) continue;
            object.remove(objectArray[i]);
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected class Out
    extends OutputStream {
        private final Object file;
        private OutputStream out;

        public Out(OutputStream outputStream, Object object) {
            this.out = outputStream;
            this.file = object;
        }

        public void write(int n) throws IOException {
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            OutputStream outputStream;
            Out out = this;
            synchronized (out) {
                outputStream = this.out;
                if (outputStream == null) {
                    return;
                }
                this.out = null;
            }
            outputStream.close();
            FileSystem.this.fireTreeModelEvent(0, FileSystem.this.getEventFor(this.file));
        }
    }
}

