/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

public class Unit {
    private final String name;
    private final double factor;
    private final boolean check;

    public Unit(String string, double d, boolean bl) {
        this.name = string;
        this.factor = d;
        this.check = bl;
    }

    public double toUnit(double d) {
        return d / this.factor;
    }

    public double fromUnit(double d) {
        return d * this.factor;
    }

    public boolean checkWhenChoosing() {
        return this.check;
    }

    public float getRatio(float f) {
        if (f == 0.0f) {
            return -1.0f;
        }
        if ((f = Math.abs(f) / (float)this.factor) > 1.0f) {
            f = 1.0f / f;
        }
        return f;
    }

    public boolean isSpecified(String string) {
        int n = string.lastIndexOf(this.name);
        if (!(n < 0 || n != 0 && Character.isLetter(string.charAt(n - 1)))) {
            n += this.name.length();
            while (n < string.length()) {
                if (Character.isWhitespace(string.charAt(n++))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(float f) {
        return (float)this.toUnit(f) + " " + this.name;
    }

    public String toString(double d) {
        return this.toUnit(d) + " " + this.name;
    }

    public double parse(String string) throws NumberFormatException {
        int n = string.lastIndexOf(this.name);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        string = string.trim();
        return this.fromUnit(Double.parseDouble(string));
    }
}

