/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.ObjectList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class TreeDiff {
    private TreeModel oldTree;
    private TreeModel newTree;
    private NodeModel model;
    private Object eventSource;
    private TreeModelListener listener;
    private boolean removed;
    private boolean inserted;
    private DiffInfo firstMatch;
    private int optCount;
    private int maxCount;
    private int optLen;
    private final ObjectList oldPath = new ObjectList(10);
    private final ObjectList newPath = new ObjectList(10);

    public boolean compare(TreeModel treeModel, TreeModel treeModel2, NodeModel nodeModel, Object object, TreeModelListener treeModelListener) {
        this.oldTree = treeModel;
        this.newTree = treeModel2;
        this.model = nodeModel;
        this.eventSource = object;
        this.listener = treeModelListener;
        this.oldPath.clear();
        this.newPath.clear();
        this.removed = false;
        this.inserted = false;
        this.compare(treeModel.getRoot(), treeModel2.getRoot(), new boolean[32]);
        return this.removed || this.inserted;
    }

    private boolean[] compare(Object object, Object object2, boolean[] blArray) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2;
        this.oldPath.push(object);
        this.newPath.push(object2);
        this.firstMatch = null;
        this.maxCount = 0;
        DiffInfo diffInfo = null;
        int n3 = this.oldTree.getChildCount(object);
        int n4 = this.newTree.getChildCount(object2);
        if (n4 > blArray.length) {
            blArray = new boolean[n4];
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                blArray[n2] = false;
            }
        }
        block1: for (n2 = 0; n2 < n3; ++n2) {
            objectArray2 = this.oldTree.getChild(object, n2);
            for (n = 0; n < n4; ++n) {
                if (blArray[n] || !this.model.equals(objectArray2, objectArray = this.newTree.getChild(object2, n))) continue;
                blArray[n] = true;
                DiffInfo diffInfo2 = this.model.getDiffInfo(objectArray);
                diffInfo2.oldNode = objectArray2;
                diffInfo2.matchIndex = n;
                diffInfo2.inOptMatch = false;
                diffInfo2.nextMatch = null;
                this.maxCount += this.getTreeCount(objectArray);
                if (diffInfo == null) {
                    this.firstMatch = diffInfo2;
                } else {
                    diffInfo.nextMatch = diffInfo2;
                }
                diffInfo = diffInfo2;
                continue block1;
            }
        }
        this.optLen = 0;
        this.optCount = 0;
        this.findOptMatch(this.firstMatch, -1, 0);
        if (n3 > this.optLen) {
            DiffInfo diffInfo3 = this.firstMatch;
            objectArray2 = new int[n3 - this.optLen];
            objectArray = new Object[n3 - this.optLen];
            n = 0;
            for (int i = 0; i < n3; ++i) {
                Object object3 = this.oldTree.getChild(object, i);
                if (diffInfo3 != null && object3 == diffInfo3.oldNode) {
                    if (!diffInfo3.inOptMatch) {
                        objectArray2[n] = i;
                        objectArray[n++] = object3;
                    }
                    diffInfo3 = diffInfo3.nextMatch;
                    continue;
                }
                objectArray2[n] = i;
                objectArray[n++] = object3;
            }
            assert (diffInfo3 == null);
            assert (n == objectArray2.length);
            this.removed = true;
            this.listener.treeNodesRemoved(new TreeModelEvent(this.eventSource, this.oldPath.toArray(), (int[])objectArray2, objectArray));
        }
        if (n4 > this.optLen) {
            int[] nArray = new int[n4 - this.optLen];
            objectArray2 = new Object[n4 - this.optLen];
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                Object object4 = this.newTree.getChild(object2, n);
                if (blArray[n] && this.model.getDiffInfo((Object)object4).inOptMatch) continue;
                nArray[n5] = n;
                objectArray2[n5++] = object4;
            }
            assert (n5 == nArray.length);
            this.inserted = true;
            this.listener.treeNodesInserted(new TreeModelEvent(this.eventSource, this.newPath.toArray(), nArray, objectArray2));
        }
        DiffInfo diffInfo4 = this.firstMatch;
        while (diffInfo4 != null) {
            if (diffInfo4.inOptMatch) {
                blArray = this.compare(diffInfo4.oldNode, diffInfo4.node, blArray);
            }
            diffInfo = diffInfo4.nextMatch;
            diffInfo4.nextMatch = null;
            diffInfo4.oldNode = null;
            diffInfo4 = diffInfo;
        }
        this.oldPath.pop();
        this.newPath.pop();
        return blArray;
    }

    private void findOptMatch(DiffInfo diffInfo, int n, int n2) {
        if (diffInfo == null) {
            if (n2 > this.optCount) {
                this.optCount = n2;
                this.optLen = 0;
                DiffInfo diffInfo2 = this.firstMatch;
                while (diffInfo2 != null) {
                    diffInfo2.inOptMatch = diffInfo2.matchIndex >= 0;
                    if (diffInfo2.inOptMatch) {
                        ++this.optLen;
                    }
                    diffInfo2 = diffInfo2.nextMatch;
                }
            }
        } else if (this.optCount < this.maxCount) {
            int n3 = diffInfo.matchIndex;
            if (n3 > n) {
                this.findOptMatch(diffInfo.nextMatch, n3, n2 + diffInfo.treeCount);
            }
            diffInfo.matchIndex = -1;
            this.findOptMatch(diffInfo.nextMatch, n, n2);
            diffInfo.matchIndex = n3;
        }
    }

    private int getTreeCount(Object object) {
        int n = 1;
        int n2 = this.newTree.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            n += this.getTreeCount(this.newTree.getChild(object, i));
        }
        this.model.getDiffInfo((Object)object).treeCount = n;
        return this.model.getDiffInfo((Object)object).treeCount;
    }

    public static final class DiffInfo {
        final Object node;
        Object oldNode;
        DiffInfo nextMatch;
        int matchIndex;
        int treeCount;
        boolean inOptMatch;

        public DiffInfo(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.node = object;
        }
    }

    public static interface NodeModel {
        public boolean equals(Object var1, Object var2);

        public DiffInfo getDiffInfo(Object var1);
    }
}

