/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.TreeModelSupport;
import de.grogra.xl.lang.ObjectToBoolean;
import java.util.Comparator;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Tree
extends TreeModelSupport
implements TreeModel {
    protected Node root;

    public Tree(Node node) {
        super(false);
        this.root = node;
    }

    public boolean isLeaf(Object object) {
        return ((Node)object).children == null;
    }

    public Object getChild(Object object, int n) {
        return ((Node)object).getChild(n);
    }

    public Object getParent(Object object) {
        return ((Node)object).parent;
    }

    public int getChildCount(Object object) {
        return ((Node)object).getChildCount();
    }

    public int getIndexOfChild(Object object, Object object2) {
        Node node = ((Node)object).children;
        if (node == null) {
            return -1;
        }
        int n = 0;
        while (!this.nodesEqual(node, (Node)object2)) {
            ++n;
            node = node.next;
            if (node != null) continue;
            return -1;
        }
        return n;
    }

    public boolean nodesEqual(Node node, Node node2) {
        return node.equals(node2);
    }

    public final int getIndexOfChild(Node node) {
        return this.getIndexOfChild(node.parent, node);
    }

    public Object getRoot() {
        return this.root;
    }

    public static Object findFirst(TreeModel treeModel, Object object, ObjectToBoolean objectToBoolean) {
        if (objectToBoolean.evaluateBoolean(object)) {
            return object;
        }
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Tree.findFirst(treeModel, treeModel.getChild(object, i), objectToBoolean);
            if (object2 == null) continue;
            return object2;
        }
        return null;
    }

    public static Object findMax(TreeModel treeModel, Object object, Comparator comparator) {
        return Tree.findMax(treeModel, object, comparator, null);
    }

    public static Object findMax(TreeModel treeModel, Object object, Comparator comparator, Object object2) {
        if (comparator.compare(object, object2) > 0) {
            object2 = object;
        }
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            object2 = Tree.findMax(treeModel, treeModel.getChild(object, i), comparator, object2);
        }
        return object2;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public boolean hasValidPath(Node node) {
        if (node == null) {
            return false;
        }
        while (!this.nodesEqual(node, this.root)) {
            Node node2 = node.parent;
            if (node2 == null || this.getIndexOfChild(node2, node) < 0) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    public static class Node {
        public Node next = null;
        public Node children = null;
        public Node parent = null;

        public Node setNext(Node node) {
            this.next = node;
            while (node != null) {
                node.parent = this.parent;
                node = node.next;
            }
            return this;
        }

        public Node setChildren(Node node) {
            this.children = node;
            while (node != null) {
                node.parent = this;
                node = node.next;
            }
            return this;
        }

        public void addChild(Node node) {
            if (this.children == null) {
                this.setChildren(node);
            } else {
                this.children.getLastSibling().setNext(node);
            }
        }

        public void insertChild(Node node, int n) {
            Node node2 = null;
            Node node3 = this.children;
            while (node3 != null && n-- != 0) {
                node2 = node3;
                node3 = node3.next;
            }
            if (node2 == null) {
                this.children = node;
            } else {
                node2.next = node;
            }
            while (node.next != null) {
                node.parent = this;
                node = node.next;
            }
            node.parent = this;
            node.next = node3;
        }

        public Node insertChainBefore(Node node) {
            if (node == null) {
                return null;
            }
            Node node2 = this.parent.children;
            if (node2 == this) {
                this.parent.children = node;
            } else {
                while (node2.next != this) {
                    node2 = node2.next;
                }
                node2.next = node;
            }
            while (true) {
                node.parent = this.parent;
                if (node.next == null) {
                    node.next = this;
                    return node;
                }
                node = node.next;
            }
        }

        public void replace(Node node, boolean bl) {
            Node node2 = this.parent.children;
            if (node2 == this) {
                this.parent.children = node;
            } else {
                while (node2.next != this) {
                    node2 = node2.next;
                }
                node2.next = node;
            }
            node.parent = this.parent;
            node.next = this.next;
            if (!bl) {
                node.children = this.children;
                node2 = this.children;
                while (node2 != null) {
                    node2.parent = node;
                    node2 = node2.next;
                }
                this.children = null;
            }
        }

        public Node getLastSibling() {
            Node node = this;
            while (node.next != null) {
                node = node.next;
            }
            return node;
        }

        public void removeChild(Node node) {
            Node node2 = this.children;
            if (node2 == node) {
                this.children = node.next;
            } else {
                while (node2.next != node) {
                    node2 = node2.next;
                    if (node2 != null) continue;
                    return;
                }
                node2.next = node.next;
            }
            node.next = null;
            node.parent = null;
        }

        public void remove() {
            Node node = this.parent.children;
            if (node == this) {
                this.parent.children = this.next;
            } else {
                while (node.next != this) {
                    node = node.next;
                }
                node.next = this.next;
            }
        }

        public void removeLastChild() {
            Node node = this.children;
            if (node != null) {
                if (node.next == null) {
                    this.children = null;
                } else {
                    while (node.next.next != null) {
                        node = node.next;
                    }
                    node.next = null;
                }
            }
        }

        public int getChildCount() {
            Node node = this.children;
            int n = 0;
            while (node != null) {
                ++n;
                node = node.next;
            }
            return n;
        }

        public Node getChild(int n) {
            Node node = this.children;
            while (--n >= 0) {
                node = node.next;
                if (node != null) continue;
                return null;
            }
            return node;
        }

        public Node[] getChildren() {
            int n = this.getChildCount();
            Node[] nodeArray = new Node[n];
            n = -1;
            Node node = this.children;
            while (node != null) {
                nodeArray[++n] = node;
                node = node.next;
            }
            return nodeArray;
        }

        public Node[] getPath() {
            int n = 0;
            Node[] nodeArray = this;
            while (nodeArray != null) {
                ++n;
                nodeArray = nodeArray.parent;
            }
            nodeArray = new Node[n];
            Object object = this;
            while (object != null) {
                nodeArray[--n] = object;
                object = object.parent;
            }
            return nodeArray;
        }

        public TreePath getTreePath() {
            return new TreePath(this.getPath());
        }
    }
}

