/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.MimeType;
import de.grogra.util.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.IIOByteBuffer;

public class PPMReader {
    public static final MimeType MIME_TYPE = new MimeType("image/x-portable-pixmap", null);
    int width = -1;
    int height;
    BufferedImage image;
    private final int minLines;
    private boolean use16bit;
    private int factor;
    private int linesRead = 0;
    private int buffer = -2;
    private IIOByteBuffer buf = new IIOByteBuffer(new byte[2048], 0, 2048);
    private int bufPos = 0;
    private int bufEnd = 0;
    private final InputStream input;

    public PPMReader(InputStream inputStream, int n) {
        this.input = inputStream;
        this.minLines = n;
    }

    public static String getDescription() {
        return Utils.I18N.msg("ppmimagereader.description");
    }

    private int readByte() throws IOException {
        int n;
        if (this.buffer != -2) {
            n = this.buffer;
            this.buffer = -2;
        } else {
            if (this.bufPos == this.bufEnd) {
                this.readBytes(this.buf, 2048);
                this.bufPos = this.buf.getOffset();
                this.bufEnd = this.bufPos + this.buf.getLength();
            }
            int n2 = n = this.bufPos >= this.bufEnd ? -1 : this.buf.getData()[this.bufPos++] & 0xFF;
        }
        if (n < 0) {
            throw new IOException();
        }
        return n;
    }

    protected void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(this.input.read(iIOByteBuffer.getData(), 0, n));
    }

    private int read(boolean bl) throws IOException {
        int n;
        block0: while (true) {
            n = this.readByte();
            if (!bl) break;
            if (n == 35) {
                while (true) {
                    if (n == 10 || n == 13) continue block0;
                    n = this.readByte();
                }
            }
            if (!Character.isWhitespace((char)n)) break;
        }
        return n;
    }

    private int readInt() throws IOException {
        int n = this.read(true);
        int n2 = 0;
        while (!Character.isWhitespace((char)n)) {
            if (n < 48 || n > 57) {
                throw new IOException();
            }
            n2 = n2 * 10 + (n - 48);
            n = this.read(false);
        }
        return n2;
    }

    private int readPixel() throws IOException {
        int n = 255;
        for (int i = 0; i < 3; ++i) {
            int n2 = this.read(false);
            if (n2 < 0) {
                throw new IOException();
            }
            if (this.use16bit) {
                int n3 = this.read(false);
                if (n3 < 0) {
                    throw new IOException();
                }
                n2 = (n2 << 8) + n3;
            }
            n = (n << 8) + (n2 * this.factor >>> 8);
        }
        return n;
    }

    private void scanlinesRead(int n) {
        this.scanlinesRead(this.linesRead, n - this.linesRead);
        this.linesRead = n;
    }

    protected void scanlinesRead(int n, int n2) {
    }

    public BufferedImage read() throws IOException {
        if (this.read(true) != 80 || this.read(false) != 54) {
            throw new IOException();
        }
        this.width = this.readInt();
        this.height = this.readInt();
        this.image = new BufferedImage(this.width, this.height, 1);
        int n = this.readInt();
        this.use16bit = n > 255;
        this.factor = 65536 / n;
        int[] nArray = new int[this.width];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                nArray[j] = this.readPixel();
            }
            this.image.setRGB(0, i, this.width, 1, nArray, 0, 1);
            if (i + 1 - this.linesRead < this.minLines) continue;
            this.scanlinesRead(i + 1);
        }
        if (this.linesRead < this.height) {
            this.scanlinesRead(this.height);
        }
        return this.image;
    }
}

