/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import java.io.Serializable;

public final class MimeType
implements Serializable {
    private static final long serialVersionUID = -2211034175691969125L;
    private static final StringMap EMPTY = new StringMap();
    public static final MimeType INVALID = new MimeType("invalid/invalid", null);
    public static final MimeType TEXT_PLAIN = new MimeType("text/plain", null);
    public static final MimeType TEXT_XML = new MimeType("text/xml", null);
    public static final MimeType TEXT_HTML = new MimeType("text/html", null);
    public static final MimeType APPLICATION_XML = new MimeType("application/xml", null);
    public static final MimeType OCTET_STREAM = new MimeType("application/octet-stream", null);
    public static final MimeType GZIP = new MimeType("application/x-gzip", null);
    public static final MimeType JAR = new MimeType("application/x-jar", null);
    public static final MimeType CSV = new MimeType("text/x-csv", null);
    public static final MimeType PDF = new MimeType("application/pdf", null);
    public static final MimeType POSTSCRIPT = new MimeType("application/postscript", null);
    public static final MimeType PNG = new MimeType("image/png", null);
    public static final MimeType TEXT_SCI = new MimeType("text/sci", null);
    public static final String WRAPPED_TYPE_PARAM = "wrapped-type";
    public static final String CLASS_PARAM = "class";
    public static final String JAVA_OBJECT = "application/x-java-jvm-local-objectref";
    private final String mediaType;
    private final String primaryType;
    private final String subType;
    private final String comment;
    private final StringMap params;
    private final Class clazz;
    private transient int pos;
    private transient String buf;
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";
    private transient StringBuffer cbuf = null;
    private transient boolean inComment = false;

    private int peekc() {
        if (this.pos >= this.buf.length()) {
            return -1;
        }
        if (!this.inComment && this.buf.charAt(this.pos) == '(') {
            if (this.cbuf == null) {
                this.cbuf = new StringBuffer();
            } else {
                this.cbuf.append(' ');
            }
            this.inComment = true;
            this.parseComment();
            this.inComment = false;
            return this.peekc();
        }
        return this.buf.charAt(this.pos);
    }

    private int getc() {
        int n = this.peekc();
        ++this.pos;
        return n;
    }

    private void consumeWhitespace() {
        while (Character.isWhitespace((char)this.peekc())) {
            this.getc();
        }
    }

    private void consume(char c) {
        if (this.getc() != c) {
            throw new IllegalArgumentException(this.buf);
        }
    }

    private String parseToken() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.peekc()) > 32 && n < 127 && TSPECIALS.indexOf(n) < 0) {
            stringBuffer.append((char)this.getc());
        }
        if (stringBuffer.length() == 0) {
            throw new IllegalArgumentException(this.buf);
        }
        return stringBuffer.toString();
    }

    private String parseQuoted() {
        int n;
        this.consume('\"');
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.getc()) != 34) {
            if (n < 0) {
                throw new IllegalArgumentException(this.buf);
            }
            stringBuffer.append((char)(n == 92 ? this.getc() : n));
        }
        return stringBuffer.toString();
    }

    private void parseComment() {
        int n;
        this.consume('(');
        while ((n = this.peekc()) != 41) {
            if (n < 0) {
                throw new IllegalArgumentException(this.buf);
            }
            if (n == 40) {
                this.cbuf.append('(');
                this.parseComment();
                this.cbuf.append(')');
                continue;
            }
            ++this.pos;
            this.cbuf.append((char)(n == 92 ? this.getc() : n));
        }
        this.consume(')');
    }

    public MimeType(String string, StringMap stringMap, Class clazz) {
        this.mediaType = string;
        this.clazz = clazz;
        int n = string.indexOf(47);
        this.primaryType = string.substring(0, n);
        this.subType = string.substring(n + 1);
        if (stringMap != null) {
            this.params = stringMap.dup();
            if (clazz != null) {
                this.params.remove(CLASS_PARAM);
            }
        } else {
            this.params = EMPTY;
        }
        this.comment = null;
    }

    public MimeType(String string, StringMap stringMap) {
        this(string, stringMap, null);
    }

    public MimeType(String string) {
        this.pos = 0;
        this.buf = string;
        this.consumeWhitespace();
        this.primaryType = this.parseToken().toLowerCase();
        this.consume('/');
        this.subType = this.parseToken().toLowerCase();
        this.consumeWhitespace();
        StringMap stringMap = null;
        while (this.getc() == 59) {
            this.consumeWhitespace();
            String string2 = this.parseToken().toLowerCase();
            this.consumeWhitespace();
            this.consume('=');
            this.consumeWhitespace();
            String string3 = this.peekc() == 34 ? this.parseQuoted() : this.parseToken();
            this.consumeWhitespace();
            if (stringMap == null) {
                stringMap = new StringMap();
            }
            stringMap.put(string2, (Object)string3);
        }
        if (this.pos < this.buf.length()) {
            throw new IllegalArgumentException(this.buf);
        }
        this.cbuf = null;
        this.buf = null;
        this.mediaType = this.primaryType + '/' + this.subType;
        this.clazz = null;
        this.params = stringMap != null ? stringMap : EMPTY;
        this.comment = this.cbuf == null ? null : this.cbuf.toString();
    }

    public static MimeType valueOf(Class clazz) {
        return new MimeType(JAVA_OBJECT, null, clazz);
    }

    public static MimeType valueOf(String string) {
        return string == null ? null : new MimeType(string);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getComment() {
        return this.comment;
    }

    public String getParameter(String string) {
        return CLASS_PARAM.equals(string) && this.clazz != null ? this.clazz.getName() : (String)this.params.get(string);
    }

    public StringMap getParameters() {
        StringMap stringMap = this.params.dup();
        if (this.clazz != null) {
            stringMap.put(CLASS_PARAM, (Object)this.clazz.getName());
        }
        return stringMap;
    }

    public Class getRepresentationClass() {
        return this.clazz;
    }

    public boolean isXMLMimeType() {
        return this.mediaType.equals(TEXT_XML) || this.mediaType.equals(APPLICATION_XML) || this.subType.endsWith("+xml");
    }

    public boolean isAssignableFrom(MimeType mimeType) {
        return MimeType.isAssignableFrom(this.mediaType, mimeType.mediaType) && (this.getParameter(WRAPPED_TYPE_PARAM) == null || MimeType.isAssignableFrom(this.getParameter(WRAPPED_TYPE_PARAM), mimeType.getParameter(WRAPPED_TYPE_PARAM))) && (this.clazz == null || mimeType.clazz != null && this.clazz.isAssignableFrom(mimeType.clazz));
    }

    public static boolean isAssignableFrom(String string, String string2) {
        return (string.equals(string2) || string.equals(OCTET_STREAM.getMediaType())) && !string.equals("invalid/invalid") && !string2.equals("invalid/invalid");
    }

    public boolean equals(Object object) {
        return object == this || object instanceof MimeType && ((MimeType)object).mediaType.equals(this.mediaType) && Utils.equal(((MimeType)object).clazz, this.clazz);
    }

    public int hashCode() {
        return this.mediaType.hashCode() ^ (this.clazz != null ? this.clazz.hashCode() : 0);
    }

    public String toString() {
        StringMap stringMap = this.params;
        if (this.clazz == null && stringMap.size() == 0) {
            return this.mediaType;
        }
        StringBuffer stringBuffer = new StringBuffer(this.mediaType);
        for (int i = 0; i < stringMap.size(); ++i) {
            String string = (String)stringMap.getValueAt(i);
            if (string == null) continue;
            stringBuffer.append("; ").append(stringMap.getKeyAt(i)).append('=').append(MimeType.quoteParameter(string));
        }
        if (this.clazz != null) {
            stringBuffer.append("; ").append(CLASS_PARAM).append('=').append(MimeType.quoteParameter(this.clazz.getName()));
        }
        if (this.comment != null) {
            stringBuffer.append(" (").append(this.comment).append(')');
        }
        return stringBuffer.toString();
    }

    public static String quoteParameter(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0) continue;
            return Utils.quote(string);
        }
        return string;
    }
}

