/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.IntList;

public class Int2IntMap {
    private int[] keys;
    private int[] values;
    private int size;

    public Int2IntMap(int n) {
        if (n < 4) {
            n = 4;
        }
        this.keys = new int[n];
        this.values = new int[n];
    }

    public Int2IntMap() {
        this(16);
    }

    public Int2IntMap(int[] nArray, int n, int n2) {
        this(n2);
        System.arraycopy(nArray, n, this.keys, 0, n2);
        this.size = n2;
    }

    public Int2IntMap dup() {
        Int2IntMap int2IntMap = new Int2IntMap(this.size);
        System.arraycopy(this.keys, 0, int2IntMap.keys, 0, this.size);
        System.arraycopy(this.values, 0, int2IntMap.values, 0, this.size);
        int2IntMap.size = this.size;
        return int2IntMap;
    }

    public int[] getKeys(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.keys, 0, nArray, 0, this.size);
        return nArray;
    }

    public int[] getValues(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
        } else if (nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.values, 0, nArray, 0, this.size);
        return nArray;
    }

    public final synchronized int synchronizedPut(int n, int n2) {
        return this.put(n, n2);
    }

    public final int put(int n, int n2) {
        int n3 = IntList.binarySearch(this.keys, n, 0, this.size);
        if (n3 >= 0) {
            int n4 = this.values[n3];
            this.values[n3] = n2;
            return n4;
        }
        n3 ^= 0xFFFFFFFF;
        if (this.keys.length == this.size) {
            this.keys = new int[2 * this.size];
            System.arraycopy(this.keys, 0, this.keys, 0, this.size);
            this.values = new int[2 * this.size];
            System.arraycopy(this.values, 0, this.values, 0, this.size);
        }
        if (n3 < this.size) {
            System.arraycopy(this.keys, n3, this.keys, n3 + 1, this.size - n3);
            System.arraycopy(this.values, n3, this.values, n3 + 1, this.size - n3);
        }
        this.keys[n3] = n;
        this.values[n3] = n2;
        ++this.size;
        return 0;
    }

    public final int get(int n) {
        int n2 = IntList.binarySearch(this.keys, n, 0, this.size);
        return n2 >= 0 ? this.values[n2] : 0;
    }

    public final synchronized int synchronizedGet(int n) {
        return this.get(n);
    }

    public final int remove(int n) {
        int n2 = IntList.binarySearch(this.keys, n, 0, this.size);
        if (n2 >= 0) {
            int n3 = this.values[n2];
            --this.size;
            System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.size - n2);
            System.arraycopy(this.values, n2 + 1, this.values, n2, this.size - n2);
            return n3;
        }
        return 0;
    }

    public final synchronized int synchronizedRemove(int n) {
        return this.remove(n);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public int getKeyAt(int n) {
        return this.keys[n];
    }

    public int getValueAt(int n) {
        return this.values[n];
    }

    public int findIndex(int n) {
        return IntList.binarySearch(this.keys, n, 0, this.size);
    }

    public void setValueAt(int n, int n2) {
        this.values[n] = n2;
    }
}

