/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.reflect;

import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeImpl;
import de.grogra.xl.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionType
extends TypeImpl<Object> {
    private final String pkg;
    private Type baseType;
    private ObjectList<Type<?>> interfaces = new ObjectList();

    public IntersectionType(String string) {
        super(0, "intersection", null, 1, null, null, null);
        this.baseType = Type.OBJECT;
        this.pkg = string;
    }

    public IntersectionType(Type<?> type) {
        this(type.getPackage());
        this.intersect(type);
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public Type<Object> getSupertype() {
        return this.baseType;
    }

    @Override
    public Type<?> getComponentType() {
        return this.baseType.getComponentType();
    }

    @Override
    public boolean isInstance(Object object) {
        if (object == null || !this.baseType.isInstance(object)) {
            return false;
        }
        for (int i = this.interfaces.size - 1; i >= 0; --i) {
            if (this.interfaces.get(i).isInstance(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDeclaredInterfaceCount() {
        return this.interfaces.size;
    }

    @Override
    public Type<?> getDeclaredInterface(int n) {
        return this.interfaces.get(n);
    }

    private void narrowAccess(Type<?> type) {
    }

    public void narrow(Type<?> type) {
        if (Reflection.isSuperclassOrSame(type, this.baseType)) {
            return;
        }
        for (int i = this.interfaces.size - 1; i >= 0; --i) {
            if (!Reflection.isSupertypeOrSame(this.interfaces.get(i), type)) continue;
            this.interfaces.remove(i);
        }
        this.baseType = type;
        this.modifiers |= type.getModifiers() & 0x100010;
        this.narrowAccess(type);
    }

    public void addInterface(Type<?> type) {
        if (!Reflection.isSupertypeOrSame(type, (Type)this)) {
            this.interfaces.add(type);
        }
        this.narrowAccess(type);
    }

    public void intersect(Type<?> type) {
        if (type instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)type;
            this.narrow(intersectionType.baseType);
            for (int i = 0; i < intersectionType.interfaces.size(); ++i) {
                this.addInterface(intersectionType.interfaces.get(i));
            }
        } else if ((type.getModifiers() & 0x200) != 0) {
            this.addInterface(type);
        } else {
            this.narrow(type);
        }
    }

    public Type<?> simplify() {
        switch (this.interfaces.size) {
            case 0: {
                return this.baseType;
            }
            case 1: {
                return Reflection.equal(this.baseType, Type.OBJECT) ? this.getDeclaredInterface(0) : this;
            }
        }
        return this;
    }

    @Override
    public Class<Object> getImplementationClass() {
        return (this.interfaces.size() == 1 && Reflection.equal(this.baseType, Type.OBJECT) ? this.getDeclaredInterface(0) : this.baseType).getImplementationClass();
    }

    public Type<?> getBinaryType() {
        return this.interfaces.size() == 1 && Reflection.equal(this.baseType, Type.OBJECT) ? this.getDeclaredInterface(0) : this.baseType;
    }

    @Override
    public String getDescriptor() {
        return 'L' + this.getBinaryName().replace('.', '/') + ';';
    }

    @Override
    public String getName() {
        if (this.interfaces.isEmpty()) {
            return this.baseType.getName();
        }
        StringBuffer stringBuffer = new StringBuffer().append('(').append(this.baseType.getName());
        for (int i = 0; i < this.interfaces.size; ++i) {
            stringBuffer.append(" & ").append(this.getDeclaredInterface(i).getName());
        }
        return stringBuffer.append(')').toString();
    }

    @Override
    public String getSimpleName() {
        if (this.interfaces.isEmpty()) {
            return this.baseType.getSimpleName();
        }
        StringBuffer stringBuffer = new StringBuffer().append('(').append(this.baseType.getSimpleName());
        for (int i = 0; i < this.interfaces.size; ++i) {
            stringBuffer.append(" & ").append(this.getDeclaredInterface(i).getSimpleName());
        }
        return stringBuffer.append(')').toString();
    }

    @Override
    public String getBinaryName() {
        StringBuffer stringBuffer = new StringBuffer(this.baseType.getBinaryName());
        for (int i = 0; i < this.interfaces.size; ++i) {
            stringBuffer.append('&').append(this.getDeclaredInterface(i).getBinaryName());
        }
        return stringBuffer.toString();
    }
}

